function gui_size(command_str)
% GUI_SIZE
% examples/chap10/gui_size.m
%
% Example of user on-the-fly defined pop-up-menu.
if nargin < 1
	command_str = 'initialize';
end

if ~strcmp(command_str,'initialize')
	handles = get(gcf,'userdata');
	h_text = handles(1);
	h_editsize = handles(2);
	h_popsize = handles(3);
end

if strcmp(command_str,'initialize')
    h_fig = figure('position',[200 200 200 100],...
			'resize','off',...
			'name','String Sizer',...
			'numbertitle','off',...
            'MenuBar','none');
	
  h_ax = axes('position',[0 .5 1 .5],...
	'visible','off',...
	'xlim',[0 1],'ylim',[0 1]);
				
  h_text = text(.5,.5,0,'String',...
	'FontSize',10,...
	'HorizontalAlignment','center',...
	'VerticalAlignment','middle');

  h_editsize = uicontrol(h_fig,...
	'callback','gui_size(''Sized by Edit'');',...
	'style','edit',...
	'position',[70 15 30 20],...
	'string','10');
		
  h_popsize = uicontrol(h_fig,...
	'callback','gui_size(''Sized by Popup'');',...
	'style','pop',...
	'position',[110 15 30 20],...
	'string',' 5|10|15|20',...
	'value',2);
	
  handles = [h_text h_editsize h_popsize];
  set(h_fig,'userdata',handles);

elseif strcmp(command_str,'Sized by Popup')
  option_sizes = get(h_popsize,'string');
  choice = get(h_popsize,'value');
  set(h_editsize,'string',option_sizes(choice,:));
  set(h_text,'fontsize',str2num(option_sizes(choice,:)));

elseif strcmp(command_str,'Sized by Edit')
  option_sizes = str2num(get(h_popsize,'string'));
  size_choice = floor(str2num(get(h_editsize,'string')));

  % MAKE SURE THE USER'S INPUT IS A LEGAL FONT SIZE.
  if size_choice > 0
	if any(option_sizes == size_choice)
	% IF THE USER'S CHOICE EXISTS IN THE LIST, USE IT.
	  choice = find(option_sizes == size_choice);
	  set(h_popsize,'value',choice);
	  set(h_editsize,'string',num2str(option_sizes(choice)));
	  set(h_text,'fontsize',option_sizes(choice));
	else
	% OTHERWISE CREATE A NEW OPTION IN THE MENU LIST,
	% PUTTING IT IN THE RIGHT SORTED POSITION.
	  option_sizes = [option_sizes; floor(size_choice)];
	  [new_opt_sizes,ind] = sort(option_sizes);
	  choice = find(ind == length(new_opt_sizes));

	  new_pop_str = sprintf('%3d',new_opt_sizes);
	  new_pop_str = reshape(new_pop_str,...
			     3,length(new_opt_sizes))';
		
	  set(h_popsize,'string',new_pop_str);
	  set(h_popsize,'value',choice);
	  set(h_editsize,...
		'string',num2str(new_opt_sizes(choice)));
	  set(h_text,'fontsize',new_opt_sizes(choice));
    end
  else
	choice = get(h_popsize,'value');
	set(h_editsize,'string',num2str(option_sizes(choice)));
  end

end % END command_str comparison checks.
