function gui_sldr(command_str)
% GUI_SLDR
% examples/chap10/gui_sldr.m
%
% Example of creating slider GUIs.

if nargin < 1
	command_str = 'initialize';
end

if ~strcmp(command_str,'initialize')
	handles = get(gcf,'userdata');
	h_sldr = handles(1);
	h_val = handles(2);
end
if strcmp(command_str,'initialize')

	h_fig = figure('position',[100 200 200 75],...
		'resize','off',...
		'numbertitle','off',...
		'name','Slider GUI',...
        'MenuBar','none');
		
	h_frame = uicontrol(h_fig,...
		'style','frame',...
		'position',[0 0 200 75]);
		
	h_sldr = uicontrol(h_fig,...
		'callback','gui_sldr(''Slider Moved'');',...
		'style','slider',...
		'min',-15,'max',15,...
		'position',[25 20 150 20]);

	h_min = uicontrol(h_fig,...
		'style','text',...
		'string',num2str(get(h_sldr,'min')),...
		'position',[25 45 25 20]);
	
	h_max = uicontrol(h_fig,...
		'style','text',...
		'string',num2str(get(h_sldr,'max')),...
		'position',[150 45 25 20]);
	
	h_val = uicontrol(h_fig,...
		'callback','gui_sldr(''Change Value'');',...
		'style','edit',...
		'string',num2str(get(h_sldr,'value')),...
		'position',[80 45 40 20]);

	handles = [h_sldr h_val];
	set(h_fig,'userdata',handles);
elseif strcmp(command_str,'Change Value')
	user_value = str2num(get(h_val,'string'));
	if ~length(user_value)
	 user_value = (get(h_sldr,'max')+get(h_sldr,'min'))/2;
	end
	user_value = min([user_value get(h_sldr,'max')]);
	user_value = max([user_value get(h_sldr,'min')]);
	set(h_sldr,'value',user_value);
	set(h_val,'string',num2str(get(h_sldr,'value')));

elseif strcmp(command_str,'Slider Moved')
	set(h_val,'string',num2str(get(h_sldr,'value')));

end
