function [name] = gui_togm(command_str)
% GUI_TOGM
% examples/chap10/gui_togm.m
%
% Example of a GUI that toggles menus.

if nargin < 1
	command_str = 'initialize';
end

if ~strcmp(command_str,'initialize')
	handles = get(gcf,'userdata');
	h_menu_opt = handles(1);
	h_menu = handles(2:4);
end

if strcmp(command_str,'initialize')

	h_fig = figure('position',[200 200 200 50],...
				 'resize','off',...
				 'numbertitle','off',...
				 'menubar','none');
	h_menu_opt = uimenu('label','Options',...
		'callback','gui_togm(''Set Menu Labels'');');
	h_menu(1) = uimenu(h_menu_opt,'label','Properties...');
	h_menu(2) = uimenu(h_menu_opt,'label','','visible','off')
	h_menu(3) = uimenu(h_menu_opt,'label','',...
	                   'visible','off');
	
	handles = [h_menu_opt,h_menu];
	set(gcf,'userdata',handles);
	gui_togm('Set Menu Labels');
	
elseif strcmp(command_str,'Set Menu Labels')
	seltyp = get(gcf,'selectiontype');
	if strcmp(seltyp,'normal')
	  set(h_menu(1),'label','Properties','visible','on');
	  set(h_menu(2),'label','','visible','off');
	  set(h_menu(3),'label','','visible','off');
	elseif strcmp(seltyp,'alt')
	  set(h_menu(1),'label','Alternate Properties',...
	                'visible','on');
	  set(h_menu(2),'label','Delete Alternates',...
	                'visible','on');
	  set(h_menu(3),'label','Copy Alternates',...
	                'visible','on');
	elseif strcmp(seltyp,'extend')
	  set(h_menu(1),'label','Cut','visible','on');
	  set(h_menu(2),'label','Copy','visible','on');
	  set(h_menu(3),'label','Paste','visible','on');
	elseif strcmp(seltyp,'open')
	  set(h_menu(1),'label','Open 1','visible','on');
	  set(h_menu(2),'label','Open 2','visible','off');
	  set(h_menu(3),'label','Open 3','visible','on');
	end
end
