function gui_wave(command_str,Argument2)
% GUI_WAVE
% examples/chap10/gui_wave.m
%
% Example of mutually exclusive radio button coding

if nargin < 1
	command_str = 'initialize';
end

if ~strcmp(command_str,'initialize')
	handles = get(gcf,'userdata');
	h_radio = handles(1:3);
end

if strcmp(command_str,'initialize')

	h_fig = figure('position',[200 200 120 100],...
               'resize','off',...
               'numbertitle','off',...
               'MenuBar','none');
	% Create Frame that covers entire
	h_frame = uicontrol(h_fig,'style','frame',...
                          'position',[0 0 120 100]);
	% Create overall label
	h_stext = uicontrol(h_fig,'style','text',...
                          'string','Waveform Type',...
                          'position',[10 75 100 20]);
	% Create set of 3 Radio buttons
	h_radio(1) = uicontrol(h_fig,'style','radio',...
                          'callback','gui_wave(''Waveform Change'',1);',...
                          'string','Square Wave',...
                          'position',[10 55 100 20],...
                          'value',1);
	h_radio(2) = uicontrol(h_fig,'style','radio',...
                          'callback','gui_wave(''Waveform Change'',2);',...
                          'string','Saw Tooth Wave',...
                          'position',[10 30 100 20]);
	h_radio(3) = uicontrol(h_fig,'style','radio',...
                          'callback','gui_wave(''Waveform Change'',3);',...
                          'string','Sinusoidal Wave',...
                          'position',[10 5 100 20]);

	handles = [h_radio];
	set(h_fig,'userdata',handles);

elseif strcmp(command_str,'Waveform Change')
	num_buttons = length(h_radio);
	button = Argument2;
	if get(h_radio(button),'value') == 1
	  set(h_radio([1:(button-1), (button+1):num_buttons]),'value',0);
	else
	  set(h_radio(button),'value',1);
	end

end % END command_str comparison check
