function gui_wind(command_str)
% GUI_WIND
% examples/chap10/gui_wind.m
%
% Example of creating windowed GUIs.

if nargin < 1
	command_str = 'initialize';
end

if ~strcmp(command_str,'initialize')
	handles = get(gcf,'userdata');
	h_cube = handles(1);
	h_dir = handles(2);
	h_xrot = handles(3);
	h_yrot = handles(4);
end
if strcmp(command_str,'initialize')

	h_fig = figure('position',[100 200 300 250],...
		'resize','off',...
		'numbertitle','off',...
		'name','Windowed GUI',...
        'MenuBar','none');
	
	h_s(1) = uicontrol('style','text',...
			'position',[0 0 1 .25],...
			'units','normalized');
	h_s(2) = uicontrol('style','text',...
			'position',[0 0 .1 1],...
			'units','normalized');
	h_s(3) = uicontrol('style','text',...
			'position',[0 .9 1 .1],...
			'units','normalized');
	h_s(4) = uicontrol('style','text',...
			'position',[.9 0 .1 1],...
			'units','normalized');
	h_push = uicontrol(h_fig,...
			'style','pushbutton',...
			'position',[.1 .05 .2 .15],...
			'units','normalized',...
			'string','Rotate',...
			'interruptible','on',...
			'callback','gui_wind(''Rotate'');');

	h_dir = uicontrol(h_fig,...
			'style','checkbox',...
			'position',[.32 .07 .25 .11],...
			'units','normalized',...
			'string','Clockwise',...
			'value',1,...
			'callback','gui_wind(''Change Rotation'');');
			
	h_xrot = uicontrol(h_fig,...
			'style','checkbox',...
			'position',[.6 .02 .35 .11],...
			'units','normalized',...
			'string','X-Rotation Axis',...
			'callback','gui_wind(''Change Rotation'');');
	h_yrot = uicontrol(h_fig,...
			'style','checkbox',...
			'position',[.6 .13 .35 .11],...
			'units','normalized',...
			'string','Y-Rotation Axis',...
			'callback','gui_wind(''Change Rotation'');');
						
	h_ax = axes('position',[.1 .25 .8 .65],...
				'userdata',0);

	x = [0 1 1 0 0 0 1 1 0 0 NaN 1 1 NaN 1 1 NaN 0 0];
	y = [0 0 1 1 0 0 0 1 1 0 NaN 0 0 NaN 1 1 NaN 1 1];
	z = [0 0 0 0 0 1 1 1 1 1 NaN 1 0 NaN 0 1 NaN 1 0];
	h_cube = line(x-0.5,y-0.5,z-0.5,'erasemode','background');
	axis('square');
	axis([-1 1 -1 1 -1 1]*1.5);
	axis('off')
	view(-37.5,15);
%	set(h_cube,);

	handles = [h_cube h_dir h_xrot h_yrot];
	set(gcf,'userdata',handles);
	
elseif strcmp(command_str,'Change Rotation')
	direction = sign(get(h_dir,'val')-.5);
	rotation_axis = [get(h_xrot,'value') ...
					 get(h_yrot,'value') ...
					 1];
	set(gca,'userdata',[1 direction rotation_axis]);

elseif strcmp(command_str,'Rotate')
	rotation_increment = 5*sign(get(h_dir,'value')-.5); % degrees
	rotation_axis = [get(h_xrot,'value') ...
					 get(h_yrot,'value') ...
					 1];
	rotation_origin = [0 0 0];
	num_of_incr = 720;
	angle_swept = 0;
	rotate_counter = 0;
	while abs(angle_swept) < 720
	   rotate(h_cube,rotation_axis,...
                  rotation_increment,rotation_origin);
	   rotate_counter = rotate_counter + 1;
	   angle_swept = angle_swept + rotation_increment;
	   if rotate_counter > 5
	      command_issued = get(gca,'userdata');
	      if command_issued(1) > 0
		     rot_dir = command_issued(2);
			 rotation_increment = abs(rotation_increment)*rot_dir;
			 rotation_axis = command_issued(3:5);
		     set(gca,'userdata',0);
		  end
		  rotate_counter = 0;
	   end
	   drawnow;
	end
end
