function mvrs_obj(command_str,Argument);
% MVRS_OBJ
% chap10/mvrs_obj.m
%
% Used to move and resize axes objects
% and move text objects.
% Start capability by issuing
%	mvrs_obj
% Then click and hold and drag to
% move an object (axes objects will be
% moved from lower-left corner).
% To resize an axes object hold the control
% or alt key before click hold and dragging
% near desired corner of axes object.

global CUR_OBJ CUR_OBJ_TYPE FIX_PT

if nargin == 0
	command_str = 'initialize';
end
if strcmp(command_str,'initialize')
	set(gcf,'windowbuttondownfcn','mvrs_obj(''Set Up'')');
elseif strcmp(command_str,'Set Up')
	CUR_OBJ = get(gcf,'currentobj');
	if CUR_OBJ ~= gcf
	  CUR_OBJ_TYPE = get(CUR_OBJ,'type');
	  
	  if strcmp(get(gcf,'selectiontype'),'normal')
	  % SET UP MOVING OBJECT ROUTINE
	  	set(gcf,'pointer','fleur');
		if strcmp(CUR_OBJ_TYPE,'text')
			set(CUR_OBJ,'erasemode','xor');
		elseif strcmp(CUR_OBJ_TYPE,'axes')
			set(gcf,'units','pixels');
			set(0,'units','pixels');
			set(CUR_OBJ,'units','pixels');
			cur_obj_loc = get(CUR_OBJ,'position');
			fig_pos = get(gcf,'position');
			set(0,'pointerlocation',fig_pos(1:2)+...
					cur_obj_loc(1:2));
		end
		set(gcf,'windowbuttonupfcn','mvrs_obj(''Done'')');
		set(gcf,'windowbuttonmotionfcn',...
            'mvrs_obj(''Move Object'')');
		set(CUR_OBJ,'selected','on');
	  elseif strcmp(get(1,'selectiontype'),'alt')
		% SET UP RESIZE OBJECT
		if strcmp(CUR_OBJ_TYPE,'axes')
			set(gcf,'units','pixels');
			set(0,'units','pixels');
			set(CUR_OBJ,'units','pixels');
			cur_obj_loc = get(CUR_OBJ,'position');
			fig_pos = get(gcf,'position');
			corner_loc = [cur_obj_loc(1:2); ...
				cur_obj_loc(1:2)+...
                [0 cur_obj_loc(4)];...
				cur_obj_loc(1:2)+...
                [cur_obj_loc(3) 0];...
				cur_obj_loc(1:2)+...
                cur_obj_loc(3:4)   ];
			corner_loc_scrn =...
                [corner_loc(:,1)+fig_pos(1) ...
				corner_loc(:,2)+fig_pos(2)];
			scrn_pnt_loc = get(0,'pointerlocation');
			[dumval,min_ind] = ...
                min(sum((([corner_loc_scrn-ones(4,1)*...
                    scrn_pnt_loc]).^2)'));
			if min_ind == 1; 
                FIX_PT = corner_loc(4,:);
			elseif min_ind ==2; 
                FIX_PT = corner_loc(3,:);
			elseif min_ind ==3; 
                FIX_PT = corner_loc(2,:);
			elseif min_ind ==4; 
                FIX_PT = corner_loc(1,:);end
			set(0,'pointerlocation',...
                corner_loc_scrn(min_ind,:));
					set(gcf,'windowbuttonupfcn',...
                        'mvrs_obj(''Done'')');
		    set(gcf,'windowbuttonmotionfcn',...
                'mvrs_obj(''Resize Object'')');
		   set(CUR_OBJ,'selected','on');

		end
	  end
	end
elseif strcmp(command_str,'Move Object')
% CALLBACK FOR WHEN THE POINTER IS MOVED AND THE
% OPERATION GOAL IS TO MOVE AN OBJECT 
	if strcmp(CUR_OBJ_TYPE,'text')
		cur_pnt_loc = get(get(CUR_OBJ,'parent'),...
            'currentpoint');
		set(CUR_OBJ,'position',cur_pnt_loc(1,:));
	elseif strcmp(CUR_OBJ_TYPE,'axes')
		cur_obj_loc = get(CUR_OBJ,'position');
		cur_pnt_loc = get(gcf,'currentpoint');
		new_obj_loc = [cur_pnt_loc cur_obj_loc(3:4)];
		set(CUR_OBJ,'position',new_obj_loc);
	end
	
elseif strcmp(command_str,'Resize Object')
% CALLBACK FOR WHEN THE POINTER IS MOVED AND THE
% OPERATION GOAL IS TO RESIZE AN OBJECT 
	if strcmp(CUR_OBJ_TYPE,'axes')
		curr_pnt = get(gcf,'currentpoint');
		relloc = curr_pnt > FIX_PT;
		if all(relloc == [0 0]),set(gcf,'pointer','botl');
		elseif all(relloc == [0 1]),set(gcf,'pointer','topl');
		elseif all(relloc == [1 0]),set(gcf,'pointer','botr');
		elseif all(relloc == [1 1]),set(gcf,'pointer','topr');
		end
		new_pos = [min([curr_pnt ;FIX_PT]),...
                max([abs(curr_pnt-FIX_PT);[1 1]])];
		%keyboard
		set(CUR_OBJ,'position',new_pos);
	end
	
elseif strcmp(command_str,'Done')
% OPERATION GOAL HAS BEEN COMPLETED SINCE
% USER RELEASED THE MOUSE
	if strcmp(CUR_OBJ_TYPE,'text')
		set(CUR_OBJ,'erasemode','normal');
	elseif strcmp(CUR_OBJ_TYPE,'axes')
		set(CUR_OBJ,'units','normalized');
	end
	set(CUR_OBJ,'selected','off');
	set(gcf,'pointer','arrow');
	set(gcf,'windowbuttonupfcn','');
	set(gcf,'windowbuttonmotionfcn','')
end
