function [out1] = scrllwin(command,p1,p2,p3,p4,p5,p6,p7) 
%  SCRLLWIN - Creates a scrollable non enabled edit window. 
%   handle_list,get_str
%  usage:  scrllwin(command,param1,param2,...);
%   
%    where both inputs are string types
%   
%       'command' can be 
%          1) 'initialize' - creates new scroll window.
%          2) 'set'        - changes contents to new string given
%		             by new_string.
%          3) 'add'        - adds new_string to the string in the 
%			     scroll window.
%          4) 'get'        - gets the string in the scroll window.
%
%
%    e.g. h1 = scrllwin('new','string',new_string);
%
%             Creates a scroll window using entire figure window.
%
%
%    e.g. h1 = scrllwin('new','string',new_string,'position',position_vector);
%
%             Creates a scroll window over the portion of the figure
%			defined by position_vector.
%
%    e.g. h1 = scrllwin('new','string',new_string,'position',position_vector...
%			 'tag',tag_string);
%
%             Creates a scroll window over the portion of the figure
%			defined by position_vector with a specific tag.
%
%    e.g. scrllwin('set',h1,'string',new_string,...)
%
%    e.g. scrllwin('add',h1,'string',Added_string) % adds the new string
%						      to the bottom of the
%						      window stack.
%    e.g. [h1,string_returned] = scrllwin('get',h1,'string'); 
%    e.g. [h1,position_returned] = scrllwin('get',h1,'position'); 
%    e.g. [h1,tag_returned] = scrllwin('get',h1,'tag'); 
%
%       new_string  can be a string in either str2mat format 
%                    where each row corresponds to a line of text or
%                    it can be one entire long string where the lines
%                    are separated by the character '|'. 
%
%	position_vector is the same as the position vector for other uicontrol
% 			objects with a 5th element being the proportion of the
%			width that the slider will take up.
%
%			= [left bottom width height slider_proportion]
%			  The units of the position are normalized to the figure
%			  window.
%
%	tag_string  is a string which uniquely identifies the scroll window.
%		    If it is not unique or not given, a unique tag will will
%		    be created by adding a numeric to the one provided or to
%		    the default (default = 'scrllwinobj')
%   
%  If no arguements are used the GUI is initialized. 
%
%  See also STR2MAT, NUM2STR, and UICONTROL 
%
 
%  Created: 27-Jan-95 
%  Using  : GUI Maker Ver 2.0 by Patrick Marchand 
%                         (pmarchan@motown.ge.com) 
%  Author :  Patrick Marchand
%  Mods.  :  
%   

%  Copyright (c) 1995  PATRICK MARCHAND
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

get_str = [];
if nargin == 0 
	command = 'new'; p1 = 'demo';
end 

if isstr(command) 
	if strcmp(lower(command),'initialize') | ...
	   strcmp(lower(command),'new') | ...
	   strcmp(lower(command),'create')
		command_num = 0;

	   sw_str = '';
	   sw_pos = [0 0 1 1];
	   sw_tag = 'scrllwinobj';

	   if rem(nargin,2) == 1
	      for loop_input = 1:2:(nargin-1)
	        attr = eval([sprintf('p%g',loop_input)]);
		attr_val = eval([sprintf('p%g',loop_input+1)]);
		if strcmp(lower(attr(1:3)),'tag')
	   	   sw_tag = attr_val;
		elseif strcmp(lower(attr(1:3)),'pos')
	   	   sw_pos = attr_val;
		elseif strcmp(lower(attr(1:3)),'str')
	   	   sw_str = attr_val;
		end
	      end
	   else
		if strcmp(p1,'demo')
		   sw_str = ['To stick text into a this scrolling window,'...
		   '|create a string catenated together by the' ...
		   '|pipe character (vertical line character).',...
		   '|You can also pass it a string matrix,',...
		   '|where each row in the string matrix,'...
		   '|corresponds to a new line in the scroll',...
		   '|box.',...
		   '|            - Patrick Marchand'];
		   sw_pos = [0 0 1 1];
		   sw_tag = 'scrllwinobj';
		else
		   error('Wrong number of inputs to scrllwin.m')
		end
	   end
	else
	   if strcmp(lower(command),lower('set')) 
	    if rem(nargin,2) == 0
	      attr_types_ind = zeros(1,3);
	      for loop_input = 2:2:(nargin-1)
	        attr = eval([sprintf('p%g',loop_input)]);
		attr_val = eval([sprintf('p%g',loop_input+1)]);
		if strcmp(lower(attr(1:3)),'tag')
	   	   sw_tag = attr_val;attr_types_ind(1) = 1;
		elseif strcmp(lower(attr(1:3)),'pos')
	   	   sw_pos = attr_val;attr_types_ind(2) = 1;
		elseif strcmp(lower(attr(1:3)),'str')
	   	   sw_str = attr_val;attr_types_ind(3) = 1;
		end
	      end
	    else
	     error('Wrong number of inputs to scrllwin.m')
	    end
		command_num = 1; command3_type = 1;
	   elseif strcmp(lower(command),lower('add')) 
	    if rem(nargin,2) == 0
	      attr_types_ind = zeros(1,3);
	      for loop_input = 2:2:(nargin-1)
	        attr = eval([sprintf('p%g',loop_input)]);
		attr_val = eval([sprintf('p%g',loop_input+1)]);
		if strcmp(lower(attr(1:3)),'tag')
	   	   sw_tag = attr_val;attr_types_ind(1) = 1;
		elseif strcmp(lower(attr(1:3)),'pos')
	   	   sw_pos = attr_val;attr_types_ind(2) = 1;
		elseif strcmp(lower(attr(1:3)),'str')
	   	   sw_str = attr_val;attr_types_ind(3) = 1;
		end
	      end
	    else
	     error('Wrong number of inputs to scrllwin.m')
	    end
		command_num = 2; command3_type = 2; 
	   elseif strcmp(lower(command),lower('get')) 
	    if rem(nargin,2) == 1
	      attr_types_ind = zeros(1,3);
	      for loop_input = 2:2:(nargin-1)
	        attr = eval([sprintf('p%g',loop_input)]);
		if strcmp(lower(attr(1:3)),'tag')
	   	   sw_tag = attr_val;attr_types_ind(1) = 1;
		elseif strcmp(lower(attr(1:3)),'pos')
	   	   sw_pos = attr_val;attr_types_ind(2) = 1;
		elseif strcmp(lower(attr(1:3)),'str')
	   	   sw_str = attr_val;attr_types_ind(3) = 1;
		end
	      end
	    else
	     error('Wrong number of inputs to scrllwin.m')
	    end
		command_num = 3; command3_type = 3;
	   end
	end 
end 

if length(sw_pos) == 4
 	sw_pos = [sw_pos .05];
end

if command_num ~= 0 
	handle_list = p1;
	sw_obj_s = findobj(handle_list,'flat','style','slider'); 
	sw_obj_e = findobj(handle_list,'flat','style','edit'); 
	handle_list = [sw_obj_s sw_obj_e];
end 


if command_num == 0 

	gcf; % get current figure to put objects into

	%  Uicontrol Object Creation 

	   for loop = 1:size(sw_str,1)
	     if loop == 1
	      strval = [deblank(fliplr(deblank(fliplr(sw_str(loop,:))))) ];
	     else
	      strval = [strval '|' ...
			deblank(fliplr(deblank(fliplr(sw_str(loop,:))))) ];
	     end
	   end

	numlines = length(findstr(strval,'|')) + 1;
	line_start_ind = [1 findstr(strval,'|')+1];
	startline = 1;

	if length(line_start_ind) > 1
	  str_ind_start = line_start_ind(startline);
	  str_ind_end = length(strval);
	  strshown = strval(str_ind_start:str_ind_end);
	elseif length(line_start_ind) == 1
	  str_ind_start = 1;
	  str_ind_end = length(strval);
	  strshown = strval(str_ind_start:str_ind_end);
	else
	  strshown = '';
	end

	cnt = 1;
	if length(findobj(gcf,'tag',[sw_tag])) > 0
	   while length(findobj(gcf,'tag',[sw_tag num2str(cnt)])) > 0
	    cnt = cnt+1;
	   end
	   sw_tag_s = [sw_tag num2str(cnt)];
	   sw_tag_e = [sw_tag num2str(cnt)];
	else
	   sw_tag_s = [sw_tag  ];
	   sw_tag_e = [sw_tag  ];
	end

	sw_pos_e = [sw_pos(1:2) (sw_pos(3)-sw_pos(5)) sw_pos(4)];
	sw_pos_s = [sw_pos_e(1)+sw_pos_e(3) sw_pos_e(2) sw_pos(5) sw_pos_e(4)];

	sw_cbk_s = [    'h_uic_1 = findobj(gcf,''tag'',''' sw_tag_s ''',''style'',''slider'');'...
			'h_uic_2 = findobj(gcf,''tag'',''' sw_tag_e ''',''style'',''edit'');'...
			'h_uic_1 = h_uic_1(1);h_uic_2 = h_uic_2(1);'...
			'ud = get(h_uic_1,''userdata'');'...
			'val = abs(get(h_uic_1,''val''));'...
			'if val > ud(1);val = ceil(val);'...
			'else;val = floor(val);end;' ...
			'set(h_uic_1,''val'',-val);' ...
			'strval = get(h_uic_2,''userdata'');'...
			'numlines = length(findstr(strval,''|'')) + 1;'...
			'line_start_ind = [1 findstr(strval,''|'')+1];'...
			'startline = val;'...
			'set(h_uic_1,''userdata'',[startline]);'...
			'if length(line_start_ind) > 1;'...
			  'str_ind_start = line_start_ind(startline);'...
			  'str_ind_end = length(strval);'...
			  'strshown = strval(str_ind_start:str_ind_end);'...
			'elseif length(line_start_ind) == 1;'...
			  'str_ind_start = 1;'...
			  'str_ind_end = length(strval);'...
			  'strshown = strval(str_ind_start:str_ind_end);'...
			'else;'...
			  'strshown = '''';'...
			'end;'...
			'set(h_uic_2,''string'',strshown);'...
		    ];
	sw_cbk_e = [''];

	sw_obj_e = uicontrol(... 
		'CallBack',sw_cbk_e,... 
		'Backgroundcolor',[.6 .6 .6],...
		'Max',[ 2 ],... 
		'Position',sw_pos_e,... 
		'Enable','on',... 
		'String',strshown,... 
		'Style','edit',... 
		'Units','normalized',... 
		'Tag',sw_tag_e,... 
		'UserData',strval);

	sw_obj_s = uicontrol(... 
		'CallBack',sw_cbk_s,... 
		'Position',sw_pos_s,... 
		'Style','slider',... 
		'Units','normalized',... 
		'Value',[ 0.02 ],... 
		'Min',-numlines,'Max',-1,'Val',-1,...
		'Tag',sw_tag_s,... 
		'UserData',[startline]); 

	handle_list = [sw_obj_e sw_obj_s];

elseif command_num == 1 
	if attr_types_ind(3) == 1
		h_uic_1 = sw_obj_s;
		h_uic_2 = sw_obj_e;

		val = 1;
		set(h_uic_1,'val',-val);
	
		strval = get(h_uic_2,'userdata');
		strval2 = '';
		for loop = 1:size(sw_str,1)
		  if loop == 1
		  strval2 = [deblank(fliplr(deblank(fliplr(sw_str(loop,:))))) ];
		  else
		   strval2 = [strval2 '|' ...
			deblank(fliplr(deblank(fliplr(sw_str(loop,:))))) ];
		  end
		end
		strval = [strval2];
		set(h_uic_2,'userdata',strval);
	   
		numlines = length(findstr(strval,'|')) + 1;
		line_start_ind = [1 findstr(strval,'|')+1];
		startline = val;
		set(h_uic_1,'userdata',[startline],'min',min([-1,-numlines]));

		if length(line_start_ind) > 1
		  str_ind_start = line_start_ind(startline);
		  str_ind_end = length(strval);
		  strshown = strval(str_ind_start:str_ind_end);
		elseif length(line_start_ind) == 1
		  str_ind_start = 1;
		  str_ind_end = length(strval);
		  strshown = strval(str_ind_start:str_ind_end);
		else
		  strshown = '';
		end
		set(h_uic_2,'string',strshown);

	elseif attr_types_ind(2) == 1
	 sw_pos_e = [sw_pos(1:2) (sw_pos(3)-sw_pos(5)) sw_pos(4)];
	 sw_pos_s = [sw_pos_e(1)+sw_pos_e(3) sw_pos_e(2) sw_pos(5) sw_pos_e(4)];
	   set(sw_obj_e,'position',sw_pos_e);
	   set(sw_obj_s,'position',sw_pos_s);

	elseif attr_types_ind(1) == 1
	  cnt = 1;
	  if length(findobj(gcf,'tag',[sw_tag])) > 0
	   while length(findobj(gcf,'tag',[sw_tag num2str(cnt)])) > 0
	    cnt = cnt+1;
	   end
	   sw_tag_s = [sw_tag num2str(cnt)];
	   sw_tag_e = [sw_tag num2str(cnt)];
	  else
	   sw_tag_s = [sw_tag  ];
	   sw_tag_e = [sw_tag  ];
	  end

	sw_cbk_s = [    'h_uic_1 = findobj(gcf,''tag'',''' sw_tag_s ''',''style'',''slider'');'...
			'h_uic_2 = findobj(gcf,''tag'',''' sw_tag_e ''',''style'',''edit'');'...
			'h_uic_1 = h_uic_1(1);h_uic_2 = h_uic_2(1);'...
			'ud = get(h_uic_1,''userdata'');'...
			'val = abs(get(h_uic_1,''val''));'...
			'if val > ud(1);val = ceil(val);'...
			'else;val = floor(val);end;' ...
			'set(h_uic_1,''val'',-val);' ...
			'strval = get(h_uic_2,''userdata'');'...
			'numlines = length(findstr(strval,''|'')) + 1;'...
			'line_start_ind = [1 findstr(strval,''|'')+1];'...
			'startline = val;'...
			'set(h_uic_1,''userdata'',[startline]);'...
			'if length(line_start_ind) > 1;'...
			  'str_ind_start = line_start_ind(startline);'...
			  'str_ind_end = length(strval);'...
			  'strshown = strval(str_ind_start:str_ind_end);'...
			'elseif length(line_start_ind) == 1;'...
			  'str_ind_start = 1;'...
			  'str_ind_end = length(strval);'...
			  'strshown = strval(str_ind_start:str_ind_end);'...
			'else;'...
			  'strshown = '''';'...
			'end;'...
			'set(h_uic_2,''string'',strshown);'...
		    ];
	sw_cbk_e = [''];

	   set(sw_obj_e,'tag',sw_tag_e,'callback',sw_cbk_e);
	   set(sw_obj_s,'tag',sw_tag_s,'callback',sw_cbk_s);
	else
 	end
elseif command_num == 2 
	if attr_types_ind(3) == 1
		h_uic_1 = sw_obj_s;
		h_uic_2 = sw_obj_e;

		ud = get(h_uic_1,'userdata');
		val = abs(get(h_uic_1,'val'));
		if val > ud(1)
		   val = ceil(val);
		else
		   val = floor(val);
		end
		set(h_uic_1,'val',-val);
	
		strval = get(h_uic_2,'userdata');
		strval2 = '';
		for loop = 1:size(sw_str,1)
		  if loop == 1
		  strval2 = [deblank(fliplr(deblank(fliplr(sw_str(loop,:))))) ];
		  else
		   strval2 = [strval2 '|' ...
			deblank(fliplr(deblank(fliplr(sw_str(loop,:))))) ];
		  end
		end
		strval = [strval '|' strval2];
		set(h_uic_2,'userdata',strval);
	   
		numlines = length(findstr(strval,'|')) + 1;
		line_start_ind = [1 findstr(strval,'|')+1];
		startline = val;
		set(h_uic_1,'userdata',[startline],'min',min([-1,-numlines]));

		if length(line_start_ind) > 1
		  str_ind_start = line_start_ind(startline);
		  str_ind_end = length(strval);
		  strshown = strval(str_ind_start:str_ind_end);
		elseif length(line_start_ind) == 1
		  str_ind_start = 1;
		  str_ind_end = length(strval);
		  strshown = strval(str_ind_start:str_ind_end);
		else
		  strshown = '';
		end
		set(h_uic_2,'string',strshown);

	end
elseif command_num == 3 
	if attr_types_ind(3) == 1
	   h_uic_1 = sw_obj_s;
	   h_uic_2 = sw_obj_e;

	   ud = get(h_uic_1,'userdata');
	   val = abs(get(h_uic_1,'val'));
	   if val > ud(1)
	      val = ceil(val);
	   else
	      val = floor(val);
	   end
	   set(h_uic_1,'val',-val);

	   strval = get(h_uic_2,'userdata');
	   if command3_type == 3
	      get_str = strval;
	   end
	elseif attr_types_ind(2) == 1
	   pos_e = get(sw_obj_e,'position');
	   pos_s = get(sw_obj_s,'position');
	   pos = [pos_e(1:2) (pos_e(3)+pos_s(3)) pos_e(4) pos_s(3)];
	   get_str = pos;

	elseif attr_types_ind(1) == 1
	   get_str = get(sw_obj_e,'tag');
	else
	   get_str = [];
	end

else 
	error('Error: scrllwin.m called with incorrect command.') 
end 

if command_num == 0
  out1 = handle_list;
elseif command_num == 3
  out1 = get_str;
end
