function uidial(command_str,Argument1,Argument2)
% UIDIAL
% examples/chap10/uidial.m
% Creates a dial user interface to learn how to
% make a custom GUI object.
% Usage:
%          uidial('initialize',min,max);
%
%  The value of the dial is stored and can be 
%  gotten from the current axes UserData property.

if nargin == 0 
	command_str = 'initialize';
end

if ~strcmp(command_str,'initialize')
	handles = get(gcf,'userdata');
	h_arrow = handles(1);
	h_stextval = handles(2);
end

if strcmp(command_str,'initialize')
	% Define default min and max values of dial.
	if nargin == 3
		minval = Argument1;
		maxval = Argument2;
	else
		minval = 0;
		maxval = 100;
	end

	h_fig=figure('Position',[200 200 200 200],...
		'color',[.7 .7 .7],...
		'menubar','none',...
        'resize','off',...
        'Units','normalized');
	h_ax=axes('color',[.7 .7 .7],...
		'xcolor',[.7 .7 .7],...
		'ycolor',[.7 .7 .7],...
		'xtick',[],'ytick',[],...
		'xlim',[-1 1],'ylim',[0 1],...
		'DataAspectRatio',[1 1 1],...
		'position',[.2 .1 .6 .8]);

	% Draw arrow in its minimum setting.
	arrowx = [0 -1 -.85 NaN -1 -.85];
	arrowy = [0 0 -.05 NaN 0 .05];
	arrowz = [0 0  0  0   0  0];
	% Store a matrix that can be manipulated
	% and used to draw the arrow after a rotation
	% angle has been determined.
	arrowud = [arrowx(:),arrowy(:),...
		arrowz(:),ones(prod(size(arrowx)),1)]';
	h_arrow = line(arrowx,arrowy,...
		'linewidth',2,...
		'clipping','off',...
		'erasemode','background',...
		'userdata',arrowud);

	% Create labels and the radial lines.
	h_stext = uicontrol(h_fig,...
		'style','text',...
		'string','Value:',...
		'units','norm',...
		'position',[.2 .2 .3 .13]);
	h_stextval = uicontrol(h_fig,...
		'style','text',...
		'string',sprintf('%2.1f',minval),...
		'units','norm',...
		'position',[.5 .2 .3 .13],...
		'min',minval,'max',maxval);
	h_dialborder = line(1.1*cos(0:.1:pi),...
		1.1*sin(0:.1:pi),...
		'color',[0 0 0],...
        'linewidth',2,...
		'clipping','off');
	h_t(1)=text(-1.15,0,sprintf('%2.1f',minval),...
		'horizontalalignment','right');
	h_t(2)=text(1.1,0,sprintf('%2.1f',maxval),...
		'horizontalalignment','left');
	h_t(3)=text(0,1.15,sprintf('%2.1f',...
		(maxval-minval)/2+minval),...
		'horizontalalignment','center',...
		'verticalalignment','bottom');

	% Make sure all the objects that the user might click on
	% to rotate the arrow with will recognize the initial
	% click.
	set([h_ax;h_t(:);h_dialborder;h_arrow],...
	  'buttondownfcn',...
	            'uidial(''Set Calls'');uidial(''Rotate'')');
	set(gcf,'userdata',[h_arrow h_stextval])
	
elseif strcmp(command_str,'Set Calls')
	% Define when the user clicks on the dial.  Set up
	% the callbacks that should occur when the user moves or 
	% releases the mouse button.
	set(gcf,'windowbuttonupfcn',...
	        'set(gcf,''windowbuttonmotion'','''')');
	set(gcf,'windowbuttonmotionfcn','uidial(''Rotate'')');

elseif strcmp(command_str,'Rotate')
	% Define the callback that should occur when the user
	% moves the mouse button.

	% Find out where the mouse pointer is located.
	pt = get(gca,'currentpoint');
	pt = pt(1,1:2);
	% Determine the angle that the pointer is at with
	% respect to the arrow's hinge.
	deg = atan2(pt(2),-pt(1))*180/pi;
	% Make sure the arrow does not swing past limits.
	if deg < 0 & abs(deg) < 90 
		deg = 0;
	elseif deg>180 | (deg<0 & abs(deg) > 90)
		deg = 180;
	end

	% Scale angle linearly between dial's minimum
	% and maximum values.
	minval = get(h_stextval,'min');
	maxval = get(h_stextval,'max');
	val = (deg/(180-0)*((maxval-minval)))+minval;

	% Store the value in the current axes UserData
	% where it can be retrieved by an application.
	set(gca,'userdata',val);

	% Create transformed coordinate points for the
	% arrow.
	arrowud = get(h_arrow,'userdata');
	A = viewmtx(deg,90);
	newarrow = A*arrowud;
	set(h_arrow,'xdata',newarrow(1,:),'ydata',newarrow(2,:));

	% Update the value indicator.
	set(h_stextval,'string',sprintf('%2.1f',val));

end
