%Displaying Images of MRI Data
%To display one of the MRI images, use the image command, indexing into the data array to obtain the eighth image. Then adjust
%axis scaling, and install the MRI colormap, which was loaded along with the data.
subplot(2,2,1);
load mri
D = squeeze(D);
image_num = 4;
image(D(:,:,image_num))
axis image
colormap(map)

%Save the x and y axis limits for use in the next part of the example.

x = xlim;
y = ylim;
%Displaying a 2-D Contour Slice
%You can treat this MRI data as a volume because it is a collection of slices taken progressively through the 3-D object. Use
%contourslice to display a contour plot of a slice of the volume. To create a contour plot with the same orientation and size as the
%image created in the first part of this example, adjust the y-axis direction (axis), set the limits (xlim, ylim), and set the data aspect
%ratio (daspect).
subplot(2,2,2);
contourslice(D,[],[],image_num)
axis ij;
xlim(x);
ylim(y);
daspect([1,1,1]);
colormap('default');

%Displaying 3-D Contour Slices
%Unlike images, which are 2-D objects, contour slices are 3-D objects that you can display in any orientation. For example, you can
%display four contour slices in a 3-D view. To improve the visibility of the contour line, increase the LineWidth to 2 points (one point
%equals 1/72 of an inch).
subplot(2,2,3);
phandles = contourslice(D,[],[],[1,12,19,27],8);
view(3); axis tight
set(phandles,'LineWidth',2)



%You can use isosurfaces to display the overall structure of a volume. When combined with isocaps, this technique can reveal
%information about data on the interior of the isosurface.

%First, smooth the data with smooth3; then use isosurface to calculate the isodata. Use patch to display this data as a graphics
%object.

subplot(2,2,4);
Ds = smooth3(D);
hiso = patch(isosurface(Ds,5),...
    'FaceColor',[1,.75,.65],...
    'EdgeColor','none');

%Adding an Isocap to Show a Cutaway Surface
%Use isocaps to calculate the data for another patch that is displayed at the same isovalue (5) as the surface. Use the unsmoothed
%data (D) to show details of the interior. You can see this as the sliced-away top of the head.

hcap = patch(isocaps(D,5),...
    'FaceColor','interp',...
    'EdgeColor','none');
colormap(map)

%Defining the View
%Define the view and set the aspect ratio (view, axis, daspect).

view(45,30) 
axis tight 
daspect([1,1,.4])

%Add lighting and recalculate the surface normals based on the gradient of the volume data, which produces smoother lighting
%(camlight, lighting, isonormals). Increase the AmbientStrength property of the isocap to brighten the coloring without
%affecting the isosurface. Set the SpecularColorReflectance of the isosurface to make the color of the specular reflected light
%closer to the color of the isosurface; then set the SpecularExponent to reduce the size of the specular spot.

lightangle(45,30); 
set(gcf,'Renderer','zbuffer'); lighting phong
isonormals(Ds,hiso)
set(hcap,'AmbientStrength',.6)
set(hiso,'SpecularColorReflectance',0,'SpecularExponent',50)

colormap('default');