%Section 4.3.1.1
%This will create Figure 4.38
figure(1)%the simplest slice, perpendicular to axis
[x,y,z] = meshgrid(-2:.2:2, -2:.2:2, -2:.2:2);
v = x .* exp(-x.^2 - y.^2 - z.^2);

slice(x, y, z, v,1,0,0)
axis tight
%This will create Figure 4.39
figure(2)%slicing at an angle
%first define a surface and rotate it.
%get the handle to the surface
Hslice = surf(-2:.2:2, -2:.2:2, zeros(length(z)));
%now rotate -45 degrees about the x axis
rotate(Hslice,[-1 0 0],-45);
%now use a little handle graphics to get the data that 
%defines the slice plane
xs = get(Hslice,'XData');
ys = get(Hslice,'Ydata');
zs = get(Hslice,'Zdata');
delete(Hslice); %since it is not needed

%to slice with the new plane simply...
slice(x,y,z,v,1,0,Inf)
hold on
slice(x,y,z,v,xs,ys,zs)


hold off

%20 contour lines on the x=1 plane
Hcs=contourslice(x,y,z,v,1,0,Inf,20);
set(Hcs,'EdgeColor','white', 'LineWidth', 1.0);

%20 contour lines on the 45 degree plane
Hcs=contourslice(x, y, z, v,xs,ys,zs,20);
set(Hcs,'EdgeColor','white','LineWidth', 1.0);
axis tight

%for Figure 4-41, slicing with a surface
figure(3)
slice(x, y, z, v,1,0,0)
hold on

[xss,yss,zss]=sphere;
slice(x,y,z,v,xss,yss,zss);
view([-29,12]);
axis tight
    

   