%Section 8.3.4
%Figures 8.32 and 8.33
% Define the coordinates of the virtual line
x = 0:.02:5*pi;
y = sin(x);
z = 0*x;
% Define the color values of each coordinate of the line
c = y;
% Generate the plot.
figure;
surface([x;x],[y;y],[z;z],[c;c],...
	'facecolor','none',...
	'edgecolor','flat',...
	'linewidth',3);
set(gca,'box','on','xtick',[0:pi:5*pi],...
	    'xticklabels','0|pi|2pi|3pi|4pi|5pi');
axis([0 5*pi -1.1 1.1])
grid on

%This is for the multi-colored spiral plot
u = 0:.2:4*pi;
x = cos(u);
y = sin(u);
z = u;
figure('colormap',cool(64));
h_surface = surface([0*x;x],[0*y;y],[z;z],...
	'facecolor','none',...
	'edgecolor','flat',...
	'meshstyle','row',...
	'linewidth',3);
view([-40 40]);
grid on
%grid on;
