%Section 9.1
%Frame-by-frame capture and playback
%mov9d1
% Create a figure that is a little smaller than 
% standard to save
% memory since we will be storing 20 frames.  
%If your machine has a lot of memory you do
% not have to define the position property of the %figure.
movie_figure = figure('position',[100 250 300 200]);
M = moviein(15);
[x,y] = meshgrid([-10:0.5:10]);
for frame_number = 1:15
   z = bessel(0,( frame_number-1)*.2 + sqrt(x.^2 + y.^2));
   surf(x,y,z);
   axis([-10 10 -10 10 -.5 1]);
   % Bring the figure to the front before taking a snapshot.
   figure(movie_figure);
   M(:,frame_number) = getframe;
end

frame_order = [1:15 14:-1:1];
number_repeats = 5;
movie(M,[number_repeats frame_order]);
