
function pielabel(h,string_cell)
%PIELABEL(H,STRING_CELL) will add the labels in STRING_CELL to the pie chart with handle H.
%Example:
%gov_rev_percentages = [31 36 18 8 7];
%h = pie(gov_rev_percentages);
%pielabel(h,{'Soc. Sec. Tax: ';'Personal Income Tax: ';...
%       'Borrowing: ';'Corporate Taxes: ';'Misc: '});

%The pie chart's labels are text graphics objects. To modify the text strings and their positions, first get the objects' strings
%and extents. Braces around a property name ensure that get outputs a cell array, which is important when working with
%multiple objects.

textObjs = findobj(h,'Type','text');    %get the current text objects
oldStr = get(textObjs,{'String'});      %get all the current strings
val = get(textObjs,{'Extent'});         %get the extents of the text
oldExt = cat(1,val{:});

%Create the new strings, then set the text objects' String properties to the new strings.
New_Labels = string_cell
newStr = strcat(New_Labels,oldStr);
set(textObjs,{'String'},newStr)

%Find the difference between the widths of the new and old text strings and change 
%the values of the Position properties.

val1 = get(textObjs, {'Extent'});
newExt = cat(1, val1{:});
offset = sign(oldExt(:,1)).*(newExt(:,3)-oldExt(:,3))/2;
pos = get(textObjs, {'Position'});
textPos =  cat(1, pos{:});
textPos(:,1) = textPos(:,1)+offset;
set(textObjs,{'Position'},num2cell(textPos,[3,2]))