%slow animation
t = 0:0.1:10*pi;
x = t.*sin(t);
y=t.*cos(t);
axislimits = [min(x) max(x) min(y) max(y) min(t) max(t)];
figure
tic
for indexnumber = 1:length(x)
   plot3(x(indexnumber ),y(indexnumber ),...
         t(indexnumber ),'bo');
   axis(axislimits);
   drawnow;
end
toc

%a little faster
figure
axis(axislimits);

line_handle = line(x(1 ),y(1 ),t(1 ),...
         'color','c',...
         'linestyle','o');
tic     
for indexnumber = 2:length(x)
   delete(line_handle );
   line_handle = line(x(indexnumber ),...
                      y(indexnumber ),...
                      t(indexnumber ),...
                      'color','b',...
                      'linestyle','o');
   drawnow;
end
toc

%faster yet
figure
line_handle = plot3(x(1 ),y(1 ),t(1 ),'bo');
set(line_handle,'erasemode','xor');
axis(axislimits);
tic
for indexnumber = 2:length(x)
   set(line_handle ,'xdata',x(indexnumber ),...
                     'ydata',y(indexnumber ),...
                     'zdata',t(indexnumber ));
   drawnow;
end
toc

