function [out,maxmxinputs,maxmxinputs0,needed_interfaces,libraries,suborfun]=matlab2fmex(filename_al,tempflagin_al,varargin)
% matlab2fmex(filename,tempflag,varargin)
%    There are 2 steps required to convert a Matlab m-file to a mex-able 
%Fortran90 file using matlab2fmex.
%
%    1) matlab2fmex needs to find a *.mat data file which contains a 
%typical workspace generated by the function which is being converted. 
%This is easily constructed by inserting a keyboard command at the end 
%of the *.m file, then, at the k>> promt simply type "save *" where * 
%is the name of the *.m file without the .m extension. 
%    matlab2fmex uses this workspace to make decisions which depend on 
%the variables in the *.m file, such as real or complex. Accordingly, if 
%an input variable may be complex, it is best to submit a complex input 
%when the workspace is saved so that the *.f90 file will be as robust as 
%possible.
%    When converting multiple *.m files (a main function and helper
%functions), a separate *.mat file must exist for each function.
%    2) The second step is to call matlab2fmex. The format is the following:
%matlab2fmex(filename,[options],{'first' 0or1},{'second' 0or1},...,
%                      ['local',{'first_l' 'input_l'},...]);
%
%After the filename to be converted (with no .m extension), there must 
%be a cell such as {'first' 0or1} for _each_ output variable. Each output 
%variable (in order) is the same size as as the input variable 'first' 
%(input as a string). This tells the converter what size to make the output 
%as a function of the input. If your function does not have an input 
%function which is the same size as a given output, use a dummy input
%variable specified with zeros(m,n). 
%    The second part of each cell specifies whether that output should
%be declared complex (1) or not (0). If there is a chance it may become
%complex, it is best to specify it as a 1. For multiple function conversion,
%input a cell array for each output variable in order: e.g. 
%{{'first_of_fun1' 0or1} {'first_of_fun2' 0or1}}
%then a comma and the next output variable (if any). For an complete example,
%see below.
%
%    Optionally, the user may specify the size of the local variables to
%be the same size as any of the input variables. After the cell
%specifications for the output variables are given, the string 'local'
%is followed by a cell array specifying first which local variable you
%want to assign, in this case 'first_l', and then by the input variable
%name this local variable should be the same size as; in this case
%'input_l'. See the EXAMPLES section for more information. If the size
%of the local variables is not specified in this way, the converter
%looks for input variables which happen to be the same size as each
%local variables. That local variable is then assigned the size of that
%input variable. Upon failing to find an input variable wiht the same
%size, the converted declares that local variable to be the _static_
%size it is is the saved workspace.
%
%    Some example calls are:
%matlab2fmex('myfunc');
%matlab2fmex('fibocon');
%matlab2fmex('gasket');
%etc.

declare_globals
filename_all=filename_al;
if nargin>1,tempflagin_all=tempflagin_al;else tempflagin_al=[]; tempflagin_all=[];end
%There are a few parameters which the user can adjust as well:
%These can be input as flags in the function call. 
%    The default behavior is below:
%Converter Parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
want_kb=0;%want_kb --> 0 Do not stop after each step, compile file. (default)
                  %--> 1 Enter Matlab keyboard after each step.(for debugging)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
want_ss=0;%want_ss%-->-1 No subscript vectorization. (for mostly scalar operations)
                  %--> 0 Relaxed subscript interpreting. (default)
                  %--> 1 Stricter subscripting (slower, for variable subscripts) obsolete -- not used
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
want_op=0;%want_op%-->-1 No operator replacement (use when want_ss=-1)
                  %--> 0 Don't replace +, -, or scalar * and / operators. (default)
                  %--> 1 Replace all math operators with interface calls. (slower)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
want_fb=0;%want_fb --> 0 Don't display progress throughout compilation. (default)
                  %--> 1 Display feedback information. (potentially annoying)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
want_ct=1;%want_ct --> 0 Don't mex *.f90 upon completion.
                  %--> 1 mex the resulting *.f90 file. (default)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
want_0=0;%want_0   --> 0 Don't zero all vars (default
                  %--> 1 Set all vars = 0 before computational routine
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
want_br=0;%want_br --> 0 Use (/ and /) instead of [ and ] (all Fortran 90's)
                  %--> 1 Use [ and ] (Some Fortran 90's)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
want_sb=0;%want_sb --> 0 Convert as a full mex-file
                  %--> 1 Convert as a subroutine (sets want_ct to 0).
		  %--> 2 Convert as a function (one output, sets want_ct to 0).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
want_in=1;%want_in --> 0 Don't allow local vars to be integers
                  %--> 1 Allow local vars to be integers (default)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
want_cs=0;%want_cs --> 0 Assume all sqrt's are of real, positive numbers
                  %--> 1 Assume all sqrt's are complex
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%See README file for further documentation

%%%try
% We need to parse varargin for output specs, possible local and input specs
if nargin<2, tempflagin_all=[];end
[vararginout,vararginin,vararginlocal]=parsevarargin(varargin);
if iscell(filename_al), filename=filename_al{1}; else filename=filename_al; end
if iscell(tempflagin_all), tempflagin=tempflagin_all{1}; else tempflagin=tempflagin_all; end
vararginout_all=vararginout;
if length(vararginout)>0
 if iscell(vararginout{1}{1})
  for i=1:size(vararginout_all,2)
   if iscell(vararginout{i}{1})
    vararginout{i}=vararginout_all{i}{1};
   else
    vararginout{i}=vararginout_all{i};
   end
  end
 end
end
if iscell(filename_al)
 suborfun=ones(max(size(filename_al)),1);
 suborfun(1)=0;
else
 if want_sb~=0
  suborfun=want_sb-1;
 else
  suborfun=0;
 end
end
if exist([filename,'.mat'],'file')
 cw=load(filename);
else
 error(['Couldn''t find ',filename,'.mat workspace file!']);
end
if ~isempty(tempflagin)
 for i=1:length(tempflagin)
  switch i
   case 1
    want_kb=tempflagin(1);
   case 2
    want_ss=tempflagin(2);
   case 3
    want_op=tempflagin(3);
   case 4
    want_fb=tempflagin(4);
   case 5
    want_ct=tempflagin(5);
   case 6
    want_0=tempflagin(6);
   case 7
    want_br=tempflagin(7);
   case 8
    want_sb=tempflagin(8);
    if want_sb~=0
     disp('Making subroutine');
     want_ct=0;
    end
   case 9
    want_in=tempflagin(9);
   case 10
    want_cs=tempflagin(10);
  end
 end
end
for i=length(tempflagin)+1:11
 switch i
  case 1
   tempflagin(1)=want_kb;
  case 2
   tempflagin(2)=want_ss;
  case 3
   tempflagin(3)=want_op;
  case 4
   tempflagin(4)=want_fb;
  case 5
   tempflagin(5)=want_ct;
  case 6
   tempflagin(6)=want_0;
  case 7
   tempflagin(7)=want_br;
  case 8
   tempflagin(8)=want_sb;
  case 9
   tempflagin(9)=want_in;
  case 10
   tempflagin(10)=want_cs;
 end
end
if want_sb==0
 disp(['Converting --- ',filename,'.m  ==>  ',filename,'.f90  ==>  ',filename,'.mex']);
else
 disp(['Converting --- ',filename,'.m  ==(added to)==>  mexfunctions.f90']);
end
%%%catch
%%% error(['Couldn''t load the workspace file for ',filename,'.m. Exiting...'])
%%%end

% Load keywords and function words.
keywords={'case';'select';'else';'elseif';'for';'function';'if';'otherwise';'profile';'switch';'while';'call';'then';'and';'or';'not';'inf';'endif';'do';'enddo';'exit'};
keywordsbegin={'for';'while';'switch';'if';'do';'elseif';'case'};
operators={'.''' 'mxtr';'''' 'mxctr';'.^' 'mxdpow';'^' 'mxpow';'*' 'matmul';'/' 'mxdiv';'.*' 'mxdmult';'./' 'mxddiv';'+' 'mxplus';'-' 'mxsub'};
logicalops={'~' '.not.';'&' '.and.';'|' '.or.'};
loglist={'~';'==',;'&';'|';'>';'<';'xor';'any';'all';'isnan';'isinf';'isfinite'};
mxwords={'mxGetM';'mxGetN';'mxCreateFull';'mxGetPr';'mxGetPi';'mxSetM';'mxSetN';'mexCallMATLAB';'mxs';'mxi';'mlcall';'mlcall0';'%val';'real';'aimag';'cmplx';'rhs';'lhs';'allocate';'deallocate';'num2str';'mxTR1';'mxTR2';'mxTR3';'mxTR4';'mxTR5';'mxTR6';'mxTR7';'mxTR8';'mxTR9';'mxTC1';'mxTC2';'mxTC3';'mxTC4';'mxTC5';'mxTC6';'mxTC7';'mxTC8';'mxTC9';'mxTI1';'mxTI2';'mxTI3';'mxTI4';'mxTI5';'mxTI6';'mxTI7';'mxTI8';'mxTI9'};
for i=1:size(operators,1), mxwords{size(mxwords,1)+1}=operators{i,2}; end
if ~want_sb,needed_interfaces=cell(1,2);libraries=' ';end
%if you do put libraries in, make sure -lslatec is before -llapack
funwords=getfunwordsmlonly;
mexoperatorinterfaces=getmexoperators;mexfunctions='';
r=char(10);b=char(8);needpi=0;needeps=0;maxTRC=[0 0 0];
typs{1}={'r';'c';'i';'l'};                     %General 2-D arrays
typs{3}={'c';'t';'x';'d';'m'};                 %Complex
typs{4}={'w';'x';'y';'z'};                     %1-D arrays in fortran
typs{5}={'s';'t';'u';'v'};                     %scalar
typs{6}={'r';'s';'w';'e';'n'};                 %real
typs{7}={'i';'u';'y';'f';'o'};                 %integer
typs{8}={'l';'v';'z';'g';'p'};                 %logical
typs{9}={'d';'e';'f';'g'};                     %2-D row vectors
typs{10}={'m';'n';'o';'p'};                    %2-D column vectors
typs{11}={typs{1}{:},typs{9}{:},typs{10}{:}};  %Any 2-D array
typs{12}={typs{11}{:},typs{4}{:}};             %non scalar
typs{2}={typs{6}{:},typs{3}{:}};               %All but integers and logicals
typs{13}={'c';'d';'m'};                        %2-D complex
typs{14}={'r';'e';'n'};                        %2-D real
typs{15}={'i';'f';'o'};                        %2-D integer
typs{16}={'l';'g';'p'};                        %2-D logical
typs{17}={'.';'e';'E';'d';'D'};                        %2-D logical
fortranfunwords={'dble';'aimag';'do';'enddo';'endif';'int';'nint';'iji';'conjg';'minval';'minloc';'maxval';'maxloc';'spread';'shape';'ubound';'product'};
make_words={'dot1f','dot2f','sizef','lengthf','sumf','zerosf','onesf','minf','maxf','prodf','reshapef','repmatf','linspacef','diagf','normf','eigf','svdf','besseljf','besselyf','besselif','besselkf','besselhf','airyf','gammaf','gammalnf','gammaincf','medianf','meanf','acosf','acoshf','acotf','acothf','acscf','acschf','asecf','asechf','asinf','asinhf','atanf','atanhf','cothf','cschf','sechf','findf','fliplrf','flipudf','isnanf','ss2inf','isinff'};
make_words2={'dot1','dot2','length','zeros','ones','prod','repmat','linspace','diag','norm','eig','svd','besselj','bessely','besseli','besselk','besselh','airy','gamma','gammaln','gammainc','median','mean','acosh','acot','acoth','acsc','acsch','asec','asech','asinh','atanh','coth','csch','sech','find','fliplr','flipud','ss2in','isinf'};
intrinsics={'abs','acos','aimag','aint','all','anint','any','asin','atan','atan2','ceiling','cmplx','conjg','cos','cosh','cotan','count','dble','dot_product','exit','exp','floor','huge','int','isnan','log','log10','logical','matmul','max','maxloc','maxval','min','minloc','minval','mod','modulo','nint','not','pack','product','real','reshape','shape','sign','sin','sinh','size','spread','sqrt','sum','tan','tanh','tiny','transpose','ubound','unpack','mxs','mxi','dot_product'};
barr={'c','r','i','l';'x','w','y','z';'t','s','u','v'}';
barr2={'d','e','f','g';'m','n','o','p'}';
alpha=isalpha; zzz=0;
ticker={'m','a','t','l','a','b','2','f','m','e','x','.','m'};
explicitinterfaces={'acosh','acoth','acsch','asech','asinh','atanh','coth','csch','log2','rem','sech','find'};

% First read the function into funstr.
filenamem=[filename,'.m'];
funstr=cell(1,1);
if exist(filenamem)==2
 fid=fopen(filenamem); filestr=fscanf(fid,'%c'); fclose(fid);
 if ~strcmp(filestr(length(filestr)),r), filestr=[filestr,r]; end
 rets=findstr(r,filestr);
 rets=[0 rets];
 temp=findstr(';',filestr);
 for i=1:length(temp)
  temp3=rets(rets>temp(i));temp3=temp3(1);
  goonimag=rets(rets<temp(i));goonimag=goonimag(length(goonimag));
  if length(find(~isspace(filestr(temp(i)+1:temp3-1))))>0
   goon(1)=length(findstr('[',filestr(temp(i)+1:temp3-1)));
   goon(2)=length(findstr(']',filestr(temp(i)+1:temp3-1)));
   if ~(goon(1)<goon(2))
    if length(findstr('%',filestr(goonimag+1:temp(i)-1)))==0
     filestr(temp(i))=r;
    end
   end
  end
 end
 rets=findstr(r,filestr);
 rets=[0 rets];
 count=1;
 temp2='';
 for i=1:length(rets)-1
  tempstr=[temp2,filestr(1+rets(i):rets(i+1)-1)];
  if length(find(~isspace(tempstr)))>0
   temp3=find(~isspace(tempstr));
   if ((tempstr(1)~=r)&(tempstr(temp3(1))~='%'))
    goon=1;
    if length(findstr('...',tempstr))>0, goon=0; end
    temp3=tempstr(~isspace(tempstr));
    if ((strncmp(temp3,'disp',4))|(strncmp(temp3,'error',5))), goon=1; end
    if goon
     funstr{count}=tempstr;
     temp1=findstr('%',funstr{count});
     if ~isempty(temp1)
      funstr{count}=funstr{count}(1:temp1(1)-1);
     end
     temp2='';
     count=count+1;
    else
     temp=findstr('...',tempstr);temp=temp(1);
     temp2=[tempstr(1:(temp-1))];
    end
   end
  end
 end
else
 error(['I can''t find the file ',filenamem,'...']);
end
funstr=funstr';
s=size(funstr,1);
if want_kb|want_fb
 disp([r,'Original:']);
 if s<20
  showall(funstr)
 else
  showall(funstr(1:20),1);
  disp(['   . . .'])
 end
 disp(' ')
end
if want_kb,disp('Just read the function in'); showall(funstr), keyboard, end

% Deblank. Find the words and numbers with start and endpoints
for i=1:s
%Misc tasks
% ------------ Insert -- RJHP 27Nov01 -----------------
 funstr{i}(findstr(char(13),funstr{i}))=[]; %Remove CRs
% -----------------------------------------------------
%Deblank front and back
 funstr{i}=deblank(funstr{i});
 funstr{i}=fliplr(deblank(fliplr(funstr{i})));
%Ensure semilcolon at end
 if funstr{i}(end)~=';', funstr{i}=[funstr{i} ';']; end
end
updatefunstr;

% OK;now find the inputs, outputs, and other vars to the function
%Inputs first.
inoutother=cell(4,1);
temp=find(funstr{1}=='(');
if ~isempty(temp)
 dummy=find(funstrwords_b{1}>temp(1));
 for j=1:length(dummy), inoutother{1}(j)=funstrwords{1}(dummy(j)); end
else
 error('you have to have some inputs');
end
inoutother{1}=inoutother{1}';
%Outputs next
temp=find(funstr{1}=='=');
if ~isempty(temp)
 dummy=find(funstrwords_b{1}<temp(1));
 for j=2:length(dummy), inoutother{2}(j-1)=funstrwords{1}(dummy(j)); end
else
 error('you have to have some outputs');
end
inoutother{2}=inoutother{2}';
%Now other vars from cw
temp=fieldnames(cw);count=1;
for i=1:length(temp)
 if ((~isin(temp(i),inoutother{1}))&(~isin(temp(i),inoutother{2})))
  inoutother{3}(count)=temp(i);
  count=count+1;
 end
end
inoutother{3}=inoutother{3}';
%And other things I don't want to be counted as regular vars
inoutother{4}(1)={'lhs'};
inoutother{4}(2)={'rhs'};
inoutother{4}(3)={'nlhs'};
inoutother{4}(4)={'nrhs'};
count=5;
for i=1:length(inoutother{1})
 if ~isreal(getfield(cw,inoutother{1}{i}))
  inoutother{4}(count)={[inoutother{1}{i},'_r']};
  inoutother{4}(count+1)={[inoutother{1}{i},'_i']};
  count=count+2;
 end
end
for i=1:length(inoutother{2})
 if ~isreal(getfield(cw,inoutother{2}{i}))
  inoutother{4}(count)={[inoutother{2}{i},'_r']};
  inoutother{4}(count+1)={[inoutother{2}{i},'_i']};
  count=count+2;
 end
end
inoutother{4}=inoutother{4}';
if length(inoutother{3})>0
 inoutother3={inoutother{1}{:},inoutother{2}{:},inoutother{3}{:}};
else
 inoutother3={inoutother{1}{:},inoutother{2}{:}};
end

%we need to decide whether the local vars are complex, real, or integer.
localvartype=cell(length(inoutother{3}),1);
for i=1:length(inoutother{3})
 if ~isreal(getfield(cw,inoutother{3}{i}))
  localvartype{i}='complex';
 elseif islogical(getfield(cw,inoutother{3}{i}))
  localvartype{i}='logical';
 else
  if nnz(getfield(cw,inoutother{3}{i})~=round(getfield(cw,inoutother{3}{i})))>0
   localvartype{i}='real';
  else
   if want_in==1
    localvartype{i}='integer';
   else
    localvartype{i}='real';
   end
  end
 end
end

%Let's decide whether this routine is recursive or not.
recursive=0;
for i=1:s
 temp=strcmp(filename,funstrwords{i});
 if any(temp)&~strcmp(funstrwords{i}{1},'function')
  temp1=findstr('%',funstr{i});
  if isempty(temp1)
   recursive=1;
  else
   temp2=find(temp);
   if funstrwords_b{i}(temp2(1))<temp1(1)
    recursive=1;
   end
  end
 end
end

% So, now we start the macros to changeover.
tickercount=1;pticker=0;
%First, get rid of the first line of function definition.
for i=1:s-1
 funstr{i}=funstr{i+1};
end 
funstr={funstr{1:s-1}}';
updatefunstr;
%Save all the original stuff for shape determination later.
funstr1=funstr;
funstrnumbers1=funstrnumbers;
funstrnumbers_b1=funstrnumbers_b;funstrnumbers_e1=funstrnumbers_e;
funstrwords1=funstrwords;
funstrwords_b1=funstrwords_b;funstrwords_e1=funstrwords_e;

%Put a decimal point on many numbers which have none.
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' putting decimal points etc. ....................... 1');end
 count=1;gotto=1;gotto2=1;
 while count==1
  count=0;
  for i=gotto:s
   fprintf(1,b);fprintf(1,ticker{tickercount});
   tickercount=tickercount+1;if tickercount>11, tickercount=1; end
   if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
   fid=0;
   for j=gotto2:length(funstrnumbers{i})
    if count==0
     goon=1;
     temp1=inmlcall(i,funstrnumbers_b{i}(j),funstr,funstrwords,funstrwords_b);
     [temp2,howmany2,subscripts2,centercomma2,parens2]=inwhichlast(i,funstrnumbers_b{i}(j));
     temp3=0;
     if temp2==1 %In bracket last
      [temp3,howmany,subscripts,centercomma,parens,foo]=inwhichlast(i,parens2(1));
      if ~(parens(1)==fid)
       tempstr=makeMATLABcallstring(1,{funstr{i}(parens2(1):parens2(2))},[],parens2,i,j);
       fid=parens(1);
      end
      if temp3==2 %In subscript
       ;%don't add if is a bracket in a subscript
       goon=0;
      end
      if any(strcmp(tempstr(1),typs{7})) % We have a bracketed expression full of integers
       goon=0;
      end
     end
     if goon|temp1
      if temp2==5|temp2==6|temp3==5|temp3==6 %In intrinsics last
       temp5=find(funstrwords_b{i}<parens2(1));
       if ~isempty(temp5)
        temp5=temp5(end);
        if temp3==5
         temp5=foo;
        end
        if any(strcmp(funstrwords{i}{temp5},{'sum';'reshape';'min';'max';'size';'prod';'mean';'dot'})) %Don't need them on dimensions for some
         [howmany3,subscripts3,centercomma3,parens3]=hassubscript(i,temp5);
         if howmany3>1
          if funstrnumbers_b{i}(j)>centercomma3(1) & funstrnumbers_b{i}(j)<parens3(2)
           goon=0;
           if length(funstrnumbers{i}{j})>1
            if strcmp(funstrnumbers{i}{j}(end-1:end),'.0') %Remove .0 from these places
             funstr{i}=[funstr{i}(1:funstrnumbers_e{i}(j)-2),funstr{i}((funstrnumbers_e{i}(j)+1):(end))];
             updatefunstr(i);          count=1;gotto=i;gotto2=j+1;
            end
           end
          end
         end
        end
       end
      end
%%%      if any(strcmp(funstrnumbers{i},'1.0'))
%%%       funstr{i},goon,j,temp2,temp1,kb
%%%      end
      if goon
       if temp2==0|temp2==1|temp2==4|temp2==5|temp2==6|temp1
        if ~any(strcmp({'for';'while'},funstrwords{i}{1}))
%%%        if length(find(findstr(funstrnumbers{i}{j},'.')))==0
%funstr{i},funstrnumbers{i}{j},intersect([typs{17}{:}],funstrnumbers{i}{j})
if length(intersect([typs{17}{:}],funstrnumbers{i}{j}))==0
 funstr{i}=[funstr{i}(1:(funstrnumbers_e{i}(j))),'.0',funstr{i}((funstrnumbers_e{i}(j)+1):(end))];
 updatefunstr(i);          count=1;gotto=i;gotto2=j+1;
 %funstr{i},kb
end
%%%        end
        end
       end
      end
     end
%%%     if any(strcmp(funstrwords{i},'reshape'))
%%%      funstr{i},tempstr,'ddddddddddddddd4',kb
%%%     end
    end
    if count==1, break; end
   end
   if count==0, gotto2=1; end
   if count==1, break; end
  end
 end
 if want_kb,disp('finished with putting decimal points etc.'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((strcmp(tempans,'n'))|(strcmp(tempans,'k'))), keyboard, end, end
%%%end

%Changed bracketed expressions
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' fixing bracketed assignments ...................... 1');end
 count=1;gotto=1;
 while count==1
  count=0;
  for i=gotto:s
   fprintf(1,b);fprintf(1,ticker{tickercount});
   tickercount=tickercount+1;if tickercount>11, tickercount=1; end
   if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
   if count==0;
    temp=findstr('[',funstr{i});    fid=0;
    if ~isempty(temp)
     for k=1:length(temp)
      if count==0
       temp=findstr('[',funstr{i});       temp=temp(k);
       temp1=findrights(temp,funstr{i});
       goon=find(funstrwords_b{i}(funstrwords_b{i}<temp));
       goonimag=0; 
%       funstr{i},'stoppppppppp222222',kb
       if isempty(goon)
	goonimag=0;
%        funstr{i},'stoppppppppp',kb
       else
	if temp>4
	 goonimag=(~(strcmp('spread(',funstr{i}(temp-4:temp-1)))&(length(find(strcmpi('int',funstrwords{i}{goon(length(goon))})))==0)&(length(find(strcmp('reshape',funstrwords{i}{goon(length(goon))})))==0)&(length(find(strcmp('disp',funstrwords{i}{1})))==0));
	else
	 goonimag=((length(find(strcmpi('int',funstrwords{i}{goon(end)})))==0)&(length(find(strcmp('reshape',funstrwords{i}{goon(end)})))==0)&(length(find(strcmp('disp',funstrwords{i}{1})))==0));
        end
       end
       if (goonimag)
	temp2=1;%temp2=commas/spaces
	temp3=1;%temp3=m-size
	for j=(temp+1):(temp1-1)
	 if strcmp(funstr{i}(j),' ')
	  if ((~insubscript(i,temp))|(inwhichlast(i,j)==1))
	   if ((~isspace(funstr{i}(j-1)))&(~strcmp(funstr{i}(j-1),','))&(~strcmp(funstr{i}(j+1),','))&(~strcmp(funstr{i}(j-1),'['))&(~strcmp(funstr{i}(j+1),']')))
	    temp2=temp2+1;
	    funstr{i}(j)=',';
	   end
	  end
	 elseif strcmp(funstr{i}(j),',')
	  if ~insubscript(i,j,temp,temp1)
	   temp2=temp2+1;
	  end
	 end
	 if strcmp(funstr{i}(j),';')
	  fid=1;
	  temp2=1;
	  temp3=temp3+1;
	  funstr{i}(j)=',';
	 end
	end
	if fid
	 if ~insubscript(i,temp)
	  funstr{i}=[funstr{i}(1:(temp-1)),'reshape(',funstr{i}(temp:temp1),',[',num2str(temp2),',',num2str(temp3),']).''',funstr{i}((temp1+1):end)];count=1;gotto=i;
	 else
	  funstr{i}=[funstr{i}(1:(temp-1)),'[transpose(reshape(',funstr{i}(temp:temp1),',[',num2str(temp2),',',num2str(temp3),']))]',funstr{i}((temp1+1):end)];count=1;gotto=i;
	 end
	else
         [outflag,howmany,subscripts,centercomma,parens]=inwhichlast(i,temp);
         %funstr{i},kb
         tempstr=0;
         if outflag==5
          temp4=find(~isspace(funstr{i}));
          temp4=temp4(temp4<parens(1));     temp4=temp4(end);
          temp5=find(funstrwords_e{i}==temp4(end));
          if ~isempty(temp5)
           if any(strcmp(funstrwords{i}{temp5},{'logical'}))
            tempstr=1;
           end
          end
         end
         %if ((~insubscript(i,temp))&(~inbracket(i,temp,funstr))&~(strcmp('[',funstr{i}(1))))
         if outflag==0|tempstr
          if ((strcmp(funstrwords{i}{1},'disp'))|(strcmp(funstrwords{i}{1},'for'))|(strcmp(funstrwords{i}{1},'call')))
           funstr{i}=[funstr{i}(1:(temp-1)),funstr{i}(temp+1:temp1-1),funstr{i}((temp1+1):end)];count=1;gotto=i;
          else
           if ~any(':'==funstr{i}(temp:temp1))
            %funstr{i}
            funstr{i}=[funstr{i}(1:(temp-1)),'spread(',funstr{i}(temp:temp1),',1,1)',funstr{i}((temp1+1):end)];count=1;gotto=i;
            %'[[[[[[[[[[[[[[[',funstr{i},kb
           end
          end
	 else
	  %Do nothing
	 end
	end
	if count==1
	 updatefunstr(i);
	end
       end
      end
     end
    end
   end
  end
 end
 if want_kb,disp('finished fixing bracketed assignments'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((strcmp(tempans,'n'))|(strcmp(tempans,'k'))), keyboard, end, end
%%%end

%Changed non-integral expressions in subscripts
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' fixing bracketed assignments II ................... 1');end
 count=1;gotto=1;gotto2=1;
 while count==1
  count=0;
  for i=gotto:s
   fprintf(1,b);fprintf(1,ticker{tickercount});
   tickercount=tickercount+1;if tickercount>11, tickercount=1; end
   if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
   for j=gotto2:length(funstrwords{i})
    if count==0
     if (length(find(strcmp(funstrwords{i}(j),inoutother3)))>0)
      if insubscript(i,funstrwords_b{i}(j))
       [temp2,howmany2,subscripts2,centercomma2,parens2]=inwhichlast(i,funstrwords_b{i}(j));
       if ((temp2==1)|(temp2==2))
	goon=1;
	if temp2==1
	 [outflag,howmany,subscripts,centercomma,parens]=inbracket(i,funstrwords_b{i}(j),funstr);
	 if howmany>=3
	  goon=0;
	 end
	end
	if length(find(strcmp(funstrwords{i}{j},inoutother{3})))>0
	 temp1=find(strcmp(funstrwords{i}{j},inoutother{3}));
	 if strcmp(localvartype{temp1},'integer')
	  goon=0;
	 end
	end
	if funstrwords_b{i}(j)>4
	 if strcmp(funstr{i}(funstrwords_b{i}(j)-4:funstrwords_b{i}(j)-1),'int(')
	  goon=0;
	 end
	end
        %Which subscript are we in?
        if howmany2==1
         fid=1;
        elseif howmany2==2
         if ((funstrwords_b{i}(j)>parens2(1))&(funstrwords_b{i}(j)<centercomma2))
          fid=1;         else,          fid=2;
         end
        end
        for k=1:length(loglist)
         temp3=findstrexact(loglist{k},subscripts2{fid});
         if ~isempty(temp3)
          temp4=findstrexact(subscripts2{fid},funstr{i});
          for temp=1:length(temp3)
           [outflag,howmany,subscripts,centercomma,parens]=inwhichlast(i,temp4+temp3(temp)-1);
           if ~isempty(parens)
            if parens(1)==parens2(1) %parens we are in match parens that relop is in
             goon=0;
            end
           end
          end
         end
        end
	if goon==1
	 [howmany,subscripts,centercomma,parens]=hassubscript(i,j);
	 if howmany==0
	  funstr{i}=[funstr{i}(1:funstrwords_b{i}(j)-1),'int(',funstrwords{i}{j},')',funstr{i}(funstrwords_e{i}(j)+1:end)];
	 else
	  funstr{i}=[funstr{i}(1:funstrwords_b{i}(j)-1),'int(',funstr{i}(funstrwords_b{i}(j):parens(2)),')',funstr{i}(parens(2)+1:end)];
	 end
	 if length(find(strcmp('int',fortranfunwords)))==0
	  fortranfunwords{length(fortranfunwords)+1}='int';
	 end
	 updatefunstr(i);
	 count=1;gotto=i;gotto2=j+1;
	end
       end
      end
     end
    end
    if count==1, break; end
   end
   if count==0, gotto2=1; end
   if count==1, break; end
  end
 end
 if want_kb,disp('finished fixing bracketed assignments II'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((strcmp(tempans,'n'))|(strcmp(tempans,'k'))), keyboard, end, end
%%%end

%Change things about the math (matrix mult, /, .*, +, etc.), in cell 'operators'.
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' operator changeover ............................... 1');end
 for j=1:length(operators)
  gotto=1;count=1;
  while count==1
   count=0;
   for i=gotto:s
    fprintf(1,b);fprintf(1,ticker{tickercount});
    tickercount=tickercount+1;if tickercount>11, tickercount=1; end
    if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
    dummy=findstr(operators{j,1},funstr{i});
    if ~isempty(dummy)
     for k=1:length(dummy)
      temp=dummy(k);
      if ~strcmp(funstrwords{i}{1},'error')&~strcmp(funstrwords{i}{1},'print')
       goon=1;
       if strcmp(funstrwords{i}{1},'disp')
	temp1=find(''''==funstr{i});
	if ~isempty(temp1)
	 if ((temp==temp1(1))|(temp==temp1(end)))
	  goon=0;
	 end
	end
       end
       if strcmp(funstr{i}(temp-1),'.'), goon=0; end
       if strcmp(funstr{i}(temp-1),'*'), goon=0; end
       if strcmp(funstr{i}(temp+length(operators{j,1})),'*')&strcmp('*',operators{j,1})
        goon=0;
       end
       if goon
	goonimag=0;
	if ((want_op==1)|(~((strcmp(operators{j,1},'+'))|(strcmp(operators{j,1},'-')))))
         [temp1,temp2]=changeoperator(i,operators{j,1},temp);
	 if temp1
          updatefunstr(i);
	 end
	 if ((want_op==1)|(length(temp2{1}>0))|(temp1==1))
	  updatefunstr(i);
%	  if tempflag==0
	   if length(temp2{1}>0)
	    if length(findstr(temp2{1},mexoperatorinterfaces{1}))==0
	     mexoperatorinterfaces{1}=[mexoperatorinterfaces{1} temp2{1}];
	     mexoperatorinterfaces{2}=[mexoperatorinterfaces{2} temp2{2}];
	    end
	   end
%	  end
	  count=1;gotto=i;
	 end
	end
       end
      end
      if count~=0
       break
      end
     end
    end
    if count~=0
     break
    end
   end
  end
 end
 if want_kb,disp('finished with operator changeover'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((strcmp(tempans,'n'))|(strcmp(tempans,'k'))), keyboard, end, end
%%%end

%Fix subscripts for in/out vars because everything 2-dim now (except in brackets).
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' making 2 subscripts ............................... 1');end
 %First make sure everythings has 2 subscripts
 count=1;gotto=1;gotto2=0;
 while count==1
  count=0;
  for i=gotto:s
   fprintf(1,b);fprintf(1,ticker{tickercount});
   tickercount=tickercount+1;if tickercount>11, tickercount=1; end
   if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
   temp3=length(funstrwords{i});
   for j=(temp3-gotto2):-1:1
    if ~inastring(funstrwords_b{i}(j),funstr{i})
     if count==0
      if (length(find(strcmp(funstrwords{i}(j),inoutother3)))>0)
       [howmany,subscripts,centercomma,parens]=hassubscript(i,j);
       goonimag=0;%set to be just a pack unless goonimag=>1;
       temp1=findstr('=',funstr{i});
       if ~isempty(temp1) %only test if there is an = sign
        temp2=1;
        for k=1:length(temp1)
         if temp2==1
          if ~insubscript(i,temp1(k))
           temp2=temp1(k);break
          end
         end
        end
        if temp2==1 %No equals sign, goonimag already =0
        else %Here, we have a main equals sign, is our word before or after?
         if funstrwords_b{i}(j)<temp2 %Need a where statement
          goonimag=1;
         end
        end
       end
       switch howmany %Number of subscripts for this var
        case 0 %Do nothing
        case 1
         tempstr=makeMATLABcallstring(howmany,subscripts,centercomma,parens,i,j);
         fid=need_ss2in(howmany,subscripts,centercomma,parens,i,j,tempstr);
         temp=funstr{i}((parens(1)+1):(parens(2)-1));
         %Is it before or after the main = sign?
         if any(strcmp(tempstr,typs{8}))
          if goonimag==0 %Pack
           funstr{i}=[funstr{i}(1:(funstrwords_b{i}(j)-1)),'ss2in(',funstrwords{i}{j},',',subscripts{1},')',funstr{i}((parens(2)+1):end)];
          else %where
           fortranfunwords{length(fortranfunwords)+1}='where';
           funstr{i}=['where(',subscripts{1},') ',funstrwords{i}{j},funstr{i}((parens(2)+1):end)];
          end
          updatefunstr(i);
          count=1;gotto=i;gotto2=temp3-j;
         else
          if goonimag==0 %after main equals sign
           if size(getfield(cw,funstrwords{i}{j}),1)==1 %row vector var, test for ss2in
            if fid(1) %add a ss2in
             funstr{i}=[funstr{i}(1:(funstrwords_b{i}(j)-1)),'ss2in(',funstrwords{i}{j},',',subscripts{1},')',funstr{i}((parens(2)+1):end)];
            else %place a 1 there and index normally
             funstr{i}=[funstr{i}(1:parens(1)),'1,',funstr{i}((parens(1)+1):end)];
            end
           elseif size(getfield(cw,funstrwords{i}{j}),2)==1 %column vector var, test for ss2in
            if fid(1) %add a ss2in
             funstr{i}=[funstr{i}(1:(funstrwords_b{i}(j)-1)),'ss2in(',funstrwords{i}{j},',',subscripts{1},')',funstr{i}((parens(2)+1):end)];
            else %place a 1 there and index normally
             funstr{i}=[funstr{i}(1:(parens(2)-1)),',1',funstr{i}(parens(2):end)];
            end
           else
            if strcmp(temp(~isspace(temp)),':') %If a colon is the entire subscript, then columnize
             fortranfunwords{length(fortranfunwords)+1}='reshape';
             fortranfunwords{length(fortranfunwords)+1}='int';
             funstr{i}=[funstr{i}(1:(funstrwords_b{i}(j)-1)),'reshape(',funstrwords{i}{j},',[size(',funstrwords{i}{j},'),int(1)])',funstr{i}((parens(2)+1):end)];
            else %This should be a ss2in
             funstr{i}=[funstr{i}(1:(funstrwords_b{i}(j)-1)),'ss2in(',funstrwords{i}{j},',',subscripts{1},')',funstr{i}((parens(2)+1):end)];
            end
           end
           updatefunstr(i);
           count=1;gotto=i;gotto2=temp3-j;
          else %subscript on lhs, add 1 if needed           
           if size(getfield(cw,funstrwords{i}{j}),1)==1 %row vector var, test for ss2in
            funstr{i}=[funstr{i}(1:parens(1)),'1,',funstr{i}((parens(1)+1):end)];
           elseif size(getfield(cw,funstrwords{i}{j}),2)==1 %column vector var, test for ss2in
            funstr{i}=[funstr{i}(1:(parens(2)-1)),',1',funstr{i}(parens(2):end)];
           end
           updatefunstr(i);
           count=1;gotto=i;gotto2=temp3-j;
          end
         end
        case 2
         tempstr=makeMATLABcallstring(howmany,subscripts,centercomma,parens,i,j);
         fid=need_ss2in(howmany,subscripts,centercomma,parens,i,j,tempstr);
         if goonimag==0 %after main equals sign
          if all(fid) %This should not happen ... ?
          elseif fid(1) %ss2in only that dim
           funstr{i}=[funstr{i}(1:(funstrwords_b{i}(j)-1)),'ss2in(',funstrwords{i}{j},'(:,',subscripts{2},'),',subscripts{1},')',funstr{i}((parens(2)+1):end)];
          elseif fid(2)
           funstr{i}=[funstr{i}(1:(funstrwords_b{i}(j)-1)),'ss2in(',funstrwords{i}{j},'(',subscripts{1},',:),',subscripts{2},')',funstr{i}((parens(2)+1):end)];
          end
          if any(fid)&~all(fid)
           updatefunstr(i);
           count=1;gotto=i;gotto2=temp3-j;
          end
         end
       end %switch
      end
      %funstr{i},funstrwords{i}{j},kb
     end
    end
    if count==1, break; end
   end
   if count==0, gotto2=0; end
   if count==1, break; end
  end
 end
 if want_kb,disp('finished with making 2 subscripts'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((strcmp(tempans,'n'))|(strcmp(tempans,'k'))), keyboard, end, end
%%%end

%Fix logical operators such as &, |, and ~ (and ~= ==> /=)
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' fixing logical operators .......................... 1');end
 count=1;gotto=1;
 while count==1
  count=0;
  for i=gotto:s
   fprintf(1,b);fprintf(1,ticker{tickercount});
   tickercount=tickercount+1;if tickercount>11, tickercount=1; end
   if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
   for j=1:size(logicalops,1)
    if count==0
     temp=findstr(funstr{i},logicalops{j,1});
     if ~isempty(temp)
      for k=1:size(temp)
       if count==0
	if strcmp('~',logicalops{j,1})
	 temp1=find(~isspace(funstr{i}));
	 temp1=temp1(temp1>temp(k));temp1=temp1(1);
	 if ~strcmp('=',funstr{i}(temp1))
	  funstr{i}=[funstr{i}(1:(temp(k)-1)),logicalops{j,2},funstr{i}((temp(k)+length(logicalops{j,1})):end)];
	  updatefunstr(i);
	  count=1;gotto=i;
	 else
	  funstr{i}=[funstr{i}(1:(temp(k)-1)),'/',funstr{i}((temp(k)+length(logicalops{j,1})):end)];
	 end
	else
	 funstr{i}=[funstr{i}(1:(temp(k)-1)),logicalops{j,2},funstr{i}((temp(k)+length(logicalops{j,1})):end)];
	 updatefunstr(i);
	 count=1;gotto=i;
	end
       end
      end
     end
    end
   end
  end
 end
 if want_kb,disp('finished fixing logical operators'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((strcmp(tempans,'n'))|(strcmp(tempans,'k'))), keyboard, end, end
%%%end

%Fix all subscripts, possibly add mxi
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' subscript vectorizing ............................. 1');end
 count=1;gotto=1;gotto2=1;
 while count==1
  count=0;
  for i=gotto:s
   fprintf(1,b);fprintf(1,ticker{tickercount});
   tickercount=tickercount+1;if tickercount>11, tickercount=1; end
   if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
   for j=length(funstrwords{i}):-1:1
    if count==0
     if (length(find(strcmp(funstrwords{i}(j),inoutother3)))>0)
      [howmany,subscripts,centercomma,parens]=hassubscript(i,j);
      if howmany==2
       tempstr=makeMATLABcallstring(howmany,subscripts,centercomma,parens,i,j);
       if any(strcmp(tempstr(1),typs{12})),temp3(1)=0;else temp3(1)=1;end
       if any(strcmp(tempstr(2),typs{12})),temp3(2)=0;else temp3(2)=1;end
       if ((temp3(1)==1)&(temp3(2)==1))
	%Do nothing
       elseif ((temp3(1)==1)&(temp3(2)==0))
	%Vectorize then let 0,0 take care of mxi if needed
	temp1(1)=parens(1);temp1(2)=centercomma(1);
	funstr{i}=[funstr{i}(1:temp1(1)),'[',funstr{i}(temp1(1)+1:temp1(2)-1),']',funstr{i}(temp1(2):end)];
	count=1;gotto=i;
       elseif ((temp3(1)==0)&(temp3(2)==1))
	%Vectorize then let 0,0 take care of mxi if needed
	temp1(1)=centercomma(1);temp1(2)=parens(2);
	funstr{i}=[funstr{i}(1:temp1(1)),'[',funstr{i}(temp1(1)+1:temp1(2)-1),']',funstr{i}(temp1(2):end)];
	count=1;gotto=i;
       elseif ((temp3(1)==0)&(temp3(2)==0))
	%Add mxi if needed
	for k=1:howmany
	 if count==0
	  if strncmp(subscripts{k}(1),'[',1),goonimag=0;else;goonimag=1;end
	  if length(find(subscripts{k}==':'))>0,goonimag=0;end
%%%	  if length(subscripts{k})>3
%%%	   if strcmp(subscripts{k}(1:4),'mxv(')
%%%	    goonimag=0;
%%%	   end
%%%	  end
	  if goonimag
	   if k==1,temp1(1)=parens(1);temp1(2)=centercomma(1); end
	   if k==2,temp1(1)=centercomma(1);temp1(2)=parens(2); end
	   funstr{i}=[funstr{i}(1:temp1(1)),'[',funstr{i}(temp1(1)+1:temp1(2)-1),']',funstr{i}(temp1(2):end)];
	   count=1;gotto=i;
	  end
	 end
	end
       end
      end
      if count==1
       updatefunstr(i);
      end
     end
    end
    if count==1, break; end
   end
   if count==1, break; end
  end
 end
 if want_kb,disp('finished with subscript vectorizing'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((strcmp(tempans,'n'))|(strcmp(tempans,'k'))), keyboard, end, end
%%%end

%Fix for, while, if, keywords groups
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' fixing if, for, etc keywords ...................... 1');end
 for i=1:s
  fprintf(1,b);fprintf(1,ticker{tickercount});
  tickercount=tickercount+1;if tickercount>11, tickercount=1; end
  if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
  switch funstrwords{i}{1}
   case 'call'
   case 'case'
    funstr{i}=[funstr{i}(1:funstrwords_e{i}(1)+1),'(int(',convertconditional(funstr{i}(funstrwords_e{i}(1)+2:end-1)),'));'];
   case 'else'
   case 'elseif'
    funstr{i}=['elseif (',convertconditional(funstr{i}(funstrwords_e{i}(1)+2:end-1)),') then;'];
   case 'for'
    temp=findend(i,s,funstr,funstrwords,keywords,keywordsbegin);
    fid=find(funstr{i}=='=');fid=fid(fid>funstrwords_e{i}(1));fid=fid(1);
    temp2=find(funstr{i}==':');
    parens=[fid+1 length(funstr{i})-1];
    tempstr=makeMATLABcallstring(length(temp2)+1,cell(1,length(temp2)+1),temp2,parens,i,j);
%     for k=1:length(temp2)+1
%      if k==1
%       elseif
%     end
    temp3=cell(0);
    temp3{1,1}=''; temp3{1,2}=''; temp3{1,3}=''; temp3{1,4}=''; temp3{1,5}=''; temp3{1,6}='';
    temp3{2,1}=''; temp3{2,2}=''; temp3{2,3}=''; temp3{2,4}=''; temp3{2,5}=''; temp3{2,6}='';
    if any(strcmp(tempstr(1),typs{2})), temp3{1,1}='nint(';temp3{1,2}=')'; end
    if any(strcmp(tempstr(2),typs{2})), temp3{1,3}='nint(';temp3{1,4}=')'; end
    if any(strcmp(tempstr(1),typs{1})), temp3{2,1}='mxs('; temp3{2,2}=')'; end
    if any(strcmp(tempstr(2),typs{1})), temp3{2,3}='mxs('; temp3{2,4}=')'; end
    if length(temp2)==1
     funstr{i}=['do',funstr{i}(funstrwords_e{i}(1)+1:fid),temp3{1,1},temp3{2,1},funstr{i}(fid+1:temp2-1),temp3{1,2},temp3{2,2},',',temp3{1,3},temp3{2,3},funstr{i}(temp2+1:end-1),temp3{1,4},temp3{2,4},';'];
    elseif length(find(funstr{i}==':'))==2
    if any(strcmp(tempstr(3),typs{2})), temp3{1,5}='nint(';temp3{1,6}=')'; end
    if any(strcmp(tempstr(3),typs{1})), temp3{2,5}='mxs('; temp3{2,6}=')'; end
    funstr{i}=['do',funstr{i}(funstrwords_e{i}(1)+1:fid),temp3{1,1},temp3{2,1},funstr{i}(fid+1:temp2(1)-1),temp3{1,2},temp3{2,2},',',temp3{1,3},temp3{2,3},funstr{i}(temp2(2)+1:end-1),temp3{1,4},temp3{2,4},',',temp3{1,5},temp3{2,5},funstr{i}(temp2(1)+1:temp2(2)-1),temp3{1,6},temp3{2,6},';'];
    end
    funstr{temp}=['enddo',funstr{temp}(funstrwords_e{temp}(1)+1:length(funstr{temp}))];
    
   case 'if'
    funstr{i}=[funstr{i}(1:funstrwords_e{i}(1)+1),'(',convertconditional(funstr{i}(funstrwords_e{i}(1)+2:end-1)),') then;'];
    temp=findend(i,s,funstr,funstrwords,keywords,keywordsbegin);
    funstr{temp}=['endif',funstr{temp}(funstrwords_e{temp}(1)+1:length(funstr{temp}))];
   case 'otherwise'
    funstr{i}=['case default',funstr{i}(funstrwords_e{i}(1)+1:end)];
   case 'switch'
    funstr{i}=['select case (int(',convertconditional(funstr{i}(funstrwords_e{i}(1)+2:end-1)),'));'];
    temp=findend(i,s,funstr,funstrwords,keywords,keywordsbegin);
    funstr{temp}=['end select',funstr{temp}(funstrwords_e{temp}(1)+1:length(funstr{temp}))];    
   case 'while'
    funstr{i}=['do while ',convertconditional(funstr{i}(funstrwords_e{i}(1)+2:end-1)),';'];
    temp=findend(i,s,funstr,funstrwords,keywords);
    funstr{temp}=['enddo',funstr{temp}(funstrwords_e{temp}(1)+1:length(funstr{temp}))];
  end
 end
 updatefunstr;
 if want_kb,disp('finished fixing if, for, etc keywords.'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((tempans=='n')|(tempans=='k')), keyboard, end, end
%%%end

%Change colon expressions
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' fixing colon expressons ........................... 1');end
 for i=1:s
  fprintf(1,b);fprintf(1,ticker{tickercount});
  tickercount=tickercount+1;if tickercount>11, tickercount=1; end
  if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
  temp=findstr(':',funstr{i});
  if ~isempty(temp)
   j=1;
   while j<=length(temp)
    if ((strcmp(funstrwords{i}{1},'disp'))|(strcmp(funstrwords{i}{1},'for')))
     break
    else
%      if i>186
%       funstr{i},kb
%      end
     temp1=temp(j);
     [tempflag,howmany,subscripts,centercomma,parens]=inbracket(i,temp1,funstr);
     if tempflag  % In a bracket
      [temp2,howmany2,subscripts2,centercomma2,parens2]=inwhichlast(i,parens(1));
      tempstr=makeMATLABcallstring(howmany,subscripts,centercomma,parens,i,j);
      temp3={'','','';'','',''};
      for k=1:howmany
       if ~any(strcmp(tempstr(k),typs{7}))
 	if length(find(strncmp('int',subscripts{k},3)))==0
	 temp3{1,k}=[temp3{1,k},'int('];   temp3{2,k}=[temp3{2,k},')'];
	end
       end
       if any(strcmp(tempstr(k),typs{1}))
	if length(find(strncmp('mxs',subscripts{k},3)))==0
	 temp3{1,k}=[temp3{1,k},'mxs('];   temp3{2,k}=[temp3{2,k},')'];
        end
       end
      end
      if howmany==3
       if temp2==2 % bracketed expression is in subscript, 2 colons, switch order
	fid={};
	fid{1}=(~isspace(funstr{i}))&(find(funstr{i})>parens(2));
	fid{2}=(~isspace(funstr{i}))&(find(funstr{i})<parens(1));
	if (length(find(fid{1}(1)==[parens2 centercomma2]))>0) & (length(find(fid{2}(end)==[parens2 centercomma2]))>0) %Then we dont need (/ /) in fortran
	 funstr{i}=[funstr{i}(1:parens(1)-1),temp3{1,1},subscripts{1},temp3{2,1},':',temp3{1,3},subscripts{3},temp3{2,3},':',temp3{1,2},subscripts{2},temp3{2,2},funstr{i}(parens(2)+1:end)];
	else %we do
	 funstr{i}=[funstr{i}(1:parens(1)-1),'[(iji,iji=',temp3{1,1},subscripts{1},temp3{2,1},',',temp3{1,3},subscripts{3},temp3{2,3},',',temp3{1,2},subscripts{2},temp3{2,2},')]',funstr{i}(parens(2)+1:end)];
	end
	j=j+howmany-1;
       elseif temp2==1 % Bracketed expression nested in another bracket
	funstr{i}=[funstr{i}(1:parens(1)-1),'[linspace((',subscripts{1},'),fix(((',subscripts{3},')-(',subscripts{1},'))/(',subscripts{2},'))*(',subscripts{2},')+(',subscripts{1},'),fix(((',subscripts{3},')-(',subscripts{1},'))/(',subscripts{2},'))+1)]',funstr{i}(parens(2)+1:end)];
       else % Bracketed expression by itself or in another context, return array
	funstr{i}=[funstr{i}(1:parens(1)-1),'linspace((',subscripts{1},'),fix(((',subscripts{3},')-(',subscripts{1},'))/(',subscripts{2},'))*(',subscripts{2},')+(',subscripts{1},'),fix(((',subscripts{3},')-(',subscripts{1},'))/(',subscripts{2},'))+1)',funstr{i}(parens(2)+1:end)];
       end
      elseif howmany==2 % bracketed expression, 1 colon, not in subscript. Must return array
       if ~insubscript(i,temp(j))
        funstr{i}=[funstr{i}(1:parens(1)-1),'spread(',subscripts{1},'+[(iji,iji=int(0),int(mxs(floor(dble(',subscripts{2},'-(',subscripts{1},'))))))],1,1)',funstr{i}(parens(2)+1:end)];
       end
       if temp2==2 % bracketed expression, 1 colon, in subscript. add int() if needed
        fid={};
	fid{1}=find((~isspace(funstr{i}))&(find(funstr{i})>parens(2)));
	fid{2}=find((~isspace(funstr{i}))&(find(funstr{i})<parens(1)));
	if (length(find(fid{1}(1)==[parens2 centercomma2]))>0) & (length(find(fid{2}(end)==[parens2 centercomma2]))>0) %Then we dont need (/ /) in fortran
	 funstr{i}=[funstr{i}(1:parens(1)-1),temp3{1,1},subscripts{1},temp3{2,1},':',temp3{1,2},subscripts{2},temp3{2,2},funstr{i}(parens(2)+1:end)];
	else %we do
	 funstr{i}=[funstr{i}(1:parens(1)-1),'[(iji,iji=',temp3{1,1},subscripts{1},temp3{2,1},',',temp3{1,2},subscripts{2},temp3{2,2},')]',funstr{i}(parens(2)+1:end)];
	end
	j=j+howmany-1;
       end
      end
      updatefunstr(i);
     else % Not in a bracket
      [tempflag,howmany,subscripts,centercomma,parens]=inwhichlast(i,temp1);
      if tempflag==2 % But we are in a subscript last
       temp2=[];	 temp3=[];
       for k=1:howmany % Find which subscript (k) this colon expression is in, should be 2 subs
	if k==1
	 temp2(1)=parens(1); temp2(2)=centercomma(1);
	elseif k==howmany
	 temp2(1)=centercomma(end); temp2(2)=parens(2);
	else
	 temp2(1)=centercomma(k-1); temp2(2)=centercomma(k);
	end
	if ((temp1>temp2(1))&(temp1<temp2(2)))
	 temp3=k;
	 break
	end
       end
       fid=find(((temp>temp2(1))&(temp<temp2(2))));
       tempstr='';
       howmany=length(fid)+1;
       %here next, there has to be a better way
       for k=1:howmany
	if k==1
	 temp3(1)=temp2(1); temp3(2)=temp(fid(1));
	elseif k==length(fid)+1
	 temp3(1)=temp(fid(end)); temp3(2)=temp2(2);
	else
	 temp3(1)=temp(fid(k-1)); temp3(2)=temp(fid(k));
	end
	tempstr=[tempstr,makeMATLABcallstring(1,{funstr{i}(temp3(1)+1:temp3(2)-1)},[],[temp3(1)+1 temp3(2)-1],i,inf)];
	subscripts{k}=funstr{i}(temp3(1)+1:temp3(2)-1);
       end
       temp3={'','','';'','',''};
       for k=1:howmany
	if ~any(strcmp(tempstr(k),typs{7}))
	 if length(find(strncmp('int',subscripts{k},3)))==0
	  temp3{1,k}=[temp3{1,k},'int('];   temp3{2,k}=[temp3{2,k},')'];
	 end
	end
	if ~any(strcmp(tempstr(k),typs{5}))
	 if length(find(strncmp('mxs',subscripts{k},3)))==0
	  temp3{1,k}=[temp3{1,k},'mxs('];   temp3{2,k}=[temp3{2,k},')'];
         end
	end
       end
       if howmany==3 % colon expression is in subscript, 2 colons, switch order
	funstr{i}=[funstr{i}(1:temp2(1)),temp3{1,1},subscripts{1},temp3{2,1},':',temp3{1,3},subscripts{3},temp3{2,3},':',temp3{1,2},subscripts{2},temp3{2,2},funstr{i}(temp2(2):end)];
	j=j+howmany-1;
       elseif howmany==2 % colon expression is in subscript, 1 colon
	funstr{i}=[funstr{i}(1:temp2(1)),temp3{1,1},subscripts{1},temp3{2,1},':',temp3{1,2},subscripts{2},temp3{2,2},funstr{i}(temp2(2):end)];
	j=j+howmany-1;
       end
       updatefunstr(i);
      else
       if ~strcmp(funstrwords{i}{1},'for')
	disp(['Encountered a colon expression not enclosed in brackets outside ',r,'a subscript. Put brackets around this colon expression. *error*',r,'          ',funstr{i}]);keyboard
       else
	j=inf;
       end
      end
     end
    end
    temp=findstr(':',funstr{i});
   end
  end
 end
 if want_kb,disp('finished fixing colon expressions'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((strcmp(tempans,'n'))|(strcmp(tempans,'k'))), keyboard, end, end
%%%end

%Change calls to matlab function with no fortran equivalent (user m-files).
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' performing word conversion ........................ 1');end
 count=1;gotto=1;maxmxinputs={'r'};maxmxinputs0={'r'};multinum=1;
 while count==1
  count=0;
  for i=gotto:s
   fprintf(1,b);fprintf(1,ticker{tickercount});
   tickercount=tickercount+1;if tickercount>11, tickercount=1; end
   if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
   if count==0
    goon='';goonimag='';fid='';
    for j=length(funstrwords{i}):-1:1
     if count==0
      dummy=[keywords' inoutother{1}' inoutother{2}' inoutother{3}' inoutother{4}' mxwords' fortranfunwords']';
%%%       if any(strcmp('i',funstrwords{i}))
%%%        'wqord',funstr{i},funstrwords{i}{j},kb
%%%       end
      if ((length(find(strcmpi(funstrwords{i}(j),dummy)))==0)&~(inastring(funstrwords_b{i}(j),funstr{i}))&(~strcmpi(funstrwords{i}(1),'call'))&(~strcmpi(funstrwords{i}(1),'rhs')))
%%%       if any(strcmp('prod',funstrwords{i}{j}))
%%%        'wqord',funstr{i},funstrwords{i}{j},kb
%%%       end
       foo=1;
       if strcmpi(funstrwords{i}(j),'j')
        if ~(length(find(strcmpi('j',inoutother3))))
         funstr{i}=[funstr{i}(1:funstrwords_b{i}(j)-1),'cmplx(0.0,1.0)',funstr{i}(funstrwords_e{i}(j)+1:end)];
         foo=0;         updatefunstr(i);         count=1;gotto=i;
        end
       end
       if strcmpi(funstrwords{i}(j),'i')
        if ~(length(find(strcmpi('i',inoutother3))))
         funstr{i}=[funstr{i}(1:funstrwords_b{i}(j)-1),'cmplx(0.0,1.0)',funstr{i}(funstrwords_e{i}(j)+1:end)];
         foo=0;         updatefunstr(i);         count=1;gotto=i;
        end
       end
       if strcmpi(funstrwords{i}(j),'pi')
        if ~(length(find(strcmpi('pi',inoutother3))))
         needpi=1;         foo=0;
        end
       end
       if strcmpi(funstrwords{i}(j),'eps')
        if ~(length(find(strcmpi('eps',inoutother3))))
         needeps=1;         foo=0;
        end
       end
       if foo
        foo3=0;
        if any(strcmp(funstrwords{i}{j},'dot1f'))
         foo3=1,funstr{i},kb
        end
        [tempflag,temp2,suborfun]=wordconverter(i,j,suborfun);
%%%        if foo3
%%%         zzz=1;
%%%         tempflag,funstr{i},funstrwords{i}{j},'converter',kb
%%%        end
        if tempflag(3)==1 %Newer interface by call if ==1
         updatefunstr(i);
         [howmany,subscripts,centercomma,parens]=hassubscript(i,j);
         %'before',funstr{i},funstrwords{i}{j},kb
         tempstr=makeMATLABcallstring(howmany,subscripts,centercomma,parens,i,j);
         temp3=cell(1,3);
%%%        if any(strcmp(funstrwords{i}{j},'diagf'))
%%%         funstr{i},howmany,subscripts,centercomma,parens,tempstr,kb
%%%        end

         try
         eval(['[temp3{1},temp3{2},temp3{3}]=',funstrwords{i}{j}(1:length(funstrwords{i}{j})-1),'_make(''',tempstr,''');']);
         catch
          'caught after wordconverter',funstr{i},kb
         end
         tempstr2=tempstr;
         for m=1:length(tempstr)
          temp=any(strcmp(tempstr2(m),{'d','m'})); if temp,tempstr2(m)='c';end
          temp=any(strcmp(tempstr2(m),{'e','n'})); if temp,tempstr2(m)='r';end
          temp=any(strcmp(tempstr2(m),{'f','o'})); if temp,tempstr2(m)='i';end
          temp=any(strcmp(tempstr2(m),{'g','p'})); if temp,tempstr2(m)='l';end
         end
         if length(find(strcmpi(funstrwords{i}(j),needed_interfaces{1,1})))==0
          temp5=length(needed_interfaces{1,1})+1;
          needed_interfaces{1,1}{temp5}=funstrwords{i}{j};
          needed_interfaces{1,2}{temp5}{1,1}=tempstr2;
          needed_interfaces{1,2}{temp5}{1,2}=temp3{3}{1};
          needed_interfaces{1,2}{temp5}{1,3}=temp3{3}{2};
         else
          temp2=find(strcmpi(funstrwords{i}(j),needed_interfaces{1,1}));
          if length(find(strcmpi(tempstr2,needed_interfaces{1,2}{temp2}(:,1))))==0
           temp5=size(needed_interfaces{1,2}{temp2},1)+1;
           needed_interfaces{1,2}{temp2}{temp5,1}=tempstr2;
           needed_interfaces{1,2}{temp2}{temp5,2}=temp3{3}{1};
           needed_interfaces{1,2}{temp2}{temp5,3}=temp3{3}{2};
          end
         end
         %needed_interfaces{1,1},kb
%%%         if strcmpi(funstrwords{i}(j),'findf')
%%%          funstr{i},needed_interfaces{1,1},needed_interfaces{1,2}{4},kb
%%%         end
         if temp3{3}{1}==1
          %Here we have to remake a few lines with the mxTR# and mxTC#
          %First, what is the highest count of mxTRC# on this line
          if strcmp(funstrwords{i-1}{1},'deallocate')
           temp1=gethighesttemp(funstr{i},temp3{3}{2});
          else
           temp1=gethighesttemp([funstr{i-1},funstr{i}],temp3{3}{2});
          end
          for k=size(funstr,1)+2:-1:i+2
           funstr{k}=funstr{k-2};
          end
          maxTRC=updatetemp(maxTRC,temp1+1,temp3{3}{2});
          funstr{i}=['call ',funstr{i+2}(funstrwords_b{i}(j):parens(1)),'mxT',upper(temp3{3}{2}),num2str(temp1+1),',',funstr{i+2}(parens(1)+1:parens(2)),';'];
          if length(find(strcmp(keywordsbegin,funstrwords{i}{j})))==0
           funstr{i+1}=[funstr{i+2}(1:funstrwords_b{i}(j)-1),'mxT',upper(temp3{3}{2}),num2str(temp1+1),funstr{i+2}(parens(2)+1:length(funstr{i+2}))];
          else
           funstr{i+1}=[funstr{i+2}(1:funstrwords_b{i}(j)-1),'mxs(mxT',upper(temp3{3}{2}),num2str(temp1+1),')',funstr{i+2}(parens(2)+1:length(funstr{i+2}))];
          end
          funstr{i+2}=['deallocate(mxT',upper(temp3{3}{2}),num2str(temp1+1),');'];
          updatefunstr;
         end
        else
         if length(temp2{1})>0
          if length(findstr(temp2{1},mexoperatorinterfaces{1}))==0
           mexoperatorinterfaces{1}=[mexoperatorinterfaces{1} temp2{1}];
           mexoperatorinterfaces{2}=[mexoperatorinterfaces{2} temp2{2}];
          end
         end
        end
        if ~tempflag(1)
         [howmany,subscripts,centercomma,parens]=hassubscript(i,j);
         [howmany2,subscripts2,centercomma2,parens2]=hasoutput(i,j);
         temp3=0;
%%%         funstr{i},howmany2,kb
         switch howmany2
          case 0
           temp='call mlcall0(';
           tempstr=makeMATLABcallstring(howmany,subscripts,centercomma,parens,i,j);
           if length(find(strcmp(maxmxinputs0,tempstr)))==0
            maxmxinputs0{length(maxmxinputs0)+1}=tempstr;
           end
           count=1;gotto=i;
          case 1
           tempstr=makeMATLABcallstring(howmany,subscripts,centercomma,parens,i,j);
           if length(find(strcmp(maxmxinputs,tempstr)))==0
            maxmxinputs{length(maxmxinputs)+1}=tempstr;
           end
           %Here we have to remake a few lines with the mxTR# and mxTC#
           %First, what is the highest count of mxTRC# on this line
           temp4='r';if sum(length(find(tempstr=='c'))+length(find(tempstr=='t')))>0, temp4='c'; end
           if i>1
            if strcmp(funstrwords{i-1}{1},'deallocate')
             temp1=gethighesttemp(funstr{i},temp4);
            else
             temp1=gethighesttemp([funstr{i-1},funstr{i}],temp4);
            end
           else
            temp1=0;
           end
           for k=size(funstr,1)+2:-1:i+2
            funstr{k}=funstr{k-2};
           end
           maxTRC=updatetemp(maxTRC,temp1+1,temp4);
           try
            funstr{i}=['call mlcall(mxT',upper(temp4),num2str(temp1+1),',',funstr{i+2}(parens(1)+1:parens(2)-1),',''',funstrwords{i}{j},''');'];
           catch %catch this
            disp([r,'Here are the contents of ',filename,'_save.m. Is ',funstrwords{i}{j},' here?'])
            cw
            disp(['You may have a variable in ',filename,'.m file which is not in ',filename,'_save.m file.']);
            funstr{i},keyboard
           end
           if length(find(strcmp(keywordsbegin,funstrwords{i}{j})))==0
            funstr{i+1}=[funstr{i+2}(1:funstrwords_b{i}(j)-1),'mxT',upper(temp4),num2str(temp1+1),funstr{i+2}(parens(2)+1:length(funstr{i+2}))];
           else
            funstr{i+1}=[funstr{i+2}(1:funstrwords_b{i}(j)-1),'mxs(mxT',upper(temp4),num2str(temp1+1),')',funstr{i+2}(parens(2)+1:length(funstr{i+2}))];
           end
           funstr{i+2}=['deallocate(mxT',upper(temp4),num2str(temp1+1),');'];
           updatefunstr;
           count=1;gotto=i;
           temp3=2;
          otherwise %multioutput
           temp=['call mlcallm',num2str(multinum),'('];
           temp2=makemultioutput(i,j,funstr,funstrnumbers,funstrnumbers_b,funstrnumbers_e,funstrwords,funstrwords_b,funstrwords_e,funwords,inoutother,keywords,localvartype,needed_interfaces,filename_al,make_words,cw,multinum,howmany,subscripts,centercomma,parens,howmany2,subscripts2,centercomma2,parens2);
           if length(temp2{1})>0
            if length(findstr(temp2{1},mexoperatorinterfaces{1}))==0
             mexoperatorinterfaces{1}=[mexoperatorinterfaces{1} temp2{1}];
             mexoperatorinterfaces{2}=[mexoperatorinterfaces{2} temp2{2}];
            end
           end
           multinum=multinum+1;
           temp3=1;
         end
         if temp3==0
          tempstr=makeMATLABcallstring(howmany,subscripts,centercomma,parens,i,j);
          if ~isempty(tempstr)
           if length(find(strcmp(maxmxinputs,tempstr)))==0
            maxmxinputs{length(maxmxinputs)+1}=tempstr;
           end
          end
          if howmany==0
           temp=[temp,'''',funstrwords{i}{j},''')'];
          else
           for k=1:howmany
            if k==howmany,
             temp=[temp,subscripts{k},',''',funstrwords{i}{j},''')'];
            else
             temp=[temp,subscripts{k},','];
            end
           end
          end
          if funstrwords_b{i}(j)==1
           if howmany==0
            funstr{i}=[temp,funstr{i}((funstrwords_e{i}(j)+1):end)];
           else
            funstr{i}=[temp,funstr{i}(parens(2)+1:end)];
           end
          else
           try %This catches some common mistakes
            funstr{i}=[funstr{i}(1:(funstrwords_b{i}(j)-1)),temp,funstr{i}((parens(2)+1):end)];
% 	   end
           catch%Finish try block
            disp(['Do you have a string someplace it shouldnlt be?',r,'Are all variables saved in ',filename,'.mat?']);
            funstr{i}
            kb
           end
          end
          %showall(funstr),i,j,'Either you left the keyboard command there, or you haven't saved some variable in the workspace file.',keyboard
          updatefunstr(i);
          count=1;gotto=i;
         elseif temp3==1 %0 output mlcall0 case
          for k=1:howmany, temp=[temp,subscripts{k},',']; end
          for k=1:howmany2
           if k==howmany2,
            rightside=parens2(2);leftside=centercomma2(k-1);
            fid=find((funstrwords_b{i}<rightside)&(funstrwords_b{i}>leftside));
            [howmany3,subscripts3,centercomma3,parens3]=hassubscript(i,fid(1));
            if howmany3==2
             temp=[temp,funstrwords{i}{fid(1)},',[',subscripts3{1},'],[',subscripts3{2},'],''',funstrwords{i}{j},''')'];
            else
             temp=[temp,subscripts2{k},',''',funstrwords{i}{j},''')'];
            end
           elseif k==1
            rightside=centercomma2(1);leftside=parens2(1);
            fid=find((funstrwords_b{i}<rightside)&(funstrwords_b{i}>leftside));
            [howmany3,subscripts3,centercomma3,parens3]=hassubscript(i,fid(1));
            if howmany3==2
             temp=[temp,funstrwords{i}{fid(1)},',[',subscripts3{1},'],[',subscripts3{2},'],'];
            else
             temp=[temp,subscripts2{k},','];
            end	  
           else
            rightside=centercomma2(k);leftside=centercomma2(k-1);
            fid=find((funstrwords_b{i}<rightside)&(funstrwords_b{i}>leftside));
            [howmany3,subscripts3,centercomma3,parens3]=hassubscript(i,fid(1));
            if howmany3==2
             temp=[temp,funstrwords{i}{fid(1)},',[',subscripts3{1},'],[',subscripts3{2},'],'];
            else
             temp=[temp,subscripts2{k},','];
            end	  
           end
          end
          funstr{i}=[temp,';'];
          updatefunstr(i);
          count=1;gotto=i;
         end
        else
         updatefunstr(i);
         if tempflag(2), count=1;gotto=i+tempflag(2)-1; end
        end
       end
%%%      else
%%%       if ~any(strcmpi(funstrwords{i}(1),{'print';'deallocate';'call';'error'}))
%%%        goon=1;
%%%        temp=findstr('=',funstr{i});
%%%        if ~isempty(temp)
%%%         for fid=1:length(temp)
%%%          if inwhichlast(i,temp(fid))==0
%%%           goon=0;
%%%          end
%%%         end
%%%        end
%%%        if (goon&(length(find(strcmp(funstrwords{i}{1},keywords)))==0)&(length(find(strcmp(funstrwords{i}{1},funwords)))==0))
%%%         funstr{i}=['print *,',funstr{i}];
%%%         updatefunstr(i);
%%%         count=1;gotto=i;
%%%         if length(find(strcmp('print',fortranfunwords)))==0
%%%          fortranfunwords{length(fortranfunwords)+1}='print';
%%%         end
%%%        end
%%%       end
      end
     end
    end
   end
   if count==1, break; end
  end
 end
 if want_kb,disp('finished word conversions'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((tempans=='n')|(tempans=='k')), keyboard, end, end
%%%end

%We need to change = assignments.
%try
 fprintf(1,' ');pticker=pticker+1;
 if want_fb&(~want_kb),fprintf(1,' fixing assignments ................................ 1');end
 count=1;gotto=1;
 while count==1
  count=0;
  for i=gotto:s
   fprintf(1,b);fprintf(1,ticker{tickercount});
   tickercount=tickercount+1;if tickercount>11, tickercount=1; end
   if i==s, fprintf(1,b);fprintf(1,ticker{pticker}); end
   if count==0;
    dummy=findstr('=',funstr{i});
    fid=1;
    if count==0
     if ~isempty(dummy)
      for j=1:length(dummy)
       temp=dummy(j);
       if inwhichlast(i,temp)==0
        fid=0;
        if length(find(strcmp(funstrwords{i}{1},keywordsbegin)))==0
         if (length(find(strcmp(funstrwords{i}(1),inoutother3)))>0)
          %'got1111111111111a',funstr{i},funstr{i}(1:temp)
          tempstr='';
          tempstr(2)=makeMATLABcallstring(1,{funstr{i}(temp:length(funstr{i}))},[],[temp length(funstr{i})],i,inf);
          if ~any(strcmp(tempstr(2),typs{5})) %scalars on the right will be promoted to anything
           tempstr(1)=makeMATLABcallstring(1,{funstr{i}(1:temp)},[],[1 temp-1],i,inf);
           temp1=[];           temp2=[];           temp3=[];
           for k=1:length(tempstr)
            if ~isempty(find(strcmp(tempstr(k),barr)))
             [temp1(k),temp2(k)]=find(strcmp(tempstr(k),barr)); temp3(k)=0;
            else
             [temp1(k),temp2(k)]=find(strcmp(tempstr(k),barr2));temp3(k)=1;
            end
           end
%%%           if any(strcmp('kk',funstrwords{i}{1}))
%%%            'got111111111111122',funstr{i},funstr{i}(1:temp),tempstr,kb
%%%           end
           if ~((temp3(1)==temp3(2))&(temp2(1)==temp2(2))) %So we need to math up the shapes
            %funstr{i}
            if any(strcmp(tempstr(1),typs{5}))
             funstr{i}=[funstr{i}(1:temp),'mxs(',funstr{i}(temp+1:end-1),');'];
            elseif any(strcmp(tempstr(1),typs{4}))
             if any(strcmp(tempstr(2),typs{11}))
              funstr{i}=[funstr{i}(1:temp),'[',funstr{i}(temp+1:end-1),'];'];
             end
            elseif any(strcmp(tempstr(1),typs{1})) %Can't do much for a mismatch
            elseif any(strcmp(tempstr(1),typs{9})) %row on left
             if any(strcmp(tempstr(2),typs{4}))     %1-D on right
              funstr{i}=[funstr{i}(1:temp),'spread(',funstr{i}(temp+1:end-1),',1,1);'];
             elseif any(strcmp(tempstr(2),typs{10}))%col on right, transpose
              funstr{i}=[funstr{i}(1:temp),'transpose(',funstr{i}(temp+1:end-1),');'];
             end
            elseif any(strcmp(tempstr(1),typs{10}))%col on left
             if any(strcmp(tempstr(2),typs{4}))     %1-D on right
              funstr{i}=[funstr{i}(1:temp),'transpose(spread(',funstr{i}(temp+1:end-1),',1,1));'];
             elseif any(strcmp(tempstr(2),typs{9}))%row on right, transpose
              funstr{i}=[funstr{i}(1:temp),'transpose(',funstr{i}(temp+1:end-1),');'];
             end
            end
            %funstr{i},%kb
           end
          end
%%%          if any(strcmp('kk',funstrwords{i}{1}))
%%%           'got1111111111111',funstr{i},funstr{i}(1:temp),tempstr,kb
%%%          end
         end
        end
        count=1;gotto=i+1;        break
       end
      end
     end
     if length(find(strcmp(funstrwords{i}{1},keywords)))~=0 | any(strcmpi(funstrwords{i}(1),{'print';'deallocate';'call';'error';'return'}))
      fid=0;
     end
     if fid
      funstr{i}=['print *,''',funstr{i}(1:end-1),''',',funstr{i}];
      updatefunstr(i);
      if length(find(strcmp('print',fortranfunwords)))==0
       fortranfunwords{length(fortranfunwords)+1}='print';
      end
     end
    end
   end
   if count==1, break; end
  end
 end
 if want_kb,disp('finished fixing scalar assignments'),disp(r),showall(funstr),disp(r),keyboard,end
 if want_fb&(~want_kb),fprintf(1,' finished \n');end
%%%catch
%%% disp(r);disp(funstr{i});disp(['line number ',num2str(i)]);disp(lasterr);disp(r);
%%% disp('Conversion error in preceeding line.');
%%% disp('Try to continue? [y,<return>]');
%%% tempans=input('or enter keyboard mode? [n,k]','s');
%%% if ~isempty(tempans), if ((tempans=='n')|(tempans=='k')), keyboard, end, end
%%%end

fprintf(1,['     ',num2str(s),' lines',r]);
%showall(funstr),keyboard

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Done with swithover routines %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Switch brackets if want_br==0
if want_br==0
 for i=1:s
  temp=findstr('[',funstr{i});
  count=0;
  for j=1:length(temp)
   funstr{i}=[funstr{i}(1:temp(j)-1+count),'(/',funstr{i}(temp(j)+1+count:end)];
   count=count+1;
  end
  updatefunstr(i);
 end
 for i=1:s
  temp=findstr(']',funstr{i});
  count=0;
  for j=1:length(temp)
   funstr{i}=[funstr{i}(1:temp(j)-1+count),'/)',funstr{i}(temp(j)+1+count:end)];
   count=count+1;
  end
  updatefunstr(i);
 end
end

% Now make the call to make_mex_gateway
if ~want_sb
 if want_kb, disp(['  Calling make_mex_gateway']);end
 make_mex_gateway(filename,inoutother,cw,vararginout,localvartype,want_fb,want_kb,alpha);
else
 if want_kb, disp(['  Calling make_mex_subroutine']);end
 make_mex_subroutine(filename,inoutother,cw,vararginout,localvartype,want_sb-1,want_fb,want_kb,recursive);
end

% Add other variables (inoutother{3}) to fortran declaration list with sizes
filenamef=[filename,'.f90'];
if exist(filenamef)==2
 fid=fopen(filenamef);
 filestr=fscanf(fid,'%c');
 fclose(fid);
else
 error('Didn''t produce a gateway fortran file for some reason...');
end
 
temp=['All other local variables',r];
dummy=findstr(temp,filestr);
%First we need to decide whether the local vars are complexes or reals.
for i=1:length(inoutother{3})
 goon=0;
 if ~isempty(vararginlocal)
  temp2=0;
  for k=1:length(vararginlocal)
   if length(find(strcmp(vararginlocal{k}{1},inoutother{3}{i})))>0
    temp2=find(strcmp(vararginlocal{k}{2},inoutother{1}));
    temp3=k;
   end
  end
  %If the size was specified as an input...
  if temp2>0
   if prod(size(getfield(cw,inoutother{1}{temp2})))>1
%%%    if want_sb==0
%%%     tempstr=['',localvartype{i},' ',inoutother{3}{i},'(',vararginlocal{temp3}{2},'_m,',vararginlocal{temp3}{2},'_n)',r];
%%%    else
     tempstr=['',localvartype{i},' ',inoutother{3}{i},'(size(',vararginlocal{temp3}{2},',1),size(',vararginlocal{temp3}{2},',2))',r];
%%%    end
   else
    tempstr=['',localvartype{i},' ',inoutother{3}{i},r];
   end
   goon=1;
  end
 end
 %If we have to decide its size dynamically
 if goon==0
  temp3=0;temp2=[0 0];clear temp5;temp5{1}='';temp5{2}='';
  for j=1:length(inoutother{1})
   if ((size(getfield(cw,inoutother{3}{i}),1)==size(getfield(cw,inoutother{1}{j}),1))&(size(getfield(cw,inoutother{3}{i}),2)==size(getfield(cw,inoutother{1}{j}),2)))
    temp3=j;temp2=[0 0];temp5{1}='_m';temp5{2}='_n';
    if want_fb|want_kb
     if i<11
      disp(['  Setting the size of local var ',inoutother{3}{i},' equal to the size of input var ',inoutother{1}{j},'.']);
     end
    end
    break
   end
   if size(getfield(cw,inoutother{3}{i}),1)==size(getfield(cw,inoutother{1}{j}),1)
    if size(getfield(cw,inoutother{3}{i}),1)~=1
     temp3=inf;temp2(1)=j;temp5{1}='_m';temp5{3}='1';
    end
   end
   if size(getfield(cw,inoutother{3}{i}),1)==size(getfield(cw,inoutother{1}{j}),2)
    if size(getfield(cw,inoutother{3}{i}),1)~=1
     temp3=inf;temp2(1)=j;temp5{1}='_n';temp5{3}='2';
    end
   end
   if size(getfield(cw,inoutother{3}{i}),2)==size(getfield(cw,inoutother{1}{j}),1)
    if size(getfield(cw,inoutother{3}{i}),2)~=1
     temp3=inf;temp2(2)=j;temp5{2}='_m';temp5{4}='1';
    end
   end
   if size(getfield(cw,inoutother{3}{i}),2)==size(getfield(cw,inoutother{1}{j}),2)
    if size(getfield(cw,inoutother{3}{i}),2)~=1
     temp3=inf;temp2(2)=j;temp5{2}='_n';temp5{4}='2';
    end
   end
  end
  if temp3~=0
   if ~isinf(temp3)
    %This local var's dimensions matches axactly with an input var's
    if prod(size(getfield(cw,inoutother{1}{temp3})))>1
%%%     if want_sb==0
%%%      tempstr=['',localvartype{i},' ',inoutother{3}{i},'(',inoutother{1}{temp3},'_m,',inoutother{1}{temp3},'_n)',r];
%%%     else
      tempstr=['',localvartype{i},' ',inoutother{3}{i},'(size(',inoutother{1}{temp3},',1),size(',inoutother{1}{temp3},',2))',r];
%%%     end
    else
     if ~isreal(getfield(cw,inoutother{1}{temp3}))
      tempstr=['complex ',inoutother{3}{i},r];
     else
      tempstr=['',localvartype{i},' ',inoutother{3}{i},r];
     end 
    end
   else
    %This local var size matches some dimensions but not exactly w/ one input
    temp1=size(getfield(cw,inoutother{3}{i}));
    if ((temp1(1)==1)&(temp1(2)==1))
     tempstr=['',localvartype{i},' ',inoutother{3}{i},r];
    else
     if all(temp2)
%%%      if want_sb==0
%%%       tempstr=['',localvartype{i},' ',inoutother{3}{i},'(',inoutother{1}{temp2(1)},temp5{1},',',inoutother{1}{temp2(2)},temp5{2},')',r];
%%%      else
       tempstr=['',localvartype{i},' ',inoutother{3}{i},'(size(',inoutother{1}{temp2(1)},',',temp5{3},'),size(',inoutother{1}{temp2(2)},',',temp5{4},'))',r];
%%%      end
     elseif temp2(1)
%%%      if want_sb==0
%%%       tempstr=['',localvartype{i},' ',inoutother{3}{i},'(',inoutother{1}{temp2(1)},temp5{1},',',num2str(temp1(2)),')',r];
%%%      else
       tempstr=['',localvartype{i},' ',inoutother{3}{i},'(size(',inoutother{1}{temp2(1)},',',temp5{3},'),',num2str(temp1(2)),')',r];
%%%      end
     elseif temp2(2)
%%%      if want_sb==0
%%%       tempstr=['',localvartype{i},' ',inoutother{3}{i},'(',num2str(temp1(1)),',',inoutother{1}{temp2(2)},temp5{2},')',r];
%%%      else
       tempstr=['',localvartype{i},' ',inoutother{3}{i},'(',num2str(temp1(1)),',size(',inoutother{1}{temp2(2)},',',temp5{4},'))',r];
%%%      end
     end
    end
   end
  else
   %So this local var matches none of the inputs
   temp1=size(getfield(cw,inoutother{3}{i}));
   if ((temp1(1)==1)&(temp1(2)==1))
    tempstr=['',localvartype{i},' ',inoutother{3}{i},r];
   else
    tempstr=['',localvartype{i},' ',inoutother{3}{i},'(',num2str(temp1(1)),',',num2str(temp1(2)),')',r];
   end
  end
 end
 filestr=[filestr(1:dummy+length(temp)-1),tempstr,filestr(dummy+length(temp):length(filestr))];
end
if want_fb|want_kb
 if i>10
  disp('   . . .');
 end
end
 
%Add pim eps, and iji if we need them.
temp=['!     All other local variables'];
dummy=findstr(temp,filestr);
if length(findstr([funstr{:}],'iji='))>0
 temp2=['integer iji',r];
else 
 temp2='';
end
if needpi==1
 if needeps==1
  temp1=['!     Matlab function pointers',r,...
	 'real, parameter :: pi=3.141592653589793238',r,...
	 'real, parameter :: eps=2.220446049250313e-16',r,temp2];
 else
  temp1=['!     Matlab function pointers',r,...
	 'real, parameter :: pi=3.141592653589793238',r,temp2];
 end
else
 if needeps==1
  temp1=['!     Matlab function pointers',r,...
	 'real, parameter :: eps=2.220446049250313e-16',r,temp2];  
 else
  temp1=['!     Matlab function pointers',r,temp2];
 end
end
filestr=[filestr(1:(dummy-1)),temp1,filestr(dummy:length(filestr)),r];
 
%Add the pointer vars for m-file calls.
temp=['!     All other local variables'];
dummy=findstr(temp,filestr);
temp1='';
if maxTRC(1)>0 
 temp1=[temp1,'real, pointer, dimension(:,:) :: '];
 for i=1:maxTRC(1)
  if i~=maxTRC(1)
   temp1=[temp1,'mxTR',num2str(i),', '];
  else
   temp1=[temp1,'mxTR',num2str(i),r];
  end
 end
end
if maxTRC(2)>0 
 temp1=[temp1,'complex, pointer, dimension(:,:) :: '];
 for i=1:maxTRC(2)
  if i~=maxTRC(2)
   temp1=[temp1,'mxTC',num2str(i),', '];
  else
   temp1=[temp1,'mxTC',num2str(i),r];
  end
 end
end
if maxTRC(3)>0 
 temp1=[temp1,'integer, pointer, dimension(:,:) :: '];
 for i=1:maxTRC(3)
  if i~=maxTRC(3)
   temp1=[temp1,'mxTI',num2str(i),', '];
  else
   temp1=[temp1,'mxTI',num2str(i),r];
  end
 end
end
filestr=[filestr(1:(dummy-1)),temp1,filestr(dummy:length(filestr)),r];

%Add the use command for what we need.
temp=['!     size variables'];
dummy=findstr(temp,filestr);
if want_sb==0
 temp1=['!     Before anything, list what modules we will use.',r,...
	'use mexfunctions;   use mexoperators;   use mexcallback',r];
else
 temp1=['!     Before anything, list what modules we will use.',r,...
	'use mexoperators;   use mexcallback',r];
end 
filestr=[filestr(1:(dummy-1)),temp1,filestr(dummy:length(filestr)),r];

%We must change the file a bit to allow for scalars.
% First make the var declaration scalar if need be for ins and outs
if want_sb==0
 temp1=['!     Input/Output local mirrors'];
 temp2=['!     Matlab function pointers'];
 dummy(1)=findstr(temp1,filestr);
 dummy(2)=findstr(temp2,filestr);
 tempstr=filestr((dummy(1)+length(temp1)+1):(dummy(2)-1));
 for i=1:length(inoutother{2})
  if prod(size(getfield(cw,inoutother{2}{i})))==1
   rets=findstr(r,tempstr);
   temp3=findstr([' ',inoutother{2}{i},''],tempstr);
   temp=rets(rets>temp3);temp=temp(1);
   tempstr=[tempstr(1:(temp3+length([' ',inoutother{2}{i},''])-1)),tempstr(temp:length(tempstr))];
  end
 end
 filestr=[filestr(1:(dummy(1)+length(temp1))),tempstr,filestr((dummy(2)):length(filestr))];
 for i=1:length(inoutother{2})
  if prod(size(getfield(cw,inoutother{2}{i})))==1
   rets=findstr(r,filestr);
   temp3=findstr(['call ',filename,'('],filestr);
   temp1=rets(rets<temp3);temp1=temp1(end);
   temp=rets(rets>temp3);temp=temp(1);
   tempstr=filestr((temp1)+1:(temp)-1);
   tempstr=regexprep(tempstr,['(\W)(',inoutother{2}{i},')(\W)'],'$1$2(1,1)$3');
   filestr=[filestr(1:(temp1)),tempstr,filestr((temp):end)];
  end
 end
 for i=1:length(inoutother{1})
  if prod(size(getfield(cw,inoutother{1}{i})))==1
   rets=findstr(r,filestr);
   temp3=findstr(['call ',filename,'('],filestr);
   temp1=rets(rets<temp3);temp1=temp1(end);
   temp=rets(rets>temp3);temp=temp(1);
   tempstr=filestr((temp1)+1:(temp)-1);
   tempstr=regexprep(tempstr,['(\W)(',inoutother{1}{i},')(\W)'],'$1$2(1,1)$3');
   filestr=[filestr(1:(temp1)),tempstr,filestr((temp):end)];
  end
 end
end

%Set all local and output variables = 0 if want_0 is 1
if want_0
 temp=['!     Fill in vars going in and out'];
 dummy=findstr(temp,filestr);
 count=1;temp1='';
 for i=1:length(inoutother{2})
  temp1=[temp1,inoutother{2}{i},'=0;'];
  count=count+1;
 end
 for i=1:length(inoutother{3})
  temp1=[temp1,inoutother{3}{i},'=0;'];
  count=count+1;
 end
 if temp1(length(temp1))~=r, temp1=[temp1,r]; end
 filestr=[filestr(1:(dummy-1)),temp1,filestr(dummy:length(filestr)),r];
end

%And finally the main interpreted body of the function
temp=['! --- Main computational routine. --------------------------------------',r];
dummy=findstr(temp,filestr);
updatefunstr;
for i=s:-1:1
  filestr=[filestr(1:dummy+length(temp)-1),...
	   '',funstr{i}(1:end-1),r...
	   ,filestr(dummy+length(temp):length(filestr))];
end
dummy=length(varargin);
if want_sb==0
 filestr=[filestr,...
	  '!------------------------------------------------------------------!',r,...
	  '!     This file generated by matlab2fmex: ',datestr(now),'     !'];
 filestr=[filestr,r,...
	  '!------------------------------------------------------------------!'];
 filestr=[filestr,r];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Steps precursing compilation
%First thing is to convert and add all the subroutines
if ((~want_sb)&(iscell(filename_al)))
 for i=2:max(size(filename_al))
  if ((iscell(tempflagin_all))&(max(size(tempflagin_all))>(i-1)))
   tempstr=tempflagin_all{i};
  else
   tempstr=tempflagin;
  end
  tempstr(8)=suborfun(i)+1;
  fid=['[temp,temp1,temp2,temp3,tempflag,temp4]=matlab2fmex({filename_al{i} filename_al{1:i-1} filename_al{i+1:max(size(filename_al))}},tempstr'];
  for j=1:max(size(vararginout_all))
   if ((max(size(vararginout_all{j}))>=i)&(iscell(vararginout_all{j}{i})))
    fid=[fid,',vararginout_all{',num2str(j),'}{',num2str(i),'}'];
   end
  end
  fid=[fid,');'];
  eval(fid);
  %Set suborfun as the result of this conversion
  suborfun=suborfun&temp4;
  %Now add those subroutines procedures and code to the main mex file
  mexfunctions=[mexfunctions,temp{1}];
  %mexfunctions,suborfun,kb
 end
end


%Now make the  modules
if ((want_fb|want_kb)&(want_ct)), disp(['  Creating mexcallback module...']); end
dummy=makeMexcallbackmodule(maxmxinputs,maxmxinputs0,alpha);
out{3}=dummy;

if ((want_fb|want_kb)&(want_ct)), disp(['  Creating mexoperators module...']); end
for i=1:length(needed_interfaces{1,1})
 if strcmp(needed_interfaces{1,1}{i}(1:2),'mx')
  eval(['[temp1,temp2,temp3]=',needed_interfaces{1,1}{i}(1:length(needed_interfaces{1,1}{i})),'_make(needed_interfaces{1,2}{i}(:,1));']);
 else
  eval(['[temp1,temp2,temp3]=',needed_interfaces{1,1}{i}(1:length(needed_interfaces{1,1}{i})-1),'_make(needed_interfaces{1,2}{i}(:,1));']);
 end
 mexoperatorinterfaces{1}=[mexoperatorinterfaces{1} temp1];
 mexoperatorinterfaces{2}=[mexoperatorinterfaces{2} temp2 r];
end
dummy=[mexoperatorinterfaces{1} mexoperatorinterfaces{2} mexoperatorinterfaces{3}];
if alpha==1
 temp=findstr('integer lhs(50), rhs(50)',dummy);
 if ~isempty(temp)
  for i=1:length(temp)
   temp=findstr('integer lhs(50), rhs(50)',dummy);temp=temp(1);
   dummy=[dummy(1:temp+6),'*8',dummy(temp+7:length(dummy))];
  end
 end
end
out{4}=dummy;

if want_ct
 mexfunctions=['module mexfunctions',r,...
               'contains',r,...
               'subroutine placeholder(m)',r,...
               'integer m',r,...
               'end subroutine placeholder',r,r,...
               mexfunctions,r,...
               'end module mexfunctions',r];
 if ((want_fb|want_kb)&(want_ct)), disp(['  Creating mexfunctions module...']); end
 out{2}=mexfunctions;
end

%Write converted file out
fid=fopen(filenamef,'w');
filestr=filestr(find(filestr~=char(9))); %Remove tabs from the file
%filestr=justify(filestr);
out{1}=filestr;
filestr=justify([out{4},r,r,r,out{3},r,r,r,out{2},r,r,r,out{1}]);
% replace real and complex declarations with real(8) and complex(8)
filestr=regexprep(filestr, 'real(,*)(\s+)([\w:])','real(8)$1 $3','ignorecase');
filestr=regexprep(filestr, 'complex(,*)(\s+)([\w:])','complex(8)$1 $3','ignorecase');
%%%temp='\<(\d+\.\d+|\d+\.|\.\d+|\d+)([eE])([+-]?\d+)';
%%%filestr=regexprep(filestr,temp,'$1d$3');
%%%temp='\<(\d+\.\d+|\d+\.|\.\d+)([^0-9eEdD])';
%%%filestr=regexprep(filestr,temp,'$1d0$2');
%'dddddddddddddd',kb
fprintf(fid,'%c',filestr);
fclose(fid);
if want_fb|want_kb
 disp([' ']);
 disp(['Finished writing ',filenamef,':'])
 if size(funstr,1)<20
  showall(funstr,1);
 else
  showall(funstr(1:20),1);
  disp(['   . . .'])
 end
 disp([' ']);
 if want_ct|want_fb
  disp(['Starting compilation of ',filenamef])
 end
end

if want_ct
 if want_fb|want_kb
  disp(['Calling mex to compile the output at ',filenamef]);
 end
 temp1='';   if want_fb, temp1=' -v'; end
 disp([' ==> mex',temp1,' ',filenamef,' ',libraries]);
      eval(['mex',temp1,' ',filenamef,' ',libraries]);
end

if want_kb,'At the end.',keyboard; end
warning on

%To run the following 4 examples as well as internew.m and internew_sep.m, 
% run TESTING.m from the fulldistribution. 
% This script needs ~300MB of RAM to run!
% Adjust variable sizes in TESTING.m for smaller amounts of RAM.
% 
% For additional tests, run TESTING_uoi.m from the testsuite_m2f directory.
% This translates the same *.m files used in the Majic project at:
% http://polaris.cs.uiuc.edu/~galmasi/majic/majic.html
% and then compares matlab2fmex results with those of Majic.

%myfunc example statements
% matlab2fmex('myfunc');
% x=rand(2);t=cputime;z=myfunc(x);cputime-t
% x=rand(2000);t=cputime;z=myfunc(x);cputime-t

%zsdmn2 example statements
% matlab2fmex('zsdmn2',[0 0 0 0 1 0 0 0 0 0]);
% tt=cputime;out=zsdmn2(0,10,200+200i,500,1,10000,zeros(10002,1));cputime-tt

%gasket example statements
% matlab2fmex('gasket');
% n=5000000;g=zeros(1000,1000);t=cputime;g=gasket(n,g,ones(n,1));cputime-t

%nibble

%Other examples:
% load internew;Z=ones(length(bf),length(bf));vs=zeros(pos^2,pos^2);as=zeros(1,pos+1);t=cputime;Z=internew(v,c,bf,bfdir,clim,E0,k,pos,omega,mu0,epsilon0,vs,as,Z);cputime-t
% matlab2fmex('internew',[0 0 0 0 1 0 0 0 0 0]);
% load internew;Z=ones(length(bf),length(bf));vs=zeros(pos^2,pos^2);as=zeros(1,pos+1);t=cputime;Z=internew(v,c,bf,bfdir,clim,E0,k,pos,omega,mu0,epsilon0,vs,as,Z);cputime-t

% load internew_sep;Z=ones(length(bf),length(bf));vs=zeros(pos^2,pos^2);as=zeros(1,pos+1);t=cputime;Z=internew_sep(v,c,bf,bfdir,clim,E0,k,pos,omega,mu0,epsilon0,vs,as,Z);cputime-t
% matlab2fmex({'internew_sep' 'internew_pad'},[0 0 0 0 1 0 0 0 0 0]);
% load internew_sep;Z=ones(length(bf),length(bf));vs=zeros(pos^2,pos^2);as=zeros(1,pos+1);t=cputime;Z=internew_sep(v,c,bf,bfdir,clim,E0,k,pos,omega,mu0,epsilon0,vs,as,Z);cputime-t

% [Bn]=vsph_pro(40,3,0,0,zeros(70,1));
% matlab2fmex({'vsph_pro' 'dgauleg' 'lqmns' 'lpmns' 'spheigen' 'zsdmn' 'sphr1rat' 'sphang' 'MNcoef' 'MNsub' 'intang'});
% [Bn]=vsph_pro(40,3,0,0,zeros(70,1));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%End matlab2fmex.
