function [] = GUI_2()
% Demonstrate how to add a new entry to a uicontrol string.  
% Creates a listbox with some strings in it, an editbox and a pushbutton.  
% User types some text into the editbox, then pushes the pushbutton.  The 
% user's text will be added to the top of the listbox.
% 
% Suggested exercise:  Modify the code so that hitting return after a 
% string is typed performs the same task as pushing the pushbutton.
%
%
% Author:  Matt Fig
% Date:  7/15/2009

S.fh = figure('units','pixels',...
              'position',[500 500 200 300],...
              'menubar','none',...
              'name','GUI_2',...
              'numbertitle','off',...
              'resize','off');

S.ls = uicontrol('style','list',...
                 'unit','pix',...
                 'position',[10 110 180 180],...
                 'min',0,'max',2,...
                 'fontsize',14,...
                 'string',{'one';'two';'three';'four'});         
S.ed = uicontrol('style','edit',...
                 'unit','pix',...
                 'position',[10 60 180 30],...
                 'fontsize',14,...
                 'string','New String');
S.pb = uicontrol('style','push',...
                 'units','pix',...
                 'position',[10 10 180 40],...
                 'fontsize',14,...
                 'string','Add String',...
                 'callback',{@ed_call,S});

            
            
function [] = ed_call(varargin)
% Callback for pushbutton, adds new string from edit box.
S = varargin{3};  % Get the structure.
oldstr = get(S.ls,'string'); % The string as it is now.
addstr = {get(S.ed,'string')}; % The string to add to the stack.
% The order of the args to cat puts the new string either on top or bottom.
set(S.ls,'str',{addstr{:},oldstr{:}});  % Put the new string on top -OR-
% set(S.ls,'str',{oldstr{:},addstr{:}});  % Put the new string on bottom.


