function [] = GUI_3()
% Demonstrate how to hide a uicontrol from the user.  
% Creates a textbox and a checkbox.  The state of the checkbox determines 
% whether or not the textbox is visible.
%
%
% Author:  Matt Fig
% Date:  7/15/2009

S.fh = figure('units','pixels',...
              'position',[300 300 200 130],...
              'menubar','none',...
              'name','GUI_3',...
              'numbertitle','off',...
              'resize','off');        
S.tx = uicontrol('style','text',...
                 'unit','pix',...
                 'position',[10 70 180 40],...
                 'string','Hello',...
                 'backgroundcolor','r',...
                 'fontsize',23);
S.ch = uicontrol('style','check',...
                 'unit','pix',...
                 'position',[10 20 180 35],...
                 'string','   Check2hide',...
                 'fontsize',14);
set(S.ch,'callback',{@ch_call,S})  % Set callback.
            
function [] = ch_call(varargin)
% Callback for pushbutton.
S = varargin{3};  % Get the structure.

switch get(S.tx,'visible')
    case 'on'     % The text is visible, make it invisible.
        set(S.ch,'string','   Uncheck2show');
        set(S.tx,'visible','off')
    case 'off'    % The text is invisible, make it visible.
        set(S.ch,'string','   Check2hide');
        set(S.tx,'visible','on')
    otherwise  % This should never happen!
        disp('Matlab entered the twilight zone, aborting.')
        close(S.fh)
        quit
end