function [] = GUI_31()
% Demonstrate multiple uicontrol manipulations based on user choices.
% Creates a simple calculator which allows the user to make a choice of
% operations to use, as well as to enter numbers on which to operate.
% Notice that the static textbox will update to show which operation is
% current.
%
% Suggested exercise:  Add more operations to the popup, and have the code
% detect a rational answer (as best as you can with floating point, there 
% are many ways to do this, just pick some criteria).  If the answer is  
% not rational, change the '=' to '~' to mean, 'approximately equal to.'
%
%
% Author:  Matt Fig
% Date:  7/15/2009

S.fh = figure('units','pixels',...
              'position',[400 400 300 130],...
              'menubar','none',...
              'name','GUI_31',...
              'numbertitle','off',...
              'resize','off');
COL = get(S.fh,'color');          
S.pp = uicontrol('style','pop',...
                  'unit','pix',...
                  'position',[10 20 120 30],...
                  'string',{'Add';'Multiply';'Subtract';'Divide';'Power'});
S.ed(1) = uicontrol('style','edit',...
                    'unit','pix',...
                    'position',[10 90 70 30],...
                    'string','3');
S.tx(1) = uicontrol('style','text',...
                    'unit','pix',...
                    'position',[85 90 20 30],...
                    'string','+',...
                    'fontsize',16,...
                    'backgroundcolor',COL);                  
S.ed(2) = uicontrol('style','edit',...
                    'unit','pix',...
                    'position',[110 90 70 30],...
                    'string','2');  
S.tx(2) = uicontrol('style','text',...
                    'unit','pix',...
                    'position',[185 90 20 30],...
                    'string','=',...
                    'fontsize',16,...
                    'backgroundcolor',COL);                 
S.ed(3) = uicontrol('style','edit',...
                    'unit','pix',...
                    'position',[220 90 70 30],...
                    'string','answer');
S.pb = uicontrol('style','push',...
                  'unit','pix',...
                  'position',[160 20 120 30],...
                  'string','Calculate',...
                  'call',{@pb_call,S});
set(S.pp,'callback',{@pp_call,S});               


function [] = pb_call(varargin)
% Callback for pushbutton
S = varargin{3};  % Get the structure.
N = str2double(get(S.ed(1:2),'string'));  % The numbers to operate on.
VL = get(S.pp,{'str','value'});  % Users choice from popup.

switch VL{1}{VL{2}}  % Users string choice from popup.
    case 'Add'
        N = num2str(sum(N));
    case 'Multiply'
        N = num2str(prod(N));
    case 'Subtract'
        N = num2str(-diff(N));
    case 'Divide'
        N = num2str(N(1)/N(2));
    case 'Power'
        N = num2str(N(1).^N(2));        
    otherwise
end
             
set(S.ed(3),'str',N) ;  % Set the 'answer' editbox to display result.


function [] = pp_call(varargin)
% Callback for pushbutton
S = varargin{3};  % Get the structure.
VL = get(S.pp,{'str','value'});  % Users choice from popup.

switch VL{1}{VL{2}}
    case 'Add'
        str = '+';
    case 'Multiply'
        str = 'x';
    case 'Subtract'
        str = '-';
    case 'Divide'
        str = '/';
    case 'Power'
        str = '^';
    otherwise
end

set(S.tx(1),'string',str)  % Change the textbox to display operation symb.