function [] = GUI_7()
% Demonstrate how to store choice counters for multiple user choices.  
% Creates a popup with two choices and a textbox to display the number of 
% times each choice has been made.  
%
%
% Author:  Matt Fig
% Date:  7/15/2009

S.fh = figure('units','pixels',...
              'position',[300 300 300 100],...
              'menubar','none',...
              'name','GUI_7',...
              'numbertitle','off',...
              'resize','off');
S.tx = uicontrol('style','tex',...
                 'unit','pix',...
                 'position',[10 15 280 20],...
                 'backgroundcolor',get(S.fh,'color'),...
                 'fontsize',12,'fontweight','bold',... 
                 'string','OPTION 1:  0      OPTION 2:  0');
S.pp = uicontrol('style','pop',...
                 'unit','pix',...
                 'position',[10 60 280 20],...
                 'backgroundc',get(S.fh,'color'),...
                 'fontsize',12,'fontweight','bold',... 
                 'string',{'option 1';'option 2'},'value',1);
S.CNT = [0 0];  % Holds the number of times each option has been called.
set(S.pp,'callback',{@pp_call,S});  % Set the callback.             


function [] = pp_call(varargin)
% Callback for popupmenu.
S = varargin{3};  % Get the structure.
P = get(S.pp,'val'); % Get the users choice from the popup.
S.CNT(P) = S.CNT(P) + 1;  % Increment the counter.
set(S.tx, 'string', sprintf('OPTION 1:  %i     OPTION 2:  %i', S.CNT));
set(S.pp,'callback',{@pp_call,S});  % Save the new count.