function [find, vaf, outperm] = cirarobfnd_ac(prox, inperm, kblock)

% CIRAROBFND fits a circular anti-Robinson matrix using iterative 
% projection to a symmetric proximity matrix in the $L_{2}$-norm
% based on a permutation identified through the use of 
% iterative quadratic assignment.
%
% syntax: [find, vaf, outperm] = cirarobfnd_ac(prox, inperm, kblock)
%
% PROX is the input proximity matrix ($n \times n$ with a zero 
% main diagonal and a dissimilarity interpretation);
% INPERM is a given starting permutation (assumed to be around the
% circle) of the first $n$ integers;
% FIND is the least-squares optimal matrix (with variance-
% accounted-for of VAF) to PROX having a circular anti-Robinson
% form for the row and column object ordering given by the ending
% permutation OUTPERM. KBLOCK defines the block size in the use
% the iterative quadratic assignment routine.  In contrast to
% cirarobfnd.m, the circular target is constructed using cirfitac.m (as
% opposed to cirfit.m)

n = size(prox,1);
targcircular = targcir(n);

[outperm,rawindex,allperms,index] =  order(prox,targcircular,inperm,kblock);

[target,vaf,addcon] = cirfitac(prox,outperm);

[fit,vaf] = cirarobfit(prox,outperm,target);

nprevperm = 1;

while (nprevperm == 1)
    
    nprevperm = 0;
    prevperm = outperm;
    inperm = outperm;
    
    [outperm,rawindex,allperms,index] = order(prox,fit,inperm,kblock);
    [fit,vaf] = cirarobfit(prox,outperm,target);
    
    if (any(prevperm - outperm) == 1)
        nprevperm = 1;
    end
end

find = fit;
