function [circum,radius,coord,degrees,cumdegrees] = ... 
    circularplot(circ,inperm)

% CIRCULARPLOT plots the object set using the coordinates
% around a circular structure derived from the $n \times n$ 
% interpoint distance matrix around a circle given by CIRC. 
% The positions are labeled by the order of objects
% given in INPERM.
%
% syntax: [circum,radius,coord,degrees,cumdegrees] = ...
%   circularplot(circ,inperm)
%
% The output consists of a plot, the circumference of the 
% circle (CIRCUM) and radius (RADIUS); the coordinates of 
% the plot positions (COORD), and the degrees and cumulative
% degrees induced between the plot positions 
% (in DEGREES and CUMDEGREES).
% The positions around the circle are numbered from 1
% (at the "noon" position) to $n$, moving 
% clockwise around the circular structure.

n = size(circ,1);
coord = zeros(n,2);
circum = 0;

for i = 1:(n-1)
    circum = circum + circ(i,i+1);
end

circum = circum + circ(1,n);
radius = circum/(2*pi);

cumdegrees = zeros(n,1);
degrees = zeros(n,1);
lengths = zeros(n,1);

for i = 1:(n-1)
    degrees(i) = circ(i,i+1)/radius;
end

degrees(n) = circ(1,n)/radius;

cumdegrees(1) = degrees(1);
lengths(1) = 2*radius*sin(cumdegrees(1)/2);

for i = 2:(n-1)
    cumdegrees(i) = cumdegrees(i-1) + degrees(i);
    lengths(i) = 2*radius*sin(cumdegrees(i)/2);
end

cumdegrees(n) = cumdegrees(n-1) + degrees(n);

for i = 1:(n-1)
    coord(i+1,2) = (2*(radius^2) - (lengths(i)^2))/(2*radius);
    
    if(cumdegrees(i) <= pi)
        coord(i+1,1) = sqrt((radius^2) - (coord(i+1,2)^2));
    else
        coord(i+1,1) = -sqrt((radius^2) - (coord(i+1,2)^2));
    end
    
end

coord(1,1) = 0;
coord(1,2) = radius;

plot(coord(1:n,1),coord(1:n,2),'ko')

hold on

for i = 1:n
    objectlabels{i,1} = int2str(inperm(i));
end

text(coord(1:n,1),coord(1:n,2),objectlabels,'fontsize',10,'verticalalignment','bottom')



