function [stanproxtm, stanproxmulttm] = proxstdtm(proxtm,mean)

%  PROXSTDTM produces a standardized two-mode 
%  proximity matrix (STANPROXTM) from the input
%  $nrow \times ncol$ two-mode proximity matrix (PROXTM) with a 
%  dissimilarity interpretation. 
%
%  syntax: [stanproxtm, stanproxmulttm] = proxstdtm(proxtm,mean)
%
%  STANPROXTM entries have unit variance (standard deviation 
%  of one) with a mean of MEAN given as an input number; 
%  STANPROXMULTTM entries have a sum of squares equal to 
%  $nrow*rcol$.

[nrow ncol]  = size(proxtm);
aveprox = sum(sum(proxtm))/(nrow*ncol);
sumprxsq = sum(sum(proxtm.^2));
stddev = sqrt(((1/(nrow*ncol))*sumprxsq) - (aveprox*aveprox));
stanproxtm = zeros(nrow,ncol);
stanproxmulttm = zeros(nrow,ncol);

for i = 1:nrow
   for j = 1:ncol
                    
         stanproxtm(i,j) = ((proxtm(i,j) - aveprox)/stddev) + mean;
         stanproxmulttm(i,j) = (nrow*ncol)*(proxtm(i,j)/sqrt(sumprxsq));
                
     end
end
