function [prox] = randprox(n)

%  RANDPROX produces a random symmetric proximity matrix (PROX) of size
%  $n \times n$, with a zero main diagonal and entries uniform
%  between 0 and 1.
%
%  syntax: [prox] = randprox(n)


prox = zeros(n,n);

for i = 1:n-1
   for j = (i+1):n
       
      prox(i,j) = rand;
      prox(j,i) = prox(i,j);
      
   end
end

      