function [fit, vaf, outperm, rowperm, colperm] = arobfndtm(proxtm, inperm, kblock)

% AROBFNDTM finds and fits an anti-Robinson
% form using iterative projection to
% a two-mode proximity matrix in the $L_{2}$-norm based on a 
% permutation identified through the use of iterative quadratic
% assignment.
% PROXTM is the input two-mode proximity matrix 
% ($n_{a} \times n_{b}$ with a zero main diagonal
% and a dissimilarity interpretation);
% INPERM is a given starting permutation 
% of the first $n = n_{a} + n_{b}$ integers;
% FIT is the least-squares optimal matrix (with 
% variance-accounted-for of VAF) to PROXTM having the anti-Robinson
% form for the row and column
% object ordering given by the ending permutation OUTPERM. KBLOCK
% defines the block size in the use the iterative quadratic
% assignment routine. ROWPERM and COLPERM are the resulting 
% row and column permutations for the objects.

[nrow ncol] = size(proxtm);
n = nrow + ncol;

targlinear = targlin(n);

[outperm,rawindex,allperms,index,squareprox] =  ordertm(proxtm,targlinear,inperm,kblock);

[fit,vaf,rowperm,colperm] = arobfittm(proxtm,outperm);


