function [find,vaf] = atreectul(prox,inperm)

% ATREECTUL finds and fits an additive tree by first fitting
% a centroid metric (using centfit.m) and 
% secondly an ultrametric to the residual
% matrix (using ultrafnd.m).
% PROX is the input proximity matrix (with a zero main diagonal
% and a dissimilarity interpretation);
% INPERM is a permutation that determines the order in which the
% inequality constraints are considered;
% FIND is the found least-squares matrix (with variance-accounted-
% for of VAF) to PROX satisfying the additive tree constraints.

n = size(prox,1);

[ctfnd,ctvaf,lengths] = centfit(prox);

resprox = prox - ctfnd;

[ulfnd,ulvaf] = ultrafnd(resprox,inperm);

targ = ctfnd + ulfnd;

[find,vaf] = atreefit(prox,targ);
