function [] = biplottm(axes,nrow,ncol)

% BIPLOTTM plots the combined row and column object set using 
% coordinates given in the $n \times 2$ matrix AXES; here the
% number of rows is NROW and the number of columns is NCOL, 
% and $n$ is the sum of NROW and NCOL.
% The first NROW rows of AXES give the row object coordinates;
% the last NCOL rows of AXES give the column object coordinates.
% The plotting symbol for rows is a circle (o);
% for columns it is an asterisk (*).
% The labels for rows are from 1 to NROW; 
% those for columns are from 1 to NCOL. 

n = nrow + ncol;

plot(axes(1:nrow,1),axes(1:nrow,2), 'ko')

hold on

for i = 1:nrow
    rowlabels{i,1} = int2str(i);
end

    text(axes(1:nrow,1),axes(1:nrow,2),rowlabels,'fontsize',10,'verticalalignment','bottom')


plot(axes((nrow+1):n,1),axes((nrow+1):n,2), 'k*')

for i = 1:ncol
    collabels{i,1} = int2str(i);
end

    text(axes((nrow+1):n,1),axes((nrow+1):n,2),collabels,'fontsize',10,'verticalalignment','bottom')
