function [fit,vaf,lengths] = centfittm(proxtm)
 
% CENTFITTM finds the least-squares fitted two-mode centroid metric 
% (FIT) to PROXTM, the two-mode rectangular input proximity matrix
% (with a dissimilarity interpretation);
% The $n$ values (where $n$ = number of rows + number of columns)
% serve to define the approximating sums,
% $u_{i} + v_{j}$, where the $u_{i}$ are for the rows and the $v_{j}$
% are for the columns; these are given in  the vector LENGTHS of size
% $n \times 1$, with row values first followed by the column values.

   [nrow ncol] = size(proxtm);
   n = nrow + ncol;
   lengths = zeros(n,1);
   fit = zeros(nrow,ncol);
   
   cmeans = sum(proxtm)/nrow;
   rmeans = sum(proxtm')/ncol;
   gmean = sum(sum(proxtm))/(nrow*ncol);
   
   for i = 1:nrow
      
      lengths(i) = rmeans(i) - ((1/2)*gmean);
      
   end
   
   for j = 1:ncol
      
      lengths(j+nrow) = cmeans(j) - ((1/2)*gmean);
      
   end
   
   for i = 1:nrow
      for j = 1:ncol
         
         fit(i,j) = lengths(i) + lengths(j+nrow);
         
      end
   end
   
   diff = sum(sum((proxtm - fit).^2));
   denom = sum(sum((proxtm - gmean).^2));
   vaf = 1 - (diff/denom);
   
   
   
   