function [fit, vaf] = cirarobfit(prox,inperm,targ)

% CIRAROBFIT fits a circular anti-Robinson matrix using iterative 
% projection to a symmetric proximity matrix in the $L_{2}$-norm.
% PROX is the input proximity matrix ($n \times n$ with a zero 
% main diagonal and a dissimilarity interpretation);
% INPERM is a given permutation of the first $n$ integers (around
% a circle); TARG is a given $n \times n$ matrix having the
% circular anti-Robinson form that guides the direction in which
% distances are taken around the circle.
% FIT is the least-squares optimal matrix (with variance-
% accounted-for of VAF) to PROX having an circular anti-Robinson
% form for the row and column object ordering given by INPERM.

n = size(prox,1);
work = zeros(n*(n-1)*(n-2),1);
fit = prox(inperm,inperm);
cr = 1.0;

while (cr >= 1.0e-006)
   
   cr = 0.0;
   indexll = 0;
   
   for jone = 1:(n-2)
      for jtwo = (jone+1):(n-1)
         
         p1 = fit(jone,jtwo);
         p2 = fit(jone,jtwo+1);
         
         fit(jone,jtwo) = fit(jone,jtwo) - work(indexll+1);
         fit(jone,jtwo+1) = fit(jone,jtwo+1) - work(indexll+2);
         
         if(((abs(targ(jone,jtwo) - targ(jone,jtwo+1)) < 1.0e-006) ...
               | ((targ(jone,jtwo) < targ(jone,jtwo+1)) & ...
               (fit(jone,jtwo) > fit(jone,jtwo+1)))) | ...
               ((targ(jone,jtwo) > targ(jone,jtwo+1)) & ...
               (fit(jone,jtwo) < fit(jone,jtwo+1))))
            
            ave = (fit(jone,jtwo) + fit(jone,jtwo+1))/2.0;
            work(indexll+1) = ave - fit(jone,jtwo);
            work(indexll+2) = ave - fit(jone,jtwo+1);
            fit(jone,jtwo) = ave;
            fit(jone,jtwo+1) = ave;
            
            cr = cr + abs(fit(jone,jtwo) - p1) + ...
               abs(fit(jone,jtwo+1) - p2);
            
         else
            work(indexll+1) = 0.0;
            work(indexll+2) = 0.0;
            
         end
         
         indexll = indexll + 2;
         
      end
   end
   
      
      
      
   for jone = 3:n
      for jtwo = 1:(jone-2)
         
         p1 = fit(jtwo,jone);
         p2 = fit(jtwo+1,jone);
         
         fit(jtwo,jone) = fit(jtwo,jone) - work(indexll+1);
         fit(jtwo+1,jone) = fit(jtwo+1,jone) - work(indexll+2);
         
         if(((abs(targ(jtwo+1,jone) - targ(jtwo,jone)) < 1.0e-006) ...
               | ((targ(jtwo+1,jone) < targ(jtwo,jone)) & ...
               (fit(jtwo+1,jone) > fit(jtwo,jone)))) | ...
               ((targ(jtwo+1,jone) > targ(jtwo,jone)) & ...
               (fit(jtwo+1,jone) < fit(jtwo,jone))))
            
            ave = (fit(jtwo+1,jone) + fit(jtwo,jone))/2.0;
            work(indexll+1) = ave - fit(jtwo,jone);
            work(indexll+2) = ave - fit(jtwo+1,jone);
            fit(jtwo+1,jone) = ave;
            fit(jtwo,jone) = ave;
            
            cr = cr + abs(fit(jtwo,jone) - p1) + ...
               abs(fit(jtwo+1,jone) - p2);
            
         else
            work(indexll+1) = 0.0;
            work(indexll+2) = 0.0;
            
         end
         
         indexll = indexll + 2;
         
      end
   end
   
      
      
      
   for jone = 2:(n-1)
   
         
         p1 = fit(jone,n);
         p2 = fit(1,jone);
         
         fit(jone,n) = fit(jone,n) - work(indexll+1);
         fit(1,jone) = fit(1,jone) - work(indexll+2);
         
         if(((abs(targ(jone,n) - targ(1,jone)) < 1.0e-006) ...
               | ((targ(jone,n) < targ(1,jone)) & ...
               (fit(jone,n) > fit(1,jone)))) | ...
               ((targ(jone,n) > targ(1,jone)) & ...
               (fit(jone,n) < fit(1,jone))))
            
            ave = (fit(jone,n) + fit(1,jone))/2.0;
            work(indexll+1) = ave - fit(jone,n);
            work(indexll+2) = ave - fit(1,jone);
            fit(jone,n) = ave;
            fit(1,jone) = ave;
            
            cr = cr + abs(fit(jone,n) - p1) + ...
               abs(fit(1,jone) - p2);
            
         else
            work(indexll+1) = 0.0;
            work(indexll+2) = 0.0;
            
         end
         
         indexll = indexll +2;
         
      end
      
      
   end
   
   
                    
                     
   for jone = 1:(n-1)
      for jtwo = (jone+1):n
                  
         fit(jtwo,jone) = fit(jone,jtwo);
         
      end
   end
   
  aveprox = sum(sum(prox))/(n*(n-1));

for i = 1:n
   for j = 1:n
      if( i ~= j)
         proxave(i,j) = aveprox;
      else
         proxave(i,j) = 0;
      end
   end
end

diff = sum(sum((prox(inperm,inperm) - fit).^2));

denom = sum(sum((prox(inperm,inperm) - proxave).^2));

vaf = 1 - (diff/denom);
                      
