function [outperm, rawindex, allperms, index] = ...
   insertqa(prox, targ, inperm, kblock)

% INSERTQA carries out an iterative 
% Quadratic Assignment maximization task using the
% insertion of from 1 to KBLOCK 
% (which is less than or equal to $n-1$) consecutive objects in 
% the permutation defining the row and column order of the data 
% matrix.
% INPERM is the input beginning permutation 
% (a permutation of the first $n$ integers).
% PROX is the $n \times n$ input proximity matrix.
% TARG is the $n \times n$ input target matrix.
% OUTPERM is the final permutation of PROX with the cross-product
% index RAWINDEX with respect to TARG.
% ALLPERMS is a cell array containing INDEX entries corresponding
% to all the permutations identified in the optimization from 
% ALLPERMS{1} = INPERM to ALLPERMS{INDEX} = OUTPERM.

tic;
begindex = sum(sum(prox(inperm,inperm).*targ));
outperm = inperm;
nchange = 1;
n = length(inperm);
index = 1;
allperms{index} = inperm;


while (nchange == 1)
   
   nchange=0;
   
   for k = 1:kblock
      for insertpt = 1:(n+1)
         for nlimlow = 1:(n+1-k)
            
            intrperm = outperm;
            
            if (nlimlow > insertpt)
               
               jtwo = 0;
               for j = insertpt:(insertpt+k-1)
                  intrperm(j) =outperm(nlimlow+jtwo);
                  jtwo = jtwo + 1;
               end
               
               jone = 0;
               for j = (insertpt+k):(nlimlow+k-1);
                  intrperm(j) = outperm(insertpt+jone);
                  jone = jone + 1;
               end
               
            elseif ((nlimlow+k) < insertpt)
               
               jtwo = 0;
               for j = (insertpt-k):(insertpt-1)
                  intrperm(j) = outperm(nlimlow+jtwo);
                  jtwo = jtwo + 1;
               end
               
               jone = 0;
               for j = nlimlow:(insertpt-k-1)
                  intrperm(j) = outperm(nlimlow+k+jone);
                  jone = jone + 1;
               end
               
            else
               
            end
            
            tryindex = sum(sum(prox(intrperm,intrperm).*targ));
            
            if(tryindex > (begindex + 1.0e-008))
               nchange = 1;
               begindex = tryindex;
               outperm = intrperm;
               index = index +1;
               allperms{index} = intrperm;
            end
            
         end
      end
   end
end

rawindex = begindex;
toc
