function [monproxpermuttm, vaf, diff] = proxmontm(proxpermuttm, fittedtm)

%  PROXMONTM produces a monotonically transformed 
%  two-mode proximity matrix (MONPROXPERMUTTM) 
%  from the order constraints obtained 
%  from each pair of entries in the input two-mode
%  proximity matrix PROXPERMUTTM (with a dissimilarity 
%  interpretation).
%  MONPROXPERMUTTM is close to the $nrow \times ncol$ 
%  matrix FITTEDTM in the least-squares sense;
%  The variance accounted for (VAF) is how much variance
%  in MONPROXPERMUTTM can be accounted for by FITTEDTM; 
%  DIFF is the value of the least-squares criterion.

[nrow ncol] = size(proxpermuttm);
n = nrow + ncol;
work = zeros(n*(n-1)*n*(n-1),1);
targ = proxpermuttm;
fit = fittedtm;
cr = 1.0;

while (cr >= 1.0e-006)
   
  
    
   cr = 0.0;
   indexll = 0;
   
   for jone = 1:nrow
      for jtwo = 1:ncol
         for jthree = 1:nrow
            for jfour = 1:ncol
               
               if((jone ~= jthree) | (jtwo ~= jfour))
                  
                  p1 = fit(jone,jtwo);
                  p2 = fit(jthree,jfour);
                  fit(jone,jtwo) = fit(jone,jtwo) - work(indexll+1);
                  fit(jthree,jfour) = fit(jthree,jfour) - work(indexll+2);
                                    
                  
                  if((abs(targ(jone,jtwo) - targ(jthree,jfour)) ...
                        > 1.0e-006) & (targ(jone,jtwo) < ...
                        targ(jthree,jfour)))
                     
                     if(fit(jone,jtwo) <= fit(jthree,jfour))
                        
                        work(indexll+1) = 0;
                        work(indexll+2) = 0;
                        
                       
                        
                     elseif(fit(jone,jtwo) > fit(jthree,jfour))
                        
                        ave = (fit(jone,jtwo) + fit(jthree,jfour))/2.0;
                        work(indexll+1) = ave - fit(jone,jtwo);
                        work(indexll+2) = ave - fit(jthree,jfour);
                                                
                        fit(jone,jtwo) = ave;
                        fit(jthree,jfour) = ave;
                        
                    
                        
                     end
                     
                  elseif((abs(targ(jone,jtwo) - targ(jthree,jfour)) ...
                        > 1.0e-006) & (targ(jone,jtwo) > ...
                        targ(jthree,jfour)))
                     
                     if(fit(jone,jtwo) >= fit(jthree,jfour))
                        
                        work(indexll+1) = 0;
                        work(indexll+2) = 0;
                        
                       
                        
                     elseif(fit(jone,jtwo) < fit(jthree,jfour))
                        
                        ave = (fit(jone,jtwo) + fit(jthree,jfour))/2.0;
                        work(indexll+1) = ave - fit(jone,jtwo);
                        work(indexll+2) = ave - fit(jthree,jfour);
                        fit(jone,jtwo) = ave;
                        fit(jthree,jfour) = ave;
                        
                     
                        
                     end
                  end
                             
               cr = cr + abs(p1-fit(jone,jtwo)) + ...
                  abs(p2-fit(jthree,jfour));
            end
                      
               indexll = indexll + 2;
               
            end
         end
      end
   end
end

                  
                     
    
avefit = sum(sum(fit))/(nrow*ncol);

diff = sum(sum((fit - fittedtm).^2));

denom = sum(sum((fit - avefit).^2));

vaf = 1 - (diff/denom);

monproxpermuttm = fit;

               
      
               
   
   
   
   
