function [stanprox, stanproxmult] = proxstd(prox,mean)

%  PROXSTD produces a standardized proximity matrix (STANPROX)
%  from the input $n \times n$ proximity matrix 
%  (PROX) with zero main diagonal and a dissimilarity
%  interpretation. 
%  STANPROX entries have unit variance (standard deviation of one)
%  with a mean of MEAN given as an input number; 
%  STANPROXMULT (upper-triangular) entries have a sum of 
%  squares equal to $n(n-1)/2$.

n = size(prox,1);
aveprox = sum(sum(prox))/(n*(n-1));
sumprxsq = sum(sum(prox.^2));
stddev = sqrt(((1/(n*(n-1)))*sumprxsq) - ((aveprox)*(aveprox)));
stanprox = zeros(n,n);
stanproxmult = zeros(n,n);

for i = 1:n
   for j = 1:n
      
      if(i ~= j)
         
         stanprox(i,j) = ((prox(i,j) - aveprox)/stddev) + mean;
         stanproxmult(i,j) = (n*(n-1))*(prox(i,j)/sqrt(sumprxsq));
         
      else
         
         stanprox(i,j) = 0.0;
         stanproxmult(i,j) = 0.0;
         
      end
   end
end
