function [prox, targlin, targcir] = ransymat(n)

%  RANSYMAT produces a random symmetric proximity matrix of size
%  $n \times n$, plus two fixed patterned symmetric proximity
%  matrices, all with zero main diagonals.

%  The size of all the generated matrices is n.
%  PROX is symmetric with a zero main diagonal and entries uniform
%  between 0 and 1.
%  TARGLIN contains distances between equally and unit-spaced positions
%  along a line: targlin(i,j) = abs(i-j).
%  TARGCIR contains distances between equally and unit-spaced positions
%  along a circle: targcir(i,j) = min(abs(i-j),n-abs(i-j)).

prox = zeros(n,n);
targlin = zeros(n,n);
targcir = zeros(n,n);
for i = 1:n-1
   for j = (i+1):n
      prox(i,j) = rand;
      prox(j,i) = prox(i,j);
      targlin(i,j) = abs(i-j);
      targlin(j,i) = targlin(i,j);
      targcir(i,j) = min(abs(i-j),n-abs(i-j));
      targcir(j,i) = targcir(i,j);
   end
end

      