function [targcir] = targcir(n)

%  TARGCIR produces a symmetric proximity matrix of size
%  $n \times n$, containing distances 
%  between equally and unit-spaced positions
%  along a circle: targcircular(i,j) = min(abs(i-j),n-abs(i-j)).

targcir = zeros(n,n);
for i = 1:n-1
   for j = (i+1):n
     
      targcir(i,j) = min(abs(i-j),n-abs(i-j));
      targcir(j,i) = targcir(i,j);
      
   end
end

      