function [fit, vaf] = targfit(prox,targ)

% TARGFIT fits through iterative projection a given set of equality
% and inequality constraints (as represented by the equalities and
% inequalities present among the entries in a target matrix
% TARG) to a symmetric proximity matrix in the $L_{2}$-norm.
% PROX is the input proximity matrix (with a zero main diagonal
% and a dissimilarity interpretation);
% TARG is a matrix of the same size as PROX;
% FIT is the least-squares optimal matrix (with 
% variance-accounted-for of VAF) to PROX satisfying the equality and
% inequality constraints implicit in TARG.

n = size(prox,1);
work = zeros(n*(n-1)*n*(n-1),1);
fit = prox;
cr = 1.0;

while (cr >= 1.0e-008)
   cr = 0.0;
   indexll = 0;
   
   for jone = 1:(n-1)
      for jtwo = (jone+1):n
         for jthree = jone:(n-1)
            for jfour = jtwo:n
               
               if((jone ~= jthree) | (jtwo ~= jfour))
                  
                  p1 = fit(jone,jtwo);
                  p2 = fit(jthree,jfour);
                  fit(jone,jtwo) = fit(jone,jtwo) - work(indexll+1);
                  fit(jthree,jfour) = fit(jthree,jfour) - work(indexll+2);
                                    
                  if(abs(targ(jone,jtwo) - targ(jthree,jfour)) <= ...
                        1.0e-006)
                     
                     ave = (fit(jone,jtwo) + fit(jthree,jfour))/2.0;
                     work(indexll+1) = ave - fit(jone,jtwo);
                     work(indexll+2) = ave - fit(jthree,jfour);
                     fit(jone,jtwo) = ave;
                     fit(jthree,jfour) = ave;
                     
                     indexll = indexll + 2;
                     
                  elseif((abs(targ(jone,jtwo) - targ(jthree,jfour)) ...
                        > 1.0e-006) & (targ(jone,jtwo) < ...
                        targ(jthree,jfour)))
                     
                     if(fit(jone,jtwo) < fit(jthree,jfour))
                        
                        work(indexll+1) = 0;
                        work(indexll+2) = 0;
                        
                        indexll = indexll + 2;
                        
                     elseif(fit(jone,jtwo) >= fit(jthree,jfour))
                        
                        ave = (fit(jone,jtwo) + fit(jthree,jfour))/2.0;
                        work(indexll+1) = ave - fit(jone,jtwo);
                        work(indexll+2) = ave - fit(jthree,jfour);
                                                
                        fit(jone,jtwo) = ave;
                        fit(jthree,jfour) = ave;
                        
                        indexll = indexll + 2;
                        
                     end
                     
                  elseif((abs(targ(jone,jtwo) - targ(jthree,jfour)) ...
                        > 1.0e-006) & (targ(jone,jtwo) > ...
                        targ(jthree,jfour)))
                     
                     if(fit(jone,jtwo) > fit(jthree,jfour))
                        
                        work(indexll+1) = 0;
                        work(indexll+2) = 0;
                        
                        indexll = indexll + 2;
                        
                     elseif(fit(jone,jtwo) <= fit(jthree,jfour))
                        
                        ave = (fit(jone,jtwo) + fit(jthree,jfour))/2.0;
                        work(indexll+1) = ave - fit(jone,jtwo);
                        work(indexll+2) = ave - fit(jthree,jfour);
                        fit(jone,jtwo) = ave;
                        fit(jthree,jfour) = ave;
                        
                        indexll = indexll + 2;
                        
                     end
                  end
               cr = cr + abs(p1-fit(jone,jtwo)) + ...
                  abs(p2-fit(jthree,jfour));                   
               
            end
                      
          
            end
         end
      end
   end
end

   
      
                  
                     
   for jone = 1:(n-1)
      for jtwo = (jone+1):n
                  
         fit(jtwo,jone) = fit(jone,jtwo);
         
      end
   end
   
  aveprox = sum(sum(prox))/(n*(n-1));

for i = 1:n
   for j = 1:n
      if( i ~= j)
         proxave(i,j) = aveprox;
      else
         proxave(i,j) = 0;
      end
   end
end

diff = sum(sum((prox - fit).^2));

denom = sum(sum((prox - proxave).^2));

vaf = 1 - (diff/denom);
                      
               
      
               
   
   
   
   
