function [targlinear] = targlin(n)

%  TARGLIN produces a symmetric proximity matrix of size
%  $n \times n$, containing distances 
%  between equally and unit-spaced positions
%  along a line: targlinear(i,j) = abs(i-j).

targlinear = zeros(n,n);

for i = 1:n-1
   for j = (i+1):n
      
      targlinear(i,j) = abs(i-j);
      targlinear(j,i) = targlinear(i,j);
      
   end
end

      