function [ultracomp] = ultracomptm(ultraproxtm)

% ULTRACOMPTM provides a completion of a given two-mode ultrametric
% matrix to a symmetric proximity matrix satisfying the
% usual ultrametric constraints.
% ULTRAPROXTM is the $nrow \times ncol$ two-mode ultrametric matrix;
% ULTRACOMP is the completed symmetric 
% $n \times n$ proximity matrix having the usual
% ultrametric pattern, for $n = nrow + ncol$.

[nrow ncol] = size(ultraproxtm);
n = nrow + ncol;
ultracomp = zeros(n,n);

for ione = 1:nrow
    for jone = 1:ncol
        ultracomp(ione,jone + nrow) = ultraproxtm(ione,jone);
        ultracomp(jone + nrow,ione) = ultraproxtm(ione,jone);
    end
end

for ione = 1:nrow
    for itwo = 1:nrow
        if(ione ~= itwo)
            ultracomp(ione,itwo) = inf;
        end
    end
end

for jone = 1:ncol
    for jtwo = 1:ncol
        if(jone ~= jtwo)
            ultracomp(jone + nrow,jtwo + nrow) = inf;
        end
    end
end

for ione = 1:(nrow-1)
    for itwo = (ione+1):nrow
        for jone = (nrow+1):n
            if((abs(ultracomp(ione,jone) - ultracomp(itwo,jone)) > 1.0e-8 ) & ...
                    (ultracomp(ione,jone) > ultracomp(itwo,jone)))
                ultracomp(ione,itwo) = ultracomp(ione,jone);
                ultracomp(itwo,ione) = ultracomp(ione,jone);
            end
            if((abs(ultracomp(ione,jone) - ultracomp(itwo,jone)) > 1.0e-8 ) & ...
                    (ultracomp(ione,jone) < ultracomp(itwo,jone)))
                ultracomp(ione,itwo) = ultracomp(itwo,jone);
                ultracomp(itwo,ione) = ultracomp(itwo,jone);
            end
            if((abs(ultracomp(ione,jone) - ultracomp(itwo,jone)) <= 1.0e-8 ) & ...
                    (ultracomp(ione,itwo) > ultracomp(itwo,jone)))
                ultracomp(ione,itwo) = ultracomp(ione,jone);
                ultracomp(itwo,ione) = ultracomp(ione,jone);
            end
        end
    end
end

for ione = (nrow+1):(n-1)
    for itwo = (ione+1):n
        for jone = 1:nrow
            if((abs(ultracomp(ione,jone) - ultracomp(itwo,jone)) > 1.0e-8 ) & ...
                    (ultracomp(ione,jone) > ultracomp(itwo,jone)))
                ultracomp(ione,itwo) = ultracomp(ione,jone);
                ultracomp(itwo,ione) = ultracomp(ione,jone);
            end
            if((abs(ultracomp(ione,jone) - ultracomp(itwo,jone)) > 1.0e-8 ) & ...
                    (ultracomp(ione,jone) < ultracomp(itwo,jone)))
                ultracomp(ione,itwo) = ultracomp(itwo,jone);
                ultracomp(itwo,ione) = ultracomp(itwo,jone);
            end
            if((abs(ultracomp(ione,jone) - ultracomp(itwo,jone)) <= 1.0e-8 ) & ...
                    (ultracomp(ione,itwo) > ultracomp(itwo,jone)))
                ultracomp(ione,itwo) = ultracomp(ione,jone);
                ultracomp(itwo,ione) = ultracomp(ione,jone);
            end
        end
    end
end