function [orderprox,orderperm] = ultraorder(prox)

% ULTRAORDER finds for the input proximity matrix PROX 
% (assumed to be ultrametric with a zero main diagonal),
% a permutation ORDERPERM that displays the anti-
% Robinson form in the reordered proximity matrix 
% ORDERPROX; thus, prox(orderperm,orderperm) = orderprox.

n = size(prox,1);

targlinear = targlin(n);

inperm = 1:n;

[outperm,rawindex,allperms,index] = pairwiseqa(prox,targlinear,inperm);

[orderperm,rawindex,allperms,index] = insertqa(prox,targlinear,outperm,n-1);

orderprox = prox(orderperm,orderperm);