function [fit, vaf, outperm, addcon] = unicirac(prox, inperm, kblock)

% UNICIRAC finds and fits a circular 
% unidimensional scale using iterative projection to
% a symmetric proximity matrix in the $L_{2}$-norm based on a 
% permutation identified through the use of iterative
% quadratic assignment.
% PROX is the input proximity matrix ($n \times n$ with a 
% zero main diagonal and a dissimilarity interpretation);
% INPERM is a given starting permutation (assumed to be around the
% circle) of the first $n$ integers;
% FIT is the least-squares optimal matrix (with 
% variance-accounted-for of VAF) to PROX having a circular 
% anti-Robinson form for the row and column
% object ordering given by the ending permutation OUTPERM. 
% The spacings among the objects are given by the diagonal entries
% in FIT (and the extreme (1,n) entry in FIT). KBLOCK
% defines the block size in the use of the iterative quadratic
% assignment routine. 
% The additive constant for the model is given by ADDCON.

n = size(prox,1);


[outperm,rawindex,allperms,index] =  order(prox,targcir(n),inperm,kblock);

[fit,vaf,addcon] = cirfitac(prox,outperm);

if (any(outperm-inperm) ~= 0)
    
    inperm = outperm;
    [outperm,rawindex,allperms,index] = order(prox,fit,inperm,kblock);
    [fit,vaf,addcon] = cirfitac(prox,outperm);
    
end

