function [fit, vaf, outperm, rowperm, colperm, addcon, coord] = uniscaltmac(proxtm, inperm, kblock)

% UNISCALTMAC finds and fits a linear 
% unidimensional scale using iterative projection to
% a two-mode proximity matrix in the $L_{2}$-norm based on a 
% permutation identified through the use of iterative 
% quadratic assignment.
% PROXTM is the input two-mode proximity matrix 
% ($n_{a} \times n_{b}$ with a zero main diagonal
% and a dissimilarity interpretation);
% INPERM is a given starting permutation of the 
% first $n = n_{a} + n_{b}$ integers;
% FIT is the least-squares optimal matrix (with 
% variance-accounted-for of VAF) to PROXTM having a linear
% unidimensional form for the row and column
% object ordering given by the ending permutation OUTPERM.
% The spacings among the objects are given by the entries in FIT.
% KBLOCK defines the block size in the use of the iterative 
% quadratic assignment routine.
% The additive constant for the model is given by ADDCON.
% ROWPERM and COLPERM are the resulting row and column 
% permutations for the objects.  The nrow + ncol coordinates
% (ordered with the smallest set at a value of zero) 
% are given in COORD.

[nrow ncol] = size(proxtm);
n = nrow + ncol;

targlinear = targlin(n);

[outperm,rawindex,allperms,index,squareprox] =  ordertm(proxtm,targlinear,inperm,kblock);

[fit,vaf,rowperm,colperm,addcon,coord] = linfittmac(proxtm,outperm);


if (any(outperm-inperm) ~= 0)
    
    for i = 1:n
        for j =1:n
            targrenew(i,j) = abs(coord(i) - coord(j));
        end
    end
    
    inperm = outperm;
    [outperm,rawindex,allperms,index] = ordertm(proxtm,targrenew,inperm,kblock);
    [fit,vaf,rowperm,colperm,addcon,coord] = linfittmac(proxtm,outperm);
    
end