function [find, vaf, outperm] = cirsarobfnd_ac(prox, inperm, kblock)

% CIRSAROBFND fits a strongly circular 
% anti-Robinson matrix using iterative projection to
% a symmetric proximity matrix in the $L_{2}$-norm based on a 
% permutation identified through the use of 
% iterative quadratic assignment.
%
% syntax: [find, vaf, outperm] = cirsarobfnd_ac(prox, inperm, kblock)
%
% PROX is the input proximity matrix ($n \times n$ 
% with a zero main diagonal
% and a dissimilarity interpretation);
% INPERM is a given starting permutation (assumed to be around the
% circle) of the first $n$ integers;
% FIND is the least-squares optimal matrix (with variance-
% accounted-for of VAF) to PROX having a strongly 
% circular anti-Robinson form for the row and column
% object ordering given by the ending permutation OUTPERM. KBLOCK
% defines the block size in the use of the iterative
% quadratic assignment routine. In comparison to cirsarobfnd.m
% (which uses cirarobfnd.m internally), cirsarobfnd_ac uses 
% cirarobfnd_ac to identify a circular target.

[target,vaf,outperm] = cirarobfnd_ac(prox,inperm,kblock);
[fit,vaf] = cirsarobfit(prox,outperm,target);

find = fit;
