function [targcircular] = targcir(n)

%  TARGCIR produces a symmetric proximity matrix of size
%  $n \times n$, containing distances 
%  between equally and unit-spaced positions
%  around a circle: targcircular(i,j) = min(abs(i-j),n-abs(i-j)).
%
%  syntax: [targcircular] = targcir(n)


targcircular = zeros(n,n);
for i = 1:n-1
   for j = (i+1):n
     
      targcircular(i,j) = min(abs(i-j),n-abs(i-j));
      targcircular(j,i) = targcircular(i,j);
      
   end
end

      