function [] = ultraplot(ultra)

% ULTRAPLOT gives a dendrogram plot for the input ultrametric
% dissimilarity matrix ULTRA. 
%
% sytax: [] = ultraplot(ultra)

n= size(ultra,1);

vectorplot = zeros(1,(n*(n-1))/2);

min_value = min(min(ultra));

additive_constant = 0.0;

if (min_value < 0.0)
additive_constant = -min_value;
end

additive_constant

index = 0;

for i = 1:(n-1)
    for j = (i+1):n
     
        index = index + 1;
        vectorplot(1,index) = ultra(i,j) + additive_constant;
    end
end


Z = linkage(vectorplot, 'complete');

dendrogram(Z,0,'colorthreshold','default');