function [outperm,rawindex,allperms,index] =  ...
    order_missing(prox,targ,inperm,kblock,proxmiss)

% ORDER_MISSING carries out an iterative Quadratic Assignment maximization 
% task using a given square ($n x n$) proximity matrix PROX (with 
% a zero main diagonal and a dissimilarity interpretation; missing entries
% PROX are given values of zero).
%
% syntax: [outperm,rawindex,allperms,index] = ...
%   order_missing(prox,targ,inperm,kblock,proxmiss)
%
% Three separate local operations are used to permute
% the rows and columns of the proximity matrix to maximize the
% cross-product index with respect to a given square target matrix
% TARG: pairwise interchanges of objects in the permutation defining 
% the row and column order of the square proximity matrix;
% the insertion of from 1 to KBLOCK
% (which is less than or equal to $n-1$) consecutive objects in 
% the permutation defining the row and column order of the data
% matrix; the rotation of from 2 to KBLOCK 
% (which is less than or equal to $n-1$) consecutive objects in 
% the permutation defining the row and column order of the data 
% matrix. INPERM is the input beginning permutation (a permutation
% of the first $n$ integers).  PROXMISS is the same size as PROX (with
% main diagonal entries all zero); an off-diagonal entry of 1.0 denotes an
% entry in PROX that is present and 0.0 if it is absent.
% OUTPERM is the final permutation of PROX with the 
% cross-product index RAWINDEX
% with respect to TARG. ALLPERMS is a cell array containing INDEX 
% entries corresponding to all the
% permutations identified in the optimization from ALLPERMS{1} = 
% INPERM to ALLPERMS{INDEX} = OUTPERM.

n = size(prox,1);
outperm = inperm;
index = 1;
allperms{index} = inperm;

proxmean = 0;
proxstd = 0;
npres = 0;

for i = 1:(n-1)
    for j = (i+1):n
        
        if(proxmiss(i,j) == 1)
            proxmean = proxmean + prox(i,j);
            proxstd = proxstd + prox(i,j)*prox(i,j);
            npres = npres + 1;
        end
    end
end

proxmean = proxmean/npres;
proxstd = (proxstd/npres) - (proxmean*proxmean);

for i = 1:(n-1)
    for j = (i+1):n
        
        if(proxmiss(i,j) == 1)
            prox(i,j) = (prox(i,j) - proxmean)/proxstd;
            prox(j,i) = prox(i,j);
        end
    end
end


begindex = sum(sum(prox(inperm,inperm).*targ));

for iterate = 1:2
   
   nchange = 1;
   
while (nchange == 1)
   
   nchange=0;
   
   for k = 1:(n-1)
      for j = (k+1):n
                   
         intrperm = outperm;
             
         intrperm(k) = outperm(j);
         intrperm(j) = outperm(k);
         
         tryindex = sum(sum(prox(intrperm,intrperm).*targ));
            
         if(tryindex > (begindex + 1.0e-008))
            nchange = 1;
            begindex = tryindex;
            outperm = intrperm;
            index = index + 1;
            allperms{index} = intrperm;
         end
         
      end
   end
end

rawindex = begindex;
nchange = 1;

while (nchange == 1)
   
   nchange=0;
   
   for k = 1:kblock
      for insertpt = 1:(n+1)
         for nlimlow = 1:(n+1-k)
            
            intrperm = outperm;
            
            if (nlimlow > insertpt)
               
               jtwo = 0;
               for j = insertpt:(insertpt+k-1)
                  intrperm(j) =outperm(nlimlow+jtwo);
                  jtwo = jtwo + 1;
               end
               
               jone = 0;
               for j = (insertpt+k):(nlimlow+k-1);
                  intrperm(j) = outperm(insertpt+jone);
                  jone = jone + 1;
               end
               
            elseif ((nlimlow+k) < insertpt)
               
               jtwo = 0;
               for j = (insertpt-k):(insertpt-1)
                  intrperm(j) = outperm(nlimlow+jtwo);
                  jtwo = jtwo + 1;
               end
               
               jone = 0;
               for j = nlimlow:(insertpt-k-1)
                  intrperm(j) = outperm(nlimlow+k+jone);
                  jone = jone + 1;
               end
               
            else
               
            end
            
            tryindex = sum(sum(prox(intrperm,intrperm).*targ));
            
            if(tryindex > (begindex + 1.0e-008))
               nchange = 1;
               begindex = tryindex;
               outperm = intrperm;
               index = index +1;
               allperms{index} = intrperm;
            end
            
         end
      end
   end
end


rawindex = begindex;
nchange = 1;



while (nchange == 1)
   
   nchange=0;
   
   for k = 2:kblock
      for nlimlow = 1:(n+1-k)
                   
         intrperm = outperm;
            
         for j = 1:k
            intrperm(nlimlow+j-1) = outperm(nlimlow+k-j);
         end
         
         tryindex = sum(sum(prox(intrperm,intrperm).*targ));
            
         if(tryindex > (begindex + 1.0e-008))
            nchange = 1;
            begindex = tryindex;
            outperm = intrperm;
            index = index + 1;
            allperms{index} = intrperm;
         end
         
      end
   end
end



rawindex = begindex;
nchange = 1;


end
