function [find, vaf, outperm] = arobfnd(prox, inperm, kblock)

% AROBFND finds and fits an anti-Robinson
% matrix using iterative projection to
% a symmetric proximity matrix in the $L_{2}$-norm based on a 
% permutation identified through the use of iterative quadratic
% assignment.
%
% syntax: [find, vaf, outperm] = arobfnd(prox, inperm, kblock)
%
% PROX is the input proximity matrix ($n \times n$ with a zero main 
% diagonal and a dissimilarity interpretation);
% INPERM is a given starting permutation of the first $n$ integers;
% FIND is the least-squares optimal matrix (with 
% variance-accounted-for of VAF) to PROX having an anti-Robinson 
% form for the row and column object ordering given by the ending
% permutation OUTPERM. KBLOCK defines the block size in the use of the
% iterative quadratic assignment routine.

n = size(prox,1);
targlinear = targlin(n);

[outperm,rawindex,allperms,index] =  order(prox,targlinear,inperm,kblock);

[fit,vaf] = arobfit(prox,outperm);

nprevperm = 1;

while (nprevperm == 1)
    
    nprevperm = 0;
    prevperm = outperm;
    inperm = outperm;
    
    [outperm,rawindex,allperms,index] = order(prox,fit,inperm,kblock);
    [fit,vaf] = arobfit(prox,outperm);
    
    if (any(prevperm - outperm) == 1)
        nprevperm = 1;
    end
end
 
find = fit;








