
% Random effects analyses for SPM'99 using a multi-level approach
%_______________________________________________________________________
%
% This SPM manual page attepts to give an overview of the issues and
% implementation of random effects analyses in SPM. A full theoretical
% treatment is beyond the scope of this "man" page. References are
% provided below.
%
% See also: spm_getSPM.m   (contrast evaluation)
%           spm_conman.m   (contrast definition)
%
%=======================================================================
% Overview: Fixed and random effects, the SPM multi-level approach
%=======================================================================
% 
% SPM uses a fixed effects model. That is, the parameters of the model
% are assumed fixed, and of interest in their own right. The only
% random quantity considered is the residual error, characterised by
% the residual variance.
% 
% In a model with repeated measurements on a number of subjects, the
% residual error is within subject. If there is subject by response
% interaction (as there almost certainly is), then inference from a
% fixed effects analysis of the group average response is limited to
% the particular subjects studied. That is, it is a case study. To
% extend inference to the population from which the subjects were drawn
% we have to acknowledge that it is not the average response of these
% particular subjects that is of interest, but the average response for
% the population from which they are drawn. That is, the response for
% each subject is a random quantity, a random effect. To infer about
% the population average effect we must account for the variance of
% response from subject to subject, in addition to the scan to scan
% (residual) variability. Thus, we must consider two components of
% variance.
% 
% In general mixed effects models (with both random and fixed effects)
% are difficult to analyse. However, in functional neuroimaging the
% models are often fairly simple, balanced, with the only random effect
% of concern the subject by condition interaction: Further, the models
% are usually separable into individual subject models (the standard
% SPM99 designs enforce this). This enables a basic mixed effects
% analysis to be easily be carried out in two stages, corresponding to
% the two levels of variability in question. The first level is the
% intra-subject level, the second the inter-subject level.
% 
% With only one "scan" per subject, scan to scan residual variability
% *is* between subject variance. For balanced designs, by summarising
% the individual subject data with an appropriate measure, and then
% assessing those measures across subject, a random effects analysis is
% effected. Using the within-subject data to compute the summary
% measure "scan" incorporates the within-subject error into the summary
% scans, such that the between subject variability of these computed
% summary "scans" consists of both within and between subject variance.
% It's fairly easy for a balanced design to show that these are in
% exactly the right ratio for a random effects assessment of the
% overall (population) effect.
% 
% This can be simply effected within SPM99: The individual subjects are
% analysed at a within-subject level using balanced standard SPM
% models. For each subject, the contrast of the parameter estimates of
% interest is computed, and written out as a "contrast" image. (Note
% that this is *not* the SPM, just the linear combination of the
% parameter estimates.) Either individual single subject models or
% subject-separable multi-subject models can be used, since the
% parameters and therefore contrasts will be the same, all that is
% required is that the design is balanced from a multi-subject
% perspective (i.e. the individual subjects models and contrast weights
% are the same). These contrast images surmise the response for each
% subject, and are then used as input into SPM for a between-subjects
% level analysis. This would usually involve a simple model: For
% instance, a population mean effect could be assessed with a simple
% one-sample t-test. A comparison of the mean responses of two
% populations could be effected using a two-
% 
% Global normalisation and grand mean scaling should have been handled
% at the within-subject level, so there is no need for such things at
% the between subject level. Similarly, the contrast images produced
% are implicitly masked, so there is no need to (re)define the analysis
% volume in the second level analysis.
% 
% Although this second level (between subjects) analysis is a fixed
% effects model, by using summary "scans", the effect is the population
% effect (which *is* fixed). The residual error variance of this second
% level model is the variance of the contrast images from subject to
% subject, and consists of contributions from both the between and
% within subject components of variance, in the correct proportions. It
% can easily be shown that the resulting analysis is mathematically
% identical to the appropriate random effects (strictly called mixed
% effects) analysis of these data.
% 
%
%=======================================================================
% The SPM99 approach
%=======================================================================
%
% The basic procedure for a random effects analysis in SPM99 is as follows: 
% * First, fit the model for each subject 
%     - you can model all the subjects together, 
%       provided you use a subject separable model
%     - strictly speaking, the individual subject models should be 
%       identical (i.e. this is a balanced design)
% 
% * Define the effect of interest for each subject with a t-contrast. 
%     - Each contrast will write a con_????.{img,hdr} analyze
%       image containing the contrast of the parameter estimates 
% 
% * Armed with one contrast image per subject, proceed to the second 
%  (between subject) level, feeding the contrast images back into SPM, 
%  using simple models (usually "Basic stats" models) as appropriate. 
% 
% Since you can do this with any one dimensional contrast that would
% produce an SPM{t}, you can look at regression slopes, interactions
% and so on, in addition to simple categorical comparisons.
%
%                           ----------------
%
% * Sphericity:
%
% You should only take a single contrast per subject forward to a
% second level analysis. Taking more assumes that the repeat contrasts
% within subject are independent: implicitly implying that the variance
% is "spherical". It is fairly rare that repeated measures data is
% spherical, so it's safest to just put in one contrast per subject.
% The degrees of freedom should then be just less than the number of
% subjects, which is usually quite low.
%
%                           ----------------
%
% * Implicit masking:
%
% SPM computes statistics only at voxels for which there is a full data
% set after applying and implicit, explicit or (analysis) threshold
% masking. This set of voxels constitutes the analysis volume for these
% data, usually chosen to be the intracerebral volume. (For PET/SPECT &
% basic designs, see spm_spm_ui.m for definitions of these masks and
% thresholds, and the options available. For fMRI, explicit masking is
% currently unavailable, and the "analysis threshold" is hard coded at
% the global mean (after grand mean scaling), which usually includes
% all intracerebral voxels.)
%
% ( Note that this refers to the masks and thresholds used to define     )
% ( the volume for analysis when setting up a design, not the            )
% ( thresholds and masks used when examining SPM's in the results        )
% ( section. The contrast and SPM{t} images (or ESS & SPM{F} images for  )
% ( an F-contrast - see spm_getSPM.m) are written by the results         )
% ( section once a new contrast is defined, but before any height or     )
% ( extent thresholding is applied. Only the write-filtered button in    )
% ( the results interface writes out height and extent filtered SPM{t}   )
%
% For a given statistical analysis, the output images (parameter images
% - beta_????.{img,hdr}, variance image - ResMS.{img,hdr}, contrast
% images - (con_????.{img,hdr}), ESS images - ess_????.{img,hdr}, and
% SPM images - spm{T,F}_????.{img,hdr}) are written as floating point
% images, with voxels outwith the analysis set to NaN - not a number.
% These images are implicitly masked, since SPM will omit any voxel
% with value NaN in any image.
%
% Thus, when entering contrast images into a second level analysis,
% there is no need to explicitly define the volume for analysis since
% the contrast images are already implicitly masked. The analysis
% volume will be the intersection of the analysis volumes for the
% individual subjects.
%
%                           ----------------
%
% * Global normalisation and grand mean scaling:
%
% Global normalisation and grand mean scaling should have been handled
% at the within-subject level, so there is no need for such things at
% the between subject level.
%
%                           ----------------
%
% * Only use contrast images as input for higher level analyses:
%
% It's contrast images from a first level (individual subject say)
% analysis that can be re-entered into SPM to effect an analysis at a
% higher level (across subjects say). In SPM99 these are named
% con_????.img.
% 
% The statistic (SPM) images (SPMt_????.img & SPMF_????.img) should
% *not* be entered into a second level analysis if you want to effect a
% random effects analysis. This would basically be assessing the
% significance (across subjects) of the individual subjects
% significance! (Rather than the significance (across subjects) of the
% response.
% 
% It's possible that this confusion may arise because you enter
% contrast weights to get a SPM{t}. However, the term contrast itself
% refers only to the weighted sum of the parameters, whose estimates
% given in the contrast images only form the numerator of the SPM{t}.
% (The SPM{t} is formed by dividing the contrast image by a suitable
% estimate of the standard error.)
% 
% The contrast surmises the effect, the SPM{t} the evidence for the
% effect in comparison to the residual variance for the model under
% consideration.
% 
% Contrast images should be used because they are guaranteed to be
% estimable whatever the design. In general the parameter images
% (beta_????.img) are not estimable: The "parameter estimability" bar
% on SPM printouts tells you which parameters are uniquely estimable
% for this model. A contrast with a single "1" picking out these
% estimable parameters would be a valid contrast, and the contrast
% image would be the same as the parameter image.
%
%                           ----------------
%
% * Miscellaneous notes:
% 
% For er-fMRI, you would probably need to fix the slice timing of 2D
% multi-slice acquisitions by temporal interpolation. Your model would
% have to use a canonical response (rather than a set of basis
% functions), such that the effect of interest can be extracted with a
% single contrast. You then put these contrast images into the between
% subject level analysis...
% 
% Note that this only works for one-dimensional contrasts, i.e. a
% t-contrast, with contrast weights a single vector. For F-contrasts
% (which you would use for a two-sided t-test, or to test any overall
% effect for a set of basis functions) you need a multivariate second
% level analysis. This should be possible with the Multivariate
% toolbox...
%
%
%=======================================================================
% References
%=======================================================================
%
% A paper is currently in preparation. However, the basic gist is
% reported in the abstract:
%         Holmes AP, Friston KJ (1998)
%         "Generalisability, Random Effects & Population Inference"
%         NeuroImage 7(4-2/3):S754
% The corresponding poster (HBM'98) is available from
%         http://www.fil.ion.ucl.ac.uk/spm/RFXposter.pdf
%
%                           ----------------
%
% This basic approach using summary measures is pretty standard. A good
% introductory paper (albeit for clinical trials) is:
%         Frisson L & Pocock SJ (1992)
% 	"Repeated measures in clinical trials: Analysis using mean 
% 	 summary statistics and its implications for design"
% 	Statistics in Medicine 11:1685-1704 
%
%                           ----------------
%
% The basic concepts of random effects are expounded in all but the
% most basic statistics books on "Design of Experiments". Other key
% phrases to look out for are "variance components", "mixed effects
% models", "repeated measures", "multi-level modeling" & "hierarchical
% modeling". I've found the first chapter of Searle, Casella &
% McCulloch's 1992 book "Variance Components" (Wiley, London) a good
% description accessible to non-statisticians.
%
%                           ----------------
%
% Roger Woods (1996) paper "Modeling for intergroup comparisons of
% imaging data" (Neuroimage, 4(3/3):S84-94) also provides a readable
% introduction to the concepts, with a neuroimaging slant.
%
%                           ----------------
%
% A final reference of interest: Keith Worsley et al's seminal 1991
% paper for addressing the multiple comparisons problem also proposed
% the use (for PET), of a two-sample t-statistic computed from average
% condition images! (Although they used a variance estimate pooled over
% the entire intracerebral volume rather than the voxel level variance
% estimate used in SPM.) This is a repeated measures paired t-test
% approach, identical to the current SPM approach, although (possibly)
% primarily motivated by the substantial data reduction the use of
% summary images confers.
%
%         Worsley KJ, Marrett S, Neelin P, Evans AC (1992)
% 	"A three-dimensional statistical analysis for CBF 
% 	 activation studies in human brain"
% 	Journal of Cerebral Blood Flow and Metabolism, 12:900-918
%
%
%=======================================================================
% The SPM96 approach reprised (for historical interest)
%=======================================================================
%
% With SPM96, basic random effects analyses for simple categorical
% compariosns were retrospectively implemented in a limited way using
% the "Random Effects Kit":
% http://www.fil.ion.ucl.ac.uk/spm/spm96.html#RFX96 This allowed random
% effects analyses of simple categorical comparisons by computing
% adjusted mean condition images. With two conditions, this resulted in
% two images per subject, which were then assessed at the subject level
% using a paired t-test.
%
% The adjusted condition images obtained from the SPM96 AdjMean/fMRI
% are the parameter estimates for a very simple model using box-cars,
% optionally convolved with a synthetic haemodynamic response function,
% and optionally including global intensity normalisation. Although
% these adjusted mean condition images themselves may not be uniquely
% estimated, the difference between any two (usually) is (for the
% limited models of the AdjMean/fMRI module). I.e. The difference
% between two of these adjusted mean condition images is the same as a
% contrast image for a contrast with weights of the form
% [...+1...-1...] which would contrast the two conditions.
%
% By putting the pairs of adjusted mean condition images for each
% subject into SPM96's PETstats "Multi-Subject: Conditions only" design
% (with no global normalisation), you're just doing a paired t-test:
% This SPM model used this way is equivalent to doing a t-test on the
% inter-condition intra-subject differences. I.e., The SPM96 way is
% implicitly putting [...+1...-1...] type contrasts into the second
% level analysis, by virtue of using a paired t-test on the adjusted
% mean condition images, which are just parameter estimate images.
%
% The reason for adopting this convoluted scenario was that SPM96 had
% no implicit or explicit masking - the only way to specify the volume
% for analysis in SPM96 is via an analysis threshold (expressed as a
% proportion of the global mean for each scan). For such an analysis
% threshold to be able to limit the analysis to intracerebral voxels
% (say), the input images clearly must exhibit some structure, which
% contrast images (or difference images) do not. (This was frequently
% mistakenly presented as a deficiency in SPM96's handling of negative
% data.) Adjusted condition images had the advantage of containing
% structure, and yet when assessed in a pairwise analysis effected the
% appropriate analysis.
%
%                           ---------------- 
%
% The AdjMean functions of the SPM96 random effects kit are included in
% SPM99, but we recommend using the new main SPM stats routines to
% define an appropriate model and extract an appropriate contrast image
% as summary image.
%_______________________________________________________________________
% @(#)spm_RandFX.man	2.2 Andrew Holmes 00/01/25
