function [find,vaf,targone,targtwo,outpermone,outpermtwo, ...
        rowpermone,colpermone,rowpermtwo,colpermtwo,addconone,...
        addcontwo,coordone,coordtwo,axes,monproxtm] = ...
    bimonscaltmac(proxtm,inpermone,inpermtwo,kblock,nopt)

% BIMONSCALTMAC finds and fits the sum of two linear unidimensional 
% scales using iterative projection to
% a two-mode proximity matrix in the $L_{2}$-norm based on 
% permutations identified through the use of iterative quadratic
% assignment.  It also provides an optimal monotonic transformation 
% (MONPROX) of the original input proximity matrix.
%
% syntax: [find,vaf,targone,targtwo,outpermone,outpermtwo, ...
%        rowpermone,colpermone,rowpermtwo,colpermtwo,addconone,...
%        addcontwo,coordone,coordtwo,axes,monproxtm] = ...
%    bimonscaltmac(proxtm,inpermone,inpermtwo,kblock,nopt)
%
% PROXTM is the input two-mode proximity matrix ($nrow \times ncol$
% with a dissimilarity interpretation);
% FIND is the least-squares optimal matrix (with variance-
% accounted-for of VAF) to the monotonic transformation MONPROXTM of 
% the input proximity matrix and is the sum of the two matrices
% TARGONE and TARGTWO based on the two row and column
% object orderings given by the ending permutations OUTPERMONE 
% and OUTPERMTWO, and in turn ROWPERMONE and ROWPERMTWO and 
% COLPERMONE and COLPERMTWO. KBLOCK defines the block size in 
% the use of the iterative quadratic assignment routine and ADDCONONE
% and ADDCONTWO are the two additive constants for the two model 
% components; The $n$ coordinates are in COORDONE and COORDTWO.  
% The input permutations are INPERMONE and INPERMTWO.  The 
% $n \times 2$ matrix AXES gives the plotting coordinates for the
% combined row and column object set.
% NOPT controls the confirmatory or exploratory fitting of 
% the unidimensional scales; a value of NOPT = 0 will fit in a
% confirmatory manner the two scales
% indicated by INPERMONE and INPERMTWO;
% a value of NOPT = 1 uses iterative QA
% to locate the better permutations to fit.

[nrow ncol] = size(proxtm);

[find,vaf,targone,targtwo,outpermone,outpermtwo, ...
        rowpermone,colpermone,rowpermtwo,colpermtwo,addconone,...
        addcontwo,coordone,coordtwo,axes] = biscaltmac(proxtm,inpermone,inpermtwo,kblock,nopt);

sumproxsq = sum(sum(proxtm.^2));
vafdiff = 1.0;
vaf = 0.0;
iteration = 0;

while ((vafdiff >= 1.0e-004) && (iteration < 5))
    
    vafprev = vaf;
    iteration = iteration + 1;
    
    [monproxtm vaf diff] = proxmontm(proxtm,find);
    
    summonnewsq =sum(sum(monproxtm.^2));
    monproxtm = sqrt(sumproxsq)*(monproxtm/sqrt(summonnewsq));
    
    inpermone = outpermone;
    inpermtwo = outpermtwo;
    
    [find,vaf,targone,targtwo,outpermone,outpermtwo, ...
        rowpermone,colpermone,rowpermtwo,colpermtwo,addconone,...
        addcontwo,coordone,coordtwo,axes] = biscaltmac(monproxtm,inpermone,inpermtwo,kblock,0);


vafdiff = abs(vaf - vafprev);

end