function varargout = car(varargin)
% CAR Applicartion M-file for car.fig
%    FIG = CAR launch car GUI.
%    CAR('carllback_name', ...) invoke the named carllback.

% Last Modified by GUIDE v2.0 18-Sep-2008 10:40:31
addpath lib;

if nargin == 0  % LAUNCH GUI

	fig = openfig(mfilename,'reuse');

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
    guidata(fig, handles);

    %Data Analaysis initialitation
    data.I=0;
    data.J=0;
    data.N=[];
    data.labels.x={};
    data.labels.y={};
    data.raw.x=[];
    data.raw.y=[];
    data.model.k=0;
    data.model.coordinates=0;
    data.rotation.compute=0;
    data.rotation.weights=0;
    data.rotation.method=0;
    
    indices.rows=0;
    indices.columns=0;
    indices.max=0;
    
    output.NO=[];
    
    setappdata(0,'data',data);
    setappdata(0,'output',output);
    setappdata(0,'indices',indices);
    
    if nargout > 0
		varargout{1} = fig;
	end

    %INITIALITATIONS
    ActualizeListVariables(handles);  
    set(handles.CrossTabulationTableAvailable,'value',0);
    set(handles.ToComputeCrossTabulationTable,'value',1);
    set(handles.NumberOfDimensions,'string','0');
    set(handles.AssigCrossTabulationMatrix,'enable','off');
    set(handles.ShowCrossTableMatrix,'enable','off');
    set(handles.CrossTabulationTable,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
    set(handles.DetailedOutput,'value',0);
    set(handles.ShowMap,'value',1);
    set(handles.OutputFile,'string','output.txt');
    set(handles.ComputeRotation,'value',0);
    set(handles.WeightsRotation,'enable','off');
    set(handles.RotationMethod,'enable','off');
    str={'Orthogonal rotation of symmetrical coordinates (varimax)'; 'Oblique rotation of symmetrical coordinates (quartimin)'};
    set(handles.RotationMethod,'value',1);
    set(handles.RotationMethod,'string',str);
    
    evalin('base','clc');
    
elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		disp(lasterr);
	end

end
return

% --------------------------------------------------------------------
function varargout = File_Callback(h, eventdata, handles, varargin)

return

% --------------------------------------------------------------------
function varargout = Open_Callback(h, eventdata, handles, varargin)
	try
        
        evalin('base','clear');
        evalin('base','uiload');
        evalin('base','clear ans me');
        evalin('base','clc');
        f = ActualizeListVariables(handles);
        if (f==1) ,
            
            set(handles.ToComputeCrossTabulationTable,'value',1);
            set(handles.NumberOfDimensions,'string','0');
            set(handles.AssigRows,'enable','on');
            set(handles.AssigColumns,'enable','on');
            set(handles.ShowRowVariable,'enable','on');
            set(handles.ShowColumnVariable,'enable','on');
            set(handles.textColumns,'enable','on');
            set(handles.textRows,'enable','on');
            set(handles.RowVariable,'BackgroundColor',[1 1 1]);
            set(handles.ColumnVariable,'BackgroundColor',[1 1 1]);        
            set(handles.CrossTabulationTableAvailable,'value',0);
            set(handles.AssigCrossTabulationMatrix,'enable','off');
            set(handles.ShowCrossTableMatrix,'enable','off');
            set(handles.CrossTabulationTable,'BackgroundColor',[get(0,'defaultUicontrolBackgroundColor')]);
            set(handles.RowVariable,'string','');
            set(handles.ColumnVariable,'string','');
            set(handles.CrossTabulationTable,'string','');
            set(handles.RowLabelsVariable,'string','');
            set(handles.ColumnLabelsVariable,'string','');
            set(handles.SupplementaryColumns,'string','');
            set(handles.SupplementaryRows,'string','');
            set(handles.AssigRows,'string','>');        
            set(handles.AssigColumns,'string','>');        
            set(handles.AssigRowLabels,'string','>');        
            set(handles.AssigColumnLabels,'string','>');        
            set(handles.AssigCrossTabulationMatrix,'string','>');  
            set(handles.model1,'value',1);
            set(handles.model2,'value',0);
            set(handles.model3,'value',0);
            set(handles.DetailedOutput,'value',0);
            set(handles.ShowMap,'value',0);
            set(handles.OutputFile,'string','output.txt');
            set(handles.ComputeRotation,'value',0);
            set(handles.WeightsRotation,'enable','off');
            set(handles.RotationMethod,'enable','off');
            str={'Orthogonal rotation of symmetrical coordinates (varimax)'; 'Oblique rotation of symmetrical coordinates (quartimin)'};
            set(handles.RotationMethod,'value',1);
            set(handles.RotationMethod,'string',str);
            
            evalin('base','clc');
            
        else,
            msgbox('The file is empty','CAR: Correspondence analysis with rotations','error');
            set(handles.VariablesList,'String','No variables are available');
            set(handles.VariablesList,'value',1);
            return;    
        end;
	catch
		disp(lasterr);
	end

return
% --------------------------------------------------------------------
function varargout = Save_Callback(h, eventdata, handles, varargin)
	try
       evalin('base','uisave');
	catch
		disp(lasterr);
	end

return
% --------------------------------------------------------------------
function varargout = Quit_Callback(h, eventdata, handles, varargin)
    ButtonName=questdlg('Do you want to quit the application','Correspondence Analysis'); 
    switch ButtonName
    case {'No','Cancel'}
	    % take no action
    case 'Yes'
        delete(gcf);
    end    
    
return    

% --------------------------------------------------------------------
function varargout = ClearData_Callback(h, eventdata, handles, varargin)
    ButtonName=questdlg('Do you want to clear the data in memory','Correspondence Analysis'); 
    switch ButtonName
    case {'No','Cancel'}
	    % take no action
    case 'Yes'
        evalin('base','clear');
        evalin('base','clc');
        set(handles.VariablesList,'String','No variables are available');
        set(handles.VariablesList,'value',1);
        set(handles.ToComputeCrossTabulationTable,'value',1);
        set(handles.NumberOfDimensions,'string','0');
        set(handles.AssigRows,'enable','on');
        set(handles.AssigColumns,'enable','on');
        set(handles.ShowRowVariable,'enable','on');
        set(handles.ShowColumnVariable,'enable','on');
        set(handles.textColumns,'enable','on');
        set(handles.textRows,'enable','on');
        set(handles.RowVariable,'BackgroundColor',[1 1 1]);
        set(handles.ColumnVariable,'BackgroundColor',[1 1 1]);        
        set(handles.CrossTabulationTableAvailable,'value',0);
        set(handles.AssigCrossTabulationMatrix,'enable','off');
        set(handles.ShowCrossTableMatrix,'enable','off');
        set(handles.CrossTabulationTable,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
        set(handles.RowVariable,'string','');
        set(handles.ColumnVariable,'string','');
        set(handles.CrossTabulationTable,'string','');
        set(handles.RowLabelsVariable,'string','');
        set(handles.ColumnLabelsVariable,'string','');
        set(handles.SupplementaryColumns,'string','');
        set(handles.SupplementaryRows,'string','');
        set(handles.AssigRows,'string','>');        
        set(handles.AssigColumns,'string','>');        
        set(handles.AssigRowLabels,'string','>');        
        set(handles.AssigColumnLabels,'string','>');        
        set(handles.AssigCrossTabulationMatrix,'string','>');        
        set(handles.model1,'value',1);
        set(handles.model2,'value',0);
        set(handles.model3,'value',0);
        set(handles.DetailedOutput,'value',0);
        set(handles.ShowMap,'value',0);
        set(handles.OutputFile,'string','output.txt');
        set(handles.ComputeRotation,'value',0);
        set(handles.WeightsRotation,'enable','off');
        set(handles.RotationMethod,'enable','off');
        str={'Orthogonal rotation of symmetrical coordinates (varimax)'; 'Oblique rotation of symmetrical coordinates (quartimin)'};
        set(handles.RotationMethod,'value',1);
        set(handles.RotationMethod,'string',str);
    end    
return

% --------------------------------------------------------------------
function varargout = AssigRows_Callback(h, eventdata, handles, varargin)

    set(gcbf,'Pointer','watch');
    
    indices = getappdata(0,'indices');

    %THE VARIABLE IS CLEANED
    tmp=get(handles.RowVariable,'string');
    if isempty(tmp),
        %NO NOTHING
    else,
        if indices.max > 1 ,
            indices.rows = 0;
            indices.columns = 0;
            indices.max = 0;
            setappdata(0,'indices',indices);
            set(handles.RowVariable,'string','');
            set(handles.AssigRows,'string','>');        
            set(handles.ColumnVariable,'string','');
            set(handles.AssigColumns,'string','>');        
        else
            indices.rows = 0; setappdata(0,'indices',indices);
            set(handles.RowVariable,'string','');
            set(handles.AssigRows,'string','>');        
            
        end;
        set(gcbf,'Pointer','arrow');
        return;
    end;

     s    = get(handles.VariablesList,'value');
     str  = get(handles.VariablesList,'string');
     
    %CHECKS IF THE MATRIX EXISTS IN THE WORK MEMORY SPACE
    str1 = 'exist(''';
    str2=ClearFields(str(s));
    str3 = ''',''var'')';
    str4 = char(strcat(str1,str2,str3));
    
    f = evalin('base',str4);
    if f == 0,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable is not anymore available in the work memory space','CAR: Correspondence analysis with rotations','error');
        ActualizeListVariables(handles);
        return;
    end;

    %CHECKS IF IT IS NUMERICAL
    str1 = 'isnumeric(';
    str2 = str(s);
    str3 = ')';
    str4 = char(strcat(str1,str2,str3));
    f= evalin('base',str4); 
    if f == 0,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable is not a numerical one','CAR: Correspondence analysis with rotations','error');
        return;
    end;

    %CHECKS IF IT IS A VECTOR
    str1 = {'global '};
    str2=ClearFields(str(s));
    str3 = {';'};
    str4 = char(strcat(str1,str2,str3));
    eval(str4); 
    str1 = '[f1, f2]=size(';
    str2 = str(s);
    str3 = ');';
    str4 = char(strcat(str1,str2,str3));
    eval(str4); 
    if f2 > 1,
        indices.max=f2;
        setappdata(0,'indices',indices);
		pos_size = get(handles.CAR,'Position');
		user_response = columnselector([pos_size(1)+pos_size(3)/5 pos_size(2)+pos_size(4)/5]);
		switch user_response
		case {'cancel'}
			% take no action
            set(gcbf,'Pointer','arrow');
            return;
		case 'ok'
            %THE VARIABLE IS ASSIGNED
            indices = getappdata(0,'indices');
            set(handles.RowVariable,'string',char(strcat(str(s),'(',num2str(indices.rows),')')));
            set(handles.ColumnVariable,'string',char(strcat(str(s),'(',num2str(indices.columns),')')));
            set(handles.AssigRows,'string','<');
            set(handles.AssigColumns,'string','<');
		end
        
    else
        indices.rows = 1; 
        setappdata(0,'indices',indices);
        %THE VARIABLE IS ASSIGNED
        set(handles.RowVariable,'string',str(s));
        set(handles.AssigRows,'string','<');
    end;
    
    set(gcbf,'Pointer','arrow');

return;
    
% --------------------------------------------------------------------
function varargout = AssigColumns_Callback(h, eventdata, handles, varargin)

    set(gcbf,'Pointer','watch');
    
    indices = getappdata(0,'indices');

    %THE VARIABLE IS CLEANED
    tmp=get(handles.ColumnVariable,'string');
    if isempty(tmp),
        %NO NOTHING
    else,
        if indices.max > 1 ,
            indices.rows = 0;
            indices.columns = 0;
            indices.max = 0;
            setappdata(0,'indices',indices);
            set(handles.RowVariable,'string','');
            set(handles.AssigRows,'string','>');        
            set(handles.ColumnVariable,'string','');
            set(handles.AssigColumns,'string','>');        
        else
            indices.columns = 0; setappdata(0,'indices',indices);
            set(handles.ColumnVariable,'string','');
            set(handles.AssigColumns,'string','>');
        end;
        set(gcbf,'Pointer','arrow');
        return;
    end;
        
    s    = get(handles.VariablesList,'value');
    str  = get(handles.VariablesList,'string');
    
    %CHECKS IF THE MATRIX EXISTS IN THE WORK MEMORY SPACE
    str1 = 'exist(''';
    str2=ClearFields(str(s));
    str3 = ''',''var'')';
    str4 = char(strcat(str1,str2,str3));
    
    f = evalin('base',str4);
    if f == 0,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable is not anymore available in the work memory space','CAR: Correspondence analysis with rotations','error');
        ActualizeListVariables(handles);
        return;
    else
        indices.columns = 1; 
        setappdata(0,'indices',indices);
    end;
    
    %CHECKS IF IT IS NUMERICAL
    str1 = 'isnumeric(';
    str2 = str(s);
    str3 = ')';
    str4 = char(strcat(str1,str2,str3));

    f= evalin('base',str4); 
    if f == 0,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable is not a numerical one','CAR: Correspondence analysis with rotations','error');
        return;
    end;

    %CHECKS IF IT IS A VECTOR
    str1 = {'global '};
    str2=ClearFields(str(s));
    str3 = {';'};
    str4 = char(strcat(str1,str2,str3));
    eval(str4); 
    str1 = '[f1, f2]=size(';
    str2 = str(s);
    str3 = ');';
    str4 = char(strcat(str1,str2,str3));
    eval(str4); 
    if f2 > 1,
        indices.max=f2;
        setappdata(0,'indices',indices);
		pos_size = get(handles.CAR,'Position');
		user_response = columnselector([pos_size(1)+pos_size(3)/5 pos_size(2)+pos_size(4)/5]);
		switch user_response
		case {'cancel'}
			% take no action
            set(gcbf,'Pointer','arrow');
            return;
		case 'ok'
            %THE VARIABLE IS ASSIGNED
            indices = getappdata(0,'indices');
            set(handles.RowVariable,'string',char(strcat(str(s),'(',num2str(indices.rows),')')));
            set(handles.ColumnVariable,'string',char(strcat(str(s),'(',num2str(indices.columns),')')));
            set(handles.AssigRows,'string','<');
            set(handles.AssigColumns,'string','<');
		end
    else
        indices.columns = 1; 
        setappdata(0,'indices',indices);
        %THE VARIABLE IS ASSIGNED
        set(handles.ColumnVariable,'string',str(s));
        set(handles.AssigColumns,'string','<');
    end;
    
    set(gcbf,'Pointer','arrow');
    
return;

% --------------------------------------------------------------------
function varargout = CrossTabulationVariable_Callback(h, eventdata, handles, varargin)

    set(gcbf,'Pointer','watch');

    %THE VARIABLE IS CLEANED
    tmp=get(handles.CrossTabulationTable,'string');
    if isempty(tmp),
        %NO NOTHING
    else,
        set(handles.CrossTabulationTable,'string','');
        set(handles.AssigCrossTabulationMatrix,'string','>');        
        set(gcbf,'Pointer','arrow');
        return;
    end;

     s    = get(handles.VariablesList,'value');
     str  = get(handles.VariablesList,'string');

     %CHECKS IF THE MATRIX EXISTS IN THE WORK MEMORY SPACE
    str1 = 'exist(''';
    str2=ClearFields(str(s));
    str3 = ''',''var'')';
    str4 = char(strcat(str1,str2,str3));
    
    f = evalin('base',str4);
    if f == 0,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable is not anymore available in the work memory space','CAR: Correspondence analysis with rotations','error');
        ActualizeListVariables(handles);
        return;
    end;
    
    %CHECKS IF IT IS NUMERICAL
    str1 = 'isnumeric(';
    str2 = str(s);
    str3 = ')';
    str4 = char(strcat(str1,str2,str3));

    f= evalin('base',str4); 
    if f == 0,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable is not a numerical one','CAR: Correspondence analysis with rotations','error');
        return;
    end;
    
    %CHECKS IF IT IS A MATRIX
    str1 = {'global '};
    str2=ClearFields(str(s));
    str3 = {';'};
    str4 = char(strcat(str1,str2,str3));
    eval(str4); 
    str1 = '[f1, f2]=size(';
    str2 = str(s);
    str3 = ');';
    str4 = char(strcat(str1,str2,str3));
    eval(str4); 
    if f2 < 2 ,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable must be a matrix','CAR: Correspondence analysis with rotations','error');
        return;
    end;
    if f1 < 2 ,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable must be a matrix','CAR: Correspondence analysis with rotations','error');
        return;
    end;
    
    %THE VARIABLE IS ASSIGNED
    set(handles.CrossTabulationTable,'string',str(s));
    set(handles.AssigCrossTabulationMatrix,'string','<');
    set(gcbf,'Pointer','arrow');

return;

% --------------------------------------------------------------------
function varargout = Help_Callback(h, eventdata, handles, varargin)

return

% --------------------------------------------------------------------
function varargout = HelpMenu(h, eventdata, handles, varargin)
%   system('help\car.hlp');
    system('help\car.chm');
return

% --------------------------------------------------------------------
function varargout = AboutCar_Callback(h, eventdata, handles, varargin)
     Data=1:64;Data=(Data'*Data)/64;
     h=msgbox('CAR (version: 1.03)                                                     Urbano Lorenzo-Seva (Rovira i Virgili University, Tarragona, Spain),    Michel van de Velden (Erasmus University, Rotterdam, The Netherlands), &           Henk A.L. Kiers (University of Groningen, Groningen, The Netherlands)                      Tarragona - 2009 ','About CAR','custom',Data,hot(64));
return

% --------------------------------------------------------------------
function varargout = ToComputeCrossTabulationTable_Callback(h, eventdata, handles, varargin)

    set(handles.ToComputeCrossTabulationTable,'value',1);
    set(handles.AssigRows,'enable','on');
    set(handles.AssigColumns,'enable','on');
    set(handles.textColumns,'enable','on');
    set(handles.ShowRowVariable,'enable','on');
    set(handles.ShowColumnVariable,'enable','on');
    set(handles.textRows,'enable','on');
    set(handles.RowVariable,'BackgroundColor',[1 1 1]);
    set(handles.ColumnVariable,'BackgroundColor',[1 1 1]);
    
    set(handles.CrossTabulationTableAvailable,'value',0);
    set(handles.AssigCrossTabulationMatrix,'enable','off');
    set(handles.ShowCrossTableMatrix,'enable','off');
    set(handles.CrossTabulationTable,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
return

% --------------------------------------------------------------------
function varargout = CrossTabulationTableAvailable_Callback(h, eventdata, handles, varargin)
    set(handles.ToComputeCrossTabulationTable,'value',0);
    set(handles.AssigRows,'enable','off');
    set(handles.AssigColumns,'enable','off');
    set(handles.ShowRowVariable,'enable','off');
    set(handles.ShowColumnVariable,'enable','off');
    set(handles.textColumns,'enable','off');
    set(handles.textRows,'enable','off');
    set(handles.RowVariable,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
    set(handles.ColumnVariable,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));

    set(handles.CrossTabulationTableAvailable,'value',1);
    set(handles.AssigCrossTabulationMatrix,'enable','on');
    set(handles.ShowCrossTableMatrix,'enable','on');
    set(handles.CrossTabulationTable,'BackgroundColor',[1 1 1]);
return

% --------------------------------------------------------------------
function varargout = ShowRowVariable_Callback(h, eventdata, handles, varargin)

    R = get(handles.RowVariable,'string');
    R = ClearInformationColumns(R);

    indices = getappdata(0,'indices');
    
    str1 = 'display(';
    str2 = char(strcat(R,'(:,',int2str(indices.rows),')'));
    str3 = ')';
    str4 = char(strcat(str1,str2,str3));
    if isempty(str2),
        msgbox('A variable must be selected','CAR: Correspondence analysis with rotations','error');
        return
    else,
        
        labels=get(handles.RowLabelsVariable,'string');
        if isempty(labels),
            evalin('base','clc');
            evalin('base',str4);
            str1 = 'tabulate(';
            str4 = char(strcat(str1,str2,str3));
            evalin('base',str4);
        else,
            
            evalin('base','clc');
            evalin('base',str4);
            str1 = 'TabulateLabels(';
            str4 = char(strcat(str1,str2,',',labels,str3));
            evalin('base',str4);
           
        end;
        
    end;
return

% --------------------------------------------------------------------
function varargout = ShowColumnVariable_Callback(h, eventdata, handles, varargin)
    C = get(handles.RowVariable,'string');
    C = ClearInformationColumns(C);

    indices = getappdata(0,'indices');

    str1 = 'display(';
    str2 = char(strcat(C,'(:,',int2str(indices.columns),')'));
    str3 = ')';
    str4 = char(strcat(str1,str2,str3));
    if isempty(str2),
        msgbox('A variable must be selected','CAR: Correspondence analysis with rotations','error');
        return
    else,
        
        labels=get(handles.ColumnLabelsVariable,'string');
        if isempty(labels),
            evalin('base','clc');
            evalin('base',str4);
            str1 = 'tabulate(';
            str4 = char(strcat(str1,str2,str3));
            evalin('base',str4);
        else,
            
            evalin('base','clc');
            evalin('base',str4);
            str1 = 'TabulateLabels(';
            str4 = char(strcat(str1,str2,',',labels,str3));
            evalin('base',str4);
           
        end;
        
    end;
return
% --------------------------------------------------------------------
function varargout = ShowCrossTableMatrix_Callback(h, eventdata, handles, varargin)
    str1 = 'display(';
    str2 = get(handles.CrossTabulationTable,'string');
    str3 = ')';
    str4 = char(strcat(str1,str2,str3));
    if isempty(str2),
        msgbox('A variable must be selected','CAR: Correspondence analysis with rotations','error');
        return
    else,
        
        labelsR=get(handles.RowLabelsVariable,'string');
        labelsC=get(handles.ColumnLabelsVariable,'string');
        f=0;
        if isempty(labelsR),f=1;end;
        if isempty(labelsC),f=1;end;
        
        if f==1,
            evalin('base','clc');
            evalin('base',str4);
        else,
            
            evalin('base','clc');
            str1 = 'CrossTabulateLabels(';
            str4 = char(strcat(str1,str2,',',labelsR,',',labelsC,str3));
            evalin('base',str4);
           
        end;
        
    end;
return

% --------------------------------------------------------------------
function varargout = OpenAscii_Callback(h, eventdata, handles, varargin)

    fig = itd;
    
    %UPDAT THE LIST OF AVAILABLE VARIABLES
    evalin('base','clear ans me');
    evalin('base','clc');
    vars = evalin('base','who');
    set(handles.VariablesList,'String',vars);
    set(handles.VariablesList,'value',1);        
return

% --------------------------------------------------------------------
function output=ActualizeListVariables(handles)
% if output == 1   There is data available
% if output == 0   There is not data

    set(gcbf,'Pointer','watch');
    output = 0;
    evalin('base','clear ans me');
    vars = evalin('base','who');
    [v,tmp2]=size(vars);
    if v>0,
        %ENTER VARIABLES IN THE VARLIST

        %numerical variables
        str={};
        for i=1:v,
            str1 = 'isnumeric(';
            str2 = vars(i);
            str3 = ')';
            str4 = char(strcat(str1,str2,str3));
            f= evalin('base',str4); 
            if f == 1,
               str=[str; vars(i)];
            end;
        end;
        %char variables
        for i=1:v,
            str1 = 'ischar(';
            str2 = vars(i);
            str3 = ')';
            str4 = char(strcat(str1,str2,str3));
            f= evalin('base',str4); 
            if f == 1,
               str=[str; vars(i)];
            end;
        end;
        %cell variables
        for i=1:v,
            str1 = 'iscell(';
            str2 = vars(i);
            str3 = ')';
            str4 = char(strcat(str1,str2,str3));
            f= evalin('base',str4); 
            if f == 1,
               str=[str; vars(i)];
            end;
        end;
        %structures
        for i=1:v,
            str1 = 'isstruct(';
            str2 = vars(i);
            str3 = ')';
            str4 = char(strcat(str1,str2,str3));
            f= evalin('base',str4); 
            if f == 1,
                str1 = 'fieldnames(';
                str2 = vars(i);
                str3 = ')';
                str4 = char(strcat(str1,str2,str3));
                varsFields= evalin('base',str4); 
                [vf,tmp2]=size(varsFields);
                for j=1:vf,
                    str1 = 'isnumeric(';
                    str2=strcat(vars(i),'.',varsFields(j));
                    str3 = ')';
                    str4 = char(strcat(str1,str2,str3));
                    f= evalin('base',str4); 
                    if f == 1,
                       str=[str; str2];
                    end;
                    str1 = 'ischar(';
                    str4 = char(strcat(str1,str2,str3));
                    f= evalin('base',str4); 
                    if f == 1,
                       str=[str; str2];
                    end;
                    str1 = 'iscell(';
                    str4 = char(strcat(str1,str2,str3));
                    f= evalin('base',str4); 
                    if f == 1,
                       str=[str; str2];
                    end;
                    
                end;
            end;
        end;
        
        set(handles.VariablesList,'String',str);
        set(handles.VariablesList,'value',1);
                
        %MAKE VARIABLES AS GLOBALS
        evalin('base','save tmp; clear');
        str1 = {'global '};
        str3 = {';'};
        for i=1:v,
            str2 = vars(i);
            str4 = char(strcat(str1,str2,str3));
            eval(str4); 
            evalin('base',str4);
        end;
        evalin('base','load tmp');
        output=1;
    else
            set(handles.VariablesList,'String','No variables are available');
            set(handles.VariablesList,'value',1);
            data = 0;
    end;
    set(gcbf,'Pointer','arrow');

return;
% --------------------------------------------------------------------
function output=ClearFields(str)
 
      strclean={};
      c=char(str);
      [tmp,v]=size(c);
      
      for i=1:v,
          if c(i) ~= '.',
             strclean=strcat(strclean,c(i));
          else
              output=strclean;
              return;
          end;
      end;
      
      output=strclean;
      return;
% --------------------------------------------------------------------
function output=ClearInformationColumns(str)
 
      strclean={};
      c=char(str);
      [tmp,v]=size(c);
      
      for i=1:v,
          if c(i) ~= '(',
             strclean=strcat(strclean,c(i));
          else
              output=strclean;
              return;
          end;
      end;
      
      output=strclean;
      return;
% --------------------------------------------------------------------
function varargout = AssigRowLabels_Callback(h, eventdata, handles, varargin)

    set(gcbf,'Pointer','watch');
    %THE VARIABLE IS CLEANED
    tmp=get(handles.RowLabelsVariable,'string');
    if isempty(tmp),
        %NO NOTHING
    else,
        set(handles.RowLabelsVariable,'string','');
        set(handles.AssigRowLabels,'string','>');        
        set(gcbf,'Pointer','arrow');
        return;
    end;

     s    = get(handles.VariablesList,'value');
     str  = get(handles.VariablesList,'string');
     
    %CHECKS IF THE MATRIX EXISTS IN THE WORK MEMORY SPACE
    str1 = 'exist(''';
    str2=ClearFields(str(s));
    str3 = ''',''var'')';
    str4 = char(strcat(str1,str2,str3));
    
    f = evalin('base',str4);
    if f == 0,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable is not anymore available in the work memory space','CAR: Correspondence analysis with rotations','error');
        ActualizeListVariables(handles);
        return;
    end;

    %CHECKS IF IT IS STRING
    str1 = 'ischar(';
    str2 = str(s);
    str3 = ')';
    str4 = char(strcat(str1,str2,str3));
    f1= evalin('base',str4); 
    str1 = 'iscell(';
    str4 = char(strcat(str1,str2,str3));
    f2 = evalin('base',str4);
    if (f1+f2) == 0,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable has to contain text','CAR: Correspondence analysis with rotations','error');
        return;
    end;
    
    %THE VARIABLE IS ASSIGNED
    set(handles.RowLabelsVariable,'string',str(s));
    set(handles.AssigRowLabels,'string','<');
    set(gcbf,'Pointer','arrow');

return

% --------------------------------------------------------------------
function varargout = AssigColumnLabels_Callback(h, eventdata, handles, varargin)
    set(gcbf,'Pointer','watch');
    
    %THE VARIABLE IS CLEANED
    tmp=get(handles.ColumnLabelsVariable,'string');
    if isempty(tmp),
        %NO NOTHING
    else,
        set(handles.ColumnLabelsVariable,'string','');
        set(handles.AssigColumnLabels,'string','>');        
        set(gcbf,'Pointer','arrow');
        return;
    end;

     s    = get(handles.VariablesList,'value');
     str  = get(handles.VariablesList,'string');
    %CHECKS IF THE MATRIX EXISTS IN THE WORK MEMORY SPACE
    str1 = 'exist(''';
    str2=ClearFields(str(s));
    str3 = ''',''var'')';
    str4 = char(strcat(str1,str2,str3));
    
    f = evalin('base',str4);
    if f == 0,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable is not anymore available in the work memory space','CAR: Correspondence analysis with rotations','error');
        ActualizeListVariables(handles);
        return;
    end;
    
    %CHECKS IF IT IS STRING
    str1 = 'ischar(';
    str2 = str(s);
    str3 = ')';
    str4 = char(strcat(str1,str2,str3));

    f1= evalin('base',str4); 
    str1 = 'iscell(';
    str4 = char(strcat(str1,str2,str3));
    f2 = evalin('base',str4);
    if (f1+f2) == 0,
        set(gcbf,'Pointer','arrow');
        msgbox('The variable has to contain text','CAR: Correspondence analysis with rotations','error');
        return;
    end;
    
    %THE VARIABLE IS ASSIGNED
    set(handles.ColumnLabelsVariable,'string',str(s));
    set(handles.AssigColumnLabels,'string','<');
    set(gcbf,'Pointer','arrow');

return

% --------------------------------------------------------------------
function varargout = ShowRowLabelsVariable_Callback(h, eventdata, handles, varargin)
    str1 = 'display(';
    str2 = get(handles.RowLabelsVariable,'string');
    str3 = ')';
    str4 = char(strcat(str1,str2,str3));
    if isempty(str2),
        msgbox('A variable must be selected','CAR: Correspondence analysis with rotations','error');
        return
    else,
        evalin('base','clc');
        evalin('base',str4);
    end;

return

% --------------------------------------------------------------------
function varargout = ShowColumnLabelsVariable_Callback(h, eventdata, handles, varargin)
    str1 = 'display(';
    str2 = get(handles.ColumnLabelsVariable,'string');
    str3 = ')';
    str4 = char(strcat(str1,str2,str3));
    if isempty(str2),
        msgbox('A variable must be selected','CAR: Correspondence analysis with rotations','error');
        return
    else,
        evalin('base','clc');
        evalin('base',str4);
    end;

return

% --------------------------------------------------------------------
function varargout = model1_Callback(h, eventdata, handles, varargin)
    set(handles.model1,'value',1);
    set(handles.model2,'value',0);
    set(handles.model3,'value',0);
    set(handles.model4,'value',0);
    str={'Orthogonal rotation of symmetrical coordinates (varimax)'; 'Oblique rotation of symmetrical coordinates (quartimin)'};
    set(handles.RotationMethod,'value',1);
    set(handles.RotationMethod,'string',str);
    str={'Row-wise normalization of coordinates';'To rescale coordinates using masses';'None'};
    set(handles.WeightsRotation,'value',1);
    set(handles.WeightsRotation,'string',str);
    set(handles.ComputeRotation,'enable','on');
    set(handles.WeightingText,'enable','on');
    set(handles.RotationText,'enable','on');
    
% --------------------------------------------------------------------
function varargout = model2_Callback(h, eventdata, handles, varargin)
    set(handles.model1,'value',0);
    set(handles.model2,'value',1);
    set(handles.model3,'value',0);
    set(handles.model4,'value',0);
    str={'Orthogonal rotation of principal coordinates (varimax)'; 'Orthogonal rotation of standard coordinates (varimax)';'Oblique rotation of principal coordinates (quartimin)'};
    set(handles.RotationMethod,'value',1);
    set(handles.RotationMethod,'string',str);
    str={'Row-wise normalization of coordinates';'To rescale coordinates using masses';'None'};
    set(handles.WeightsRotation,'value',1);
    set(handles.WeightsRotation,'string',str);
    set(handles.ComputeRotation,'enable','on');
    set(handles.WeightingText,'enable','on');
    set(handles.RotationText,'enable','on');

% --------------------------------------------------------------------
function varargout = model3_Callback(h, eventdata, handles, varargin)
    set(handles.model1,'value',0);
    set(handles.model2,'value',0);
    set(handles.model3,'value',1);
    set(handles.model4,'value',0);
    str={'Orthogonal rotation of principal coordinates (varimax)'; 'Orthogonal rotation of standard coordinates (varimax)';'Oblique rotation of principal coordinates (quartimin)'};
    set(handles.RotationMethod,'value',1);
    set(handles.RotationMethod,'string',str);
    str={'Row-wise normalization of coordinates';'To rescale coordinates using masses';'None'};
    set(handles.WeightsRotation,'value',1);
    set(handles.WeightsRotation,'string',str);
    set(handles.ComputeRotation,'enable','on');
    set(handles.WeightingText,'enable','on');
    set(handles.RotationText,'enable','on');

% --------------------------------------------------------------------
function varargout = model4_Callback(h, eventdata, handles, varargin)
    set(handles.model1,'value',0);
    set(handles.model2,'value',0);
    set(handles.model3,'value',0);
    set(handles.model4,'value',1);
    str={' '};
    set(handles.RotationMethod,'value',1);
    set(handles.RotationMethod,'string',str);
    str={' '};
    set(handles.WeightsRotation,'value',1);
    set(handles.WeightsRotation,'string',str);
    set(handles.ComputeRotation,'value',0);
    set(handles.ComputeRotation,'enable','off');
    set(handles.WeightingText,'enable','off');
    set(handles.RotationText,'enable','off');
    set(handles.WeightsRotation,'enable','off');
    set(handles.RotationMethod,'enable','off');

% --------------------------------------------------------------------
function varargout = ComputeRotation_Callback(h, eventdata, handles, varargin)

    f=get(handles.ComputeRotation,'value');
    if f == 1,
        set(handles.WeightsRotation,'enable','on');
        set(handles.RotationMethod,'enable','on');
    else,
        set(handles.WeightsRotation,'enable','off');
        set(handles.RotationMethod,'enable','off');
    end;

    
% --------------------------------------------------------------------
function varargout = Compute_Callback(h, eventdata, handles, varargin)

    %LOAD DATA
    me.data=getappdata(0,'data');

    %Data Analaysis initialitation
    me.data.I=0;
    me.data.J=0;
    me.data.N=[];
    me.data.labels.x={};
    me.data.labels.y={};
    me.data.raw.x=[];
    me.data.raw.y=[];
    me.data.model.k=0;
    me.data.model.coordinates=0;
    me.data.rotation.compute=0;
    me.data.rotation.weights=0;
    me.data.rotation.method=0;
    me.data.supplementary='NO';
    
    me.OutputFile = get(handles.OutputFile,'string');
    %TO CHECK IF A FILE NAME HAS BEEN ASIGNED
    if isempty(strcat(' ',char(me.OutputFile))),
        msgbox('You must indicate the name of the output file.','CAR: Correspondence analysis with rotations','error');
        return;
    end;
    
    evalin('base','clc');
    
    %TO COMPUTE CROSSTABULATION TABLE IF NOT AVAILABLE
    me.f = get(handles.ToComputeCrossTabulationTable,'value');
    if me.f==1,

        me.R=get(handles.RowVariable,'string');
        me.C=get(handles.ColumnVariable,'string');
        me.R = ClearInformationColumns(me.R);
        me.C = ClearInformationColumns(me.C);
        
        %TO CHECK IF VARIABLES HAVE BEEN ASSIGNED
        if isempty(me.R),
            msgbox('You must indicate the row variable.','CAR: Correspondence analysis with rotations','error');
            return;
        end;
        if isempty(me.C),
            msgbox('You must indicate the colunm variable.','CAR: Correspondence analysis with rotations','error');
            return;
        end;
        
        %TO GET INDICES FOR COLUMNS AND ROWS
        me.indices = getappdata(0,'indices');

        %TO DECLARE BASE VARIABLES AS GLOBALS 
        me.str1 = {'global '};
        me.str2=ClearFields(me.R);
        me.str3 = {';'};
        me.str4 = char(strcat(me.str1,me.str2,me.str3));
        eval(me.str4); 
        me.str2=ClearFields(me.C);
        me.str4 = char(strcat(me.str1,me.str2,me.str3));
        eval(me.str4); 
        
        me.str1 = 'me.data.N = crosstab(';
        me.str3 = {');'};
        me.str4 = char(strcat(me.str1,me.R,'(:,',int2str(me.indices.rows),'),',me.C,'(:,',int2str(me.indices.columns),')',me.str3));
        eval(me.str4);

        %TO ASSIGN SIZES
        [me.data.I,me.data.J]=size(me.data.N);
        
        %TO ASSIGN RAW DATA
        %X
        me.str1 = 'me.data.raw.x = ';
        me.str3 = {';'};
        me.str4 = char(strcat(me.str1,me.R,'(:,',int2str(me.indices.rows),')',me.str3));
        eval(me.str4);
        %Y
        me.str1 = 'me.data.raw.y = ';
        me.str3 = {';'};
        me.str4 = char(strcat(me.str1,me.C,'(:,',int2str(me.indices.columns),')',me.str3));
        eval(me.str4);
        
        %TO ASSIGN LABELS
        %ROWS
        me.RL = get(handles.RowLabelsVariable,'string');
        if isempty(me.RL),
            me.f=tabulate(me.data.raw.x);
            me.data.labels.x=cellstr(num2str(me.f(:,1)));
        else
            me.RL=get(handles.RowLabelsVariable,'string');
            me.str1 = {'global '};
            me.str2=ClearFields(me.RL);
            me.str3 = {';'};
            me.str4 = char(strcat(me.str1,me.str2,me.str3));
            eval(me.str4); 
            me.str1 = 'me.data.labels.x = ';
            me.str3 = {';'};
            me.str4 = char(strcat(me.str1,me.RL,me.str3));
            eval(me.str4);
        end;
        %COLUMNS
        me.CL = get(handles.ColumnLabelsVariable,'string');
        if isempty(me.CL),
            me.f=tabulate(me.data.raw.y);
            me.data.labels.y=cellstr(num2str(me.f(:,1)));        
        else
            me.CL=get(handles.ColumnLabelsVariable,'string');
            me.str1 = {'global '};
            me.str3 = {';'};
            me.str2=ClearFields(me.CL);
            me.str4 = char(strcat(me.str1,me.str2,me.str3));
            eval(me.str4); 
            %Y
            me.str1 = 'me.data.labels.y = ';
            me.str3 = {';'};
            me.str4 = char(strcat(me.str1,me.CL,me.str3));
            eval(me.str4);
        end;
        
    %TO GET USER CROSSTABULATION TABLE    
    else
        me.data.raw.x = [];
        me.data.raw.y = [];
        me.N=get(handles.CrossTabulationTable,'string');

        %CHECK IF VARIABLES HAVE BEEN ASSIGNED
        if isempty(me.N),
            msgbox('You must indicate the variable that contains the crosstabulation table.','CAR: Correspondence analysis with rotations','error');
            return;
        end;
        
        %DECLARE BASE VARIABLES AS GLOBALS 
        me.str1 = {'global '};
        me.str2=ClearFields(me.N);
        me.str3 = {';'};
        me.str4 = char(strcat(me.str1,me.str2,me.str3));
        eval(me.str4); 
        
        %TO ASSIGN CROSSTABULATION MATRIX
        %X
        me.str1 = 'me.data.N = ';
        me.str3 = {';'};
        me.str4 = char(strcat(me.str1,me.N,me.str3));
        eval(me.str4);

        %TO ASSIGN SIZES
        [me.data.I,me.data.J]=size(me.data.N);
        
        %TO ASSIGN LABELS
        %ROWS
        me.RL = get(handles.RowLabelsVariable,'string');
        if isempty(me.RL),
            [me.f1,me.f2]=size(me.data.N);
            me.data.labels.x=cellstr(num2str([1:me.f1]'));        
        else
            me.RL=get(handles.RowLabelsVariable,'string');
            me.str1 = {'global '};
            me.str2=ClearFields(me.RL);
            me.str3 = {';'};
            me.str4 = char(strcat(me.str1,me.str2,me.str3));
            eval(me.str4); 
            me.str1 = 'me.data.labels.x = ';
            me.str3 = {';'};
            me.str4 = char(strcat(me.str1,me.RL,me.str3));
            eval(me.str4);
        end;
        %COLUMNS
        me.CL = get(handles.ColumnLabelsVariable,'string');
        if isempty(me.CL),
            [me.f1,me.f2]=size(me.data.N);
            me.data.labels.y=cellstr(num2str([1:me.f2]'));        
        else
            me.CL=get(handles.ColumnLabelsVariable,'string');
            me.str1 = {'global '};
            me.str3 = {';'};
            me.str2=ClearFields(me.CL);
            me.str4 = char(strcat(me.str1,me.str2,me.str3));
            eval(me.str4); 
            %Y
            me.str1 = 'me.data.labels.y = ';
            me.str3 = {';'};
            me.str4 = char(strcat(me.str1,me.CL,me.str3));
            eval(me.str4);
        end;
        
    end;

   %CHECK LABELS BEFORE COMPUTING
   [me.f1,me.f2]=size(me.data.labels.x);
   if me.f1<me.f2,
       me.data.labels.x=me.data.labels.x';
       me.f1=me.f2;
   end;
   if me.f1 ~=me.data.I,
        msgbox('Labels are not coherent with the data. Please check the variable assigned as "Row Labels"','CAR: Correspondence analysis with rotations','error');
        return
   end;
   [me.f1,me.f2]=size(me.data.labels.y);
   if me.f1<me.f2,
       me.data.labels.y=me.data.labels.y';
       me.f1=me.f2;
   end;
   if me.f1 ~=me.data.J,
        msgbox('Labels are not coherent with the data. Please check the variable assigned as "Column Labels"','CAR: Correspondence analysis with rotations','error');
        return
   end;

   %GET SUPPLEMENTARY ROWS
    me.sup=0;
    me.SuppleRows = get(handles.SupplementaryRows,'string');
    if isempty(me.SuppleRows),
        %nothing
    else
        
      me.SupRowIndex = floor(sort(str2num(me.SuppleRows)));
      if isempty(me.SupRowIndex),
        msgbox('I do not understand the indices of the supplementary rows','CAR: Correspondence analysis with rotations','error');
        return
      end;
      if min(me.SupRowIndex) < 1,
        msgbox('Indices of the supplementary rows have to be numbers larger than zero','CAR: Correspondence analysis with rotations','error');
        return
      end;
      if max(me.SupRowIndex) > me.data.I,
        msgbox('The indices of the supplementary rows cannot be larger than the number of rows','CAR: Correspondence analysis with rotations','error');
        return
      end;
      me.NoSupRowIndex=[];
      for i=1:me.data.I,
          [me.tmp1,me.tmp2]=size(me.SupRowIndex);
          me.tmp3=1;
          for j=1:me.tmp2,
              if me.SupRowIndex(j)==i,
                  me.tmp3=0;
              end;
          end;
          if me.tmp3==1,
             me.NoSupRowIndex=[me.NoSupRowIndex i]; 
          end;
      end;
      [me.f1,me.tmp]=size(me.NoSupRowIndex');
      [me.f2,me.tmp]=size(me.SupRowIndex');
      if me.f1 < me.f2,
        msgbox('You are not allowed to have so much supplementary rows','CAR: Correspondence analysis with rotations','error');
        return
      end;
      if me.f1 < 3,
        msgbox('You are not allowed to have so much supplementary rows','CAR: Correspondence analysis with rotations','error');
        return
      end;
      me.data.supplementary.r = me.data.N(me.SupRowIndex,:);
      me.data.N = me.data.N(me.NoSupRowIndex,:);
      me.data.supplementary.labels.r = me.data.labels.x(me.SupRowIndex);
      me.data.labels.x = me.data.labels.x(me.NoSupRowIndex);
      me.sup=1;              
    end;
    
   %GET SUPPLEMENTARY COLUMNS
    me.SuppleColumns = get(handles.SupplementaryColumns,'string');
    if isempty(me.SuppleColumns),
        %nothing
    else
        
      me.SupColIndex = floor(sort(str2num(me.SuppleColumns)));
      if isempty(me.SupColIndex),
        msgbox('I do not understand the indices of the supplementary columns','CAR: Correspondence analysis with rotations','error');
        return
      end;
      if min(me.SupColIndex) < 1,
        msgbox('Indices of the supplementary columns have to be numbers larger than zero','CAR: Correspondence analysis with rotations','error');
        return
      end;
      if max(me.SupColIndex) > me.data.J,
        msgbox('The indices of the supplementary columns cannot be larger than the number of columns','CAR: Correspondence analysis with rotations','error');
        return
      end;
      me.NoSupColIndex=[];
      for i=1:me.data.J,
          [me.tmp1,me.tmp2]=size(me.SupColIndex);
          me.tmp3=1;
          for j=1:me.tmp2,
              if me.SupColIndex(j)==i,
                  me.tmp3=0;
              end;
          end;
          if me.tmp3==1,
             me.NoSupColIndex=[me.NoSupColIndex i]; 
          end;
      end;
      [me.f1,me.tmp]=size(me.NoSupColIndex');
      [me.f2,me.tmp]=size(me.SupColIndex');
      if me.f1 < me.f2,
        msgbox('You are not allowed to have so much supplementary columns','CAR: Correspondence analysis with rotations','error');
        return
      end;
      if me.f1 < 3,
        msgbox('You are not allowed to have so much supplementary columns','CAR: Correspondence analysis with rotations','error');
        return
      end;
      me.data.supplementary.c = me.data.N(:,me.SupColIndex);
      me.data.N = me.data.N(:,me.NoSupColIndex);
      me.data.supplementary.labels.c = me.data.labels.y(me.SupColIndex);
      me.data.labels.y = me.data.labels.y(me.NoSupColIndex);
      if me.sup==1,%Update supplemetary rows, if they exist
         me.data.supplementary.r = me.data.supplementary.r(:,me.NoSupColIndex);
      end;
      me.sup=1;
    end;
      
   %GET NUMBER DIMENSIONS
   me.data.model.k=0;
   me.k = str2double(get(handles.NumberOfDimensions,'string'));
   if me.k <1,
       prompt={'You must indicate the number of dimension to retain. Frequently, two dimensions are retained. However, you can consider other dimensionalities.                                    Number of dimensions:'};
       def={'2'};
       dlgTitle='Number of dimensions to retain';
       lineNo=1;
       answer=inputdlg(prompt,dlgTitle,lineNo,def);
       if isempty(answer),
           return
       end;
       me.k = str2num(char(answer(1)));
       set(handles.NumberOfDimensions,'string',answer(1));
   end;
   me.maxK = min(me.data.I-1,me.data.J-1);
   if me.k > me.maxK,
        me.str= sprintf('The maximun number of dimensions is %.0f.',me.maxK);
        msgbox(me.str,'CAR: Correspondence analysis with rotations','error');
        return
   end;
   me.data.model.k=me.k;
      
   %GET MODEL
   me.data.model.coordinates=0;
   if get(handles.model1,'value') == 1,
        me.data.model.coordinates=1;
   end;
   if get(handles.model2,'value') == 1,
        me.data.model.coordinates=2;
   end;
   if get(handles.model3,'value') == 1,
        me.data.model.coordinates=3;
   end;
   if get(handles.model4,'value') == 1,
        me.data.model.coordinates=4;
   end;

   %GET ROTATION
   me.data.rotation.compute=get(handles.ComputeRotation,'value');
   if me.data.rotation.compute == 1,       
        me.data.rotation.weights = get(handles.WeightsRotation,'value');
        me.data.rotation.method = get(handles.RotationMethod,'value');
        if me.data.model.coordinates>1,
            me.data.rotation.method = 2 + me.data.rotation.method;
        end;
   end;
   
   %SAVE DATA 
   setappdata(0,'data',me.data);

   try
        %CLEAR OUTPUT FILE
        fid=fopen(char(me.OutputFile),'w');
        fwrite(fid,' ');
        fclose(fid);

        %WRITE OUTPUT
        me.str=sprintf('diary %s;',char(me.OutputFile));
        eval(me.str);
   catch
       disp(lasterr); 
   end;
   set(gcbf,'Pointer','watch');

   %COMPUTING
   try
       me.t0 = clock;
       %CA
       if (me.sup==1),
           me.output=canalysis(me.data.N,me.data.model.k,me.data.labels.x,me.data.labels.y,me.data.supplementary,me.data.supplementary.labels);
       else,
           me.output=canalysis(me.data.N,me.data.model.k,me.data.labels.x,me.data.labels.y);
       end;           
       setappdata(0,'output',me.output);
       
       %ROTATION
       if me.data.rotation.compute == 1,  
           me.rotation = ComputeRotation(me.output, me.data.model.k, me.data.model.coordinates, me.data.rotation.method, me.data.rotation.weights);
           setappdata(0,'rotation',me.rotation);
       end;
       
       clc;
       disp('------------------------------------------------------------------------- ');
       disp(' ');
       disp('             C O R R E S P O N D E N C E      A N A L Y S I S ');
       disp(' ');
       disp(' ');
       disp('                               CAR version 1.03');
       disp(' ');
       disp(' ');
       disp('  by Urbano Lorenzo-Seva  (Rovira i Virgili University, Tarragona, Spain),');
       disp('     Michel van de Velden (Erasmus University, Rotterdam, The Netherlands), &');
       disp('     Henk A. L. Kiers     (University of Groningen, Groningen, The Netherlands)');
       disp(' ');
       disp(' ');
       disp('                           Tarragona (Spain) - 2009 ');
       disp(' ');
       disp(' ');
       me.str=sprintf('                          Data: %s',datestr(now));
       disp(me.str);
       me.str=sprintf('                        Computing time: %.3f seconds',etime(clock,me.t0));
       disp(me.str);
       disp(' ');
       disp(' ');
       disp('------------------------------------------------------------------------- ');
       disp(' ');
                  
       PrintDescriptives(me.output,get(handles.DetailedOutput,'value'));
       PrintCoordinates(me.output,me.data.model.k,me.data.model.coordinates,get(handles.DetailedOutput,'value'));
       if me.data.rotation.compute == 1,  
          PrintRotation(me.rotation,me.data.rotation.method, me.data.rotation.weights, me.output.labels, get(handles.DetailedOutput,'value')); 
       end;
       
   catch
		disp(lasterr);
   end;

   diary off;
   clc;
   me.str=sprintf('system(''notepad %s &'');',char(me.OutputFile));
   eval(me.str);
   set(gcbf,'Pointer','arrow');
   
   if get(handles.ShowMap,'value') == 1,
       map(1,2,0);
   end;
   
   disp('Job done!');
   disp(' ');
   disp(['The output has been saved in file: ''' char(me.OutputFile) '''']);
   disp(' ');
   if exist('tmp.mat','file'), system('del tmp.mat'); end;
   
return;

% --------------------------------------------------------------------
function varargout = WeightsRotation_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = RotationMethod_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = listbox1_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = edit1_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = ColumnVariable_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = CA_CreateFcn(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = DetailedOutput_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = OutputFile_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = NumberOfDimensions_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = RowLabelsVariable_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = ColumnLabelsVariable_Callback(h, eventdata, handles, varargin)
