function CrossTabulateLabels(N,Lr,Lc);
%prints the crosstabulation matrix, and prints the tabulation with labels

if ischar(Lr),
    strR=cellstr(Lr);
else,
    strR=Lr;
end;
if ischar(Lc),
    strC=cellstr(Lc);
else,
    strC=Lc;
end;

[k1,k2]=size(N);
[kR,tmp]=size(strR);
 kR = max([kR;tmp]);
     
if k1~=kR,
    msgbox('Labels do not match with the tabulate data','CAR: Correspondence analysis with rotations','error');
    return;
end;

[kC,tmp]=size(strC);
 kC = max([kC;tmp]);
     
if k2~=kC,
    msgbox('Labels do not match with the tabulate data','CAR: Correspondence analysis with rotations','error');
    return;
end;

sR=0;
for i=1:kR,
    if sR < length(strR{i}),
        sR= length(strR{i});
    end;
end;
if sR>30, sR=30;end;
if sR<9 , sR=9;end;

sC=0;
for i=1:kC,
    if sC < length(strC{i}),
        sC= length(strC{i});
    end;
end;
if sC>10, sC=10;end;
[mC,tmp]=size(num2str(max(max(N)'))');
if sC<(mC+1) , sC=mC+1;end;

maxv =max(max(N)');
if maxv < 1,
   minv =min(min(N)');
   if minv < 0,
      form_n=sprintf('%%% d.%df ',sC,sC-3);
   else,
      form_n=sprintf('%%%d.%df ',sC,sC-2);
   end;
else,
   form_n=sprintf('%%%d.0f ',sC);
end;
    
form=sprintf('%%-%d.%ds ',sR,sR);   
buff=sprintf(form,'Labels');   
form=sprintf('%%%d.%ds ',sC,sC);   
for j=1:kC,
    buff=[ buff form];
    buff=sprintf(buff,strC{j});  
end;
disp(buff);    
disp(' ');
for i=1:kR,
	form=sprintf('%%-%d.%ds ',sR,sR);   
	buff=sprintf(form,strR{i});   
	for j=1:kC,
        buff=[ buff form_n];
        buff=sprintf(buff,N(i,j));  
	end;
	disp(buff);       
end;

return
