%Editable Matlab code for derivative free GP algorithms for 
%rotation. See "http:\\www.stat.ucla/research" for a 
%discussion of these. 
%
%------------------------------------------------------
%The derivative free GP algorithm for quartimin rotation.
%------------------------------------------------------
function [T,ft,table]=GPQmin(B1,B2,T)

al=1;
table=[];
for iter=0:500
    [f,G]=vgfQmin(B1,B2,T);
    Gp=G-T*diag(sum(T.*G));
    s=norm(Gp,'fro');

    table=[table;iter f log10(s) al];
    if s<10^(-5),break,end

    al=2*al;
    for i=0:100
       X=T-al*Gp;
       v=1./sqrt(sum(X.^2));
       Tt=X*diag(v);
	  [ft,Gt]=vgfQmin(B1,B2,Tt);
       if ft<f-.5*s^2*al,break,end
       al=al/2;

     end
    T=Tt;

end
