function PrintContriRotStandCoord(rotation,labels_r,labels_c);
%prints contributions after ortohgonal rotation of standard coordinates
%
%       rotation      The 'rotation' structure generated by ComputeRotation.m
%       labels_r      Row labels
%       labels_c      Column labels
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

      if ischar(labels_r),
         str_r=cellstr(labels_r);
      else,
         str_r=labels_r;
      end;
      
      if ischar(labels_c),
         str_c=cellstr(labels_c);
      else,
         str_c=labels_c;
      end;
      
      [m,tmp]=size(str_r);
      if tmp>m, m=tmp;end;
  	  s1=0;
		  for i=1:m,
          if s1 < length(str_r{i}),
             s1= length(str_r{i});
          end;
	  end;
      
      [m,tmp]=size(str_c);
      if tmp>m, m=tmp;end;
	  s2=0;
		  for i=1:m,
          if s2 < length(str_c{i}),
             s2= length(str_c{i});
          end;
	  end;
      s=max(s1,s2);
	  if s>30, s=30;end;
	  if s<5 , s=5;end;
      
      if rotation.coordinates == 3,
         str_p = str_c;
         str_s = str_r;
      else
         str_p = str_r;
         str_s = str_c;          
      end;
      
      [sp,k]=size(rotation.APCT);
      
	  form=sprintf('%%-%d.%ds        Overall Indices          Dimensions',s,s);   
	  buff=sprintf(form,'Value');   
      disp(buff);    
	  form=sprintf('%%-%d.%ds                                 ',s,s);   
	  buff=sprintf(form,' ');   
      for i=1:k,
          buff1=sprintf('%-3.0f                     ',i);
          buff=[buff buff1];
      end;
      disp(buff);              
	  form=sprintf('%%-%d.%ds------- ------------------------ ',s,s);   
	  buff=sprintf(form,'---------------------------------------------------------------------------------');   
      for i=1:k,
          buff=[buff '----------------------- '];
      end;
      disp(buff);    
	  form=sprintf('%%-%d.%ds        inr      inr%%%%     qlt    ',s,s);   
	  buff=sprintf(form,' ');   
      for i=1:k,
          buff=[buff ' cor     scor    ctr    '];
      end;
      disp(buff);    

      disp(' ');
     
		  form=sprintf('%%-%d.%ds        ',s,s);   
      [sp,k]=size(rotation.APCT);
      for i=1:sp,
	        buff1=sprintf(form,char(str_p(i)));   
            buff2=sprintf('%5.3f    %4.3f     --    ',rotation.IN(i,1),rotation.IN(i,2));
            buff3=[];
            for j=1:k,
               buff4=sprintf('  --      --     %4.3f  ',rotation.APCT(i,j));
               buff3=[buff3 buff4];
            end;
            disp([buff1 buff2 buff3]);          
            
      end;
      disp(' ');
      
		  form=sprintf('%%-%d.%ds        ',s,s);   
      [ss,k]=size(rotation.ASCT);
      for i=1:ss,
	        buff1=sprintf(form,char(str_s(i)));   
            buff2=' --       --       --    ';
            buff3=[];
            for j=1:k,
                buff4=sprintf('  --      --     %4.3f  ',rotation.ASCT(i,j));
                buff3=[buff3 buff4];
            end;
            disp([buff1 buff2 buff3]);          
            
      end;
      disp(' ');

	  form=sprintf('%%-%d.%ds---------------------------------',s,s);   
	  buff=sprintf(form,'------------------------------------------------------------------------------------');   
      for i=1:k,
          buff=[buff '------------------------'];
      end;
      disp(buff);    
      disp(' ');
      disp('inr:  Inertia of each row and column; inr%: Percentage of inertia of each row and column;');
      disp('qlt:  Total quality with respect to the dimensionality of the solution;');
      disp('cor:  Correlations of rows and columns with axes (similar to component loadings in PCA);');
      disp('scor: Contributions of axes to points (squared correlations of points with axes);');
      disp('ctr:  Contributions of points to axes');
      disp(' ');

return;
